/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi.transactional;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.CDI;
import javax.interceptor.InvocationContext;
import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRequiredException;
import javax.transaction.Transactional;
import javax.transaction.TransactionalException;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.CoreUserTransaction;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionRolledbackException;
import org.apache.openejb.loader.SystemInstance;

public abstract class InterceptorBase
implements Serializable {
    private static final IllegalStateException ILLEGAL_STATE_EXCEPTION = new IllegalStateException("Can't use UserTransaction from @Transaction call");
    private static final boolean HANDLE_EXCEPTION_ONLY_FOR_CLIENT = SystemInstance.get().getOptions().get("openejb.cdi.jta.exception.client-only", false);
    private volatile transient ConcurrentMap<Method, Boolean> rollback = new ConcurrentHashMap<Method, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object intercept(InvocationContext ic) throws Exception {
        RuntimeException oldEx;
        IllegalStateException illegalStateException;
        TransactionPolicy policy = null;
        boolean forbidsUt = this.doesForbidUtUsage();
        if (forbidsUt) {
            illegalStateException = ILLEGAL_STATE_EXCEPTION;
            oldEx = CoreUserTransaction.error(illegalStateException);
        } else {
            illegalStateException = null;
            oldEx = null;
        }
        try {
            policy = this.getPolicy();
            Object proceed = ic.proceed();
            policy.commit();
            Object object = proceed;
            return object;
        }
        catch (Exception e) {
            Exception error;
            block26: {
                if (illegalStateException == e) {
                    throw e;
                }
                error = this.unwrap(e);
                if (error != null && (!HANDLE_EXCEPTION_ONLY_FOR_CLIENT || policy.isNewTransaction())) {
                    Boolean doRollback;
                    Method method = ic.getMethod();
                    if (this.rollback == null) {
                        InterceptorBase interceptorBase = this;
                        synchronized (interceptorBase) {
                            if (this.rollback == null) {
                                this.rollback = new ConcurrentHashMap<Method, Boolean>();
                            }
                        }
                    }
                    if ((doRollback = (Boolean)this.rollback.get(method)) != null) {
                        if (doRollback.booleanValue() && policy != null && policy.isTransactionActive()) {
                            policy.setRollbackOnly();
                        }
                    } else {
                        AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(method.getDeclaringClass());
                        Transactional tx = null;
                        for (AnnotatedMethod m : annotatedType.getMethods()) {
                            if (!method.equals(m.getJavaMember())) continue;
                            tx = (Transactional)m.getAnnotation(Transactional.class);
                            break;
                        }
                        if (tx == null) {
                            tx = (Transactional)annotatedType.getAnnotation(Transactional.class);
                        }
                        if (tx != null) {
                            doRollback = new ExceptionPriotiryRules(tx.rollbackOn(), tx.dontRollbackOn()).accept(error, method.getExceptionTypes());
                            this.rollback.putIfAbsent(method, doRollback);
                            if (doRollback.booleanValue() && policy != null && policy.isTransactionActive()) {
                                policy.setRollbackOnly();
                            }
                        }
                    }
                }
                if (policy != null) {
                    try {
                        policy.commit();
                    }
                    catch (Exception ex) {
                        Logger logger = Logger.getLogger(this.getClass().getName());
                        if (!logger.isLoggable(Level.FINE)) break block26;
                        logger.fine("Swallowing: " + ex.getMessage());
                    }
                }
            }
            if (error == null || TransactionRequiredException.class.isInstance(error)) {
                throw new TransactionalException(e.getMessage(), (Throwable)error);
            }
            throw error;
        }
        finally {
            if (forbidsUt) {
                CoreUserTransaction.resetError(oldEx);
            }
        }
    }

    private Exception unwrap(Exception e) {
        Throwable cause;
        Exception error = e;
        while (error != null && (ApplicationException.class.isInstance(error) || SystemException.class.isInstance(error) || TransactionRolledbackException.class.isInstance(error)) && (cause = error.getCause()) != error) {
            error = Exception.class.isInstance(cause) ? (Exception)Exception.class.cast(cause) : null;
        }
        if (RollbackException.class.isInstance(error) && Exception.class.isInstance(error.getCause())) {
            error = (Exception)Exception.class.cast(error.getCause());
        }
        return error;
    }

    protected boolean doesForbidUtUsage() {
        return true;
    }

    protected abstract TransactionPolicy getPolicy() throws SystemException, ApplicationException;

    protected static TransactionManager getTransactionManager() {
        return OpenEJB.getTransactionManager();
    }

    protected static final class ExceptionPriotiryRules {
        private final Class<?>[] includes;
        private final Class<?>[] excludes;

        protected ExceptionPriotiryRules(Class<?>[] includes, Class<?>[] excludes) {
            this.includes = includes;
            this.excludes = excludes;
        }

        public boolean accept(Exception e, Class<?>[] exceptionTypes) {
            if (e == null) {
                return false;
            }
            int includeScore = ExceptionPriotiryRules.contains(this.includes, e);
            int excludeScore = ExceptionPriotiryRules.contains(this.excludes, e);
            if (excludeScore < 0) {
                return includeScore >= 0 || ExceptionPriotiryRules.isNotChecked(e, exceptionTypes);
            }
            return includeScore - excludeScore > 0;
        }

        private static int contains(Class<?>[] list, Exception e) {
            int score = -1;
            for (Class<?> clazz : list) {
                if (!clazz.isInstance(e)) continue;
                int thisScore = ExceptionPriotiryRules.score(clazz, e.getClass());
                score = score < 0 ? thisScore : Math.min(thisScore, score);
            }
            return score;
        }

        private static int score(Class<?> config, Class<?> ex) {
            int score = 0;
            for (Class<?> current = ex; current != null && !current.equals(config); current = current.getSuperclass()) {
                ++score;
            }
            return score;
        }

        private static boolean isNotChecked(Exception e, Class<?>[] exceptionTypes) {
            return RuntimeException.class.isInstance(e) && (exceptionTypes.length == 0 || !Arrays.asList(exceptionTypes).contains(e.getClass()));
        }
    }
}

