/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.api.configuration.ApplicationComposer;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.CompManagedBean;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.testing.Configuration;
import org.apache.openejb.testing.Descriptor;
import org.apache.openejb.testing.Descriptors;
import org.apache.openejb.testing.JaxrsProviders;
import org.apache.openejb.testing.Module;
import org.apache.openejb.util.Classes;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;

public class ApplicationComposerDeployer
implements DynamicDeployer {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        if (!appModule.isStandaloneModule()) {
            return appModule;
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            if (ejbModule.getFinder() == null) continue;
            WebModule webModule = null;
            for (WebModule web : appModule.getWebModules()) {
                if (!web.getModuleId().equals(ejbModule.getModuleId())) continue;
                webModule = web;
                break;
            }
            if (webModule == null) continue;
            for (Class clazz : ejbModule.getFinder().findAnnotatedClasses(ApplicationComposer.class)) {
                org.apache.openejb.testing.Classes classes;
                Descriptors descriptors;
                ApplicationComposer applicationComposer = clazz.getAnnotation(ApplicationComposer.class);
                Descriptor descriptor = clazz.getAnnotation(Descriptor.class);
                if (descriptor != null) {
                    this.configureDescriptor(appModule, descriptor);
                }
                if ((descriptors = clazz.getAnnotation(Descriptors.class)) != null) {
                    for (Descriptor d : descriptors.value()) {
                        this.configureDescriptor(appModule, descriptor);
                    }
                }
                if ((classes = clazz.getAnnotation(org.apache.openejb.testing.Classes.class)) != null) {
                    this.configureClasses(webModule, ejbModule, applicationComposer, classes);
                }
                Object instance = null;
                AnnotationFinder finder = new AnnotationFinder((Archive)new ClassesArchive(Classes.ancestors(clazz)));
                for (Method m : finder.findAnnotatedMethods(Module.class)) {
                    instance = this.configureModule(appModule, ejbModule, clazz, instance, m);
                }
                for (Method m : finder.findAnnotatedMethods(Configuration.class)) {
                    instance = this.configureConfiguration(appModule, clazz, instance, m);
                }
                JaxrsProviders jaxrsProviders = clazz.getAnnotation(JaxrsProviders.class);
                if (jaxrsProviders == null) continue;
                for (Class<?> c : jaxrsProviders.value()) {
                    webModule.getJaxrsProviders().add(c.getName());
                }
            }
        }
        return appModule;
    }

    private Object configureConfiguration(AppModule appModule, Class<?> clazz, Object instance, Method m) {
        int modifiers = m.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw new IllegalArgumentException("@Configuration should be public");
        }
        boolean isStatic = Modifier.isStatic(modifiers);
        if (!isStatic) {
            try {
                instance = clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Object result = m.invoke(isStatic ? null : instance, new Object[0]);
            if (!Properties.class.isInstance(result)) {
                throw new IllegalArgumentException(result + " not yet supported (" + m + ")");
            }
            appModule.getProperties().putAll((Map<?, ?>)((Map)Properties.class.cast(result)));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return instance;
    }

    private Object configureModule(AppModule appModule, EjbModule ejbModule, Class<?> clazz, Object instance, Method m) {
        block11: {
            int modifiers = m.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                throw new IllegalArgumentException("@Module should be public");
            }
            boolean isStatic = Modifier.isStatic(modifiers);
            if (!isStatic) {
                try {
                    instance = clazz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Object result = m.invoke(isStatic ? null : instance, new Object[0]);
                if (EjbJar.class.isInstance(result)) {
                    ejbModule.setEjbJar((EjbJar)EjbJar.class.cast(result));
                    break block11;
                }
                if (Persistence.class.isInstance(result)) {
                    Persistence persistence = (Persistence)Persistence.class.cast(result);
                    if (!persistence.getPersistenceUnit().isEmpty()) {
                        appModule.getPersistenceModules().add(new PersistenceModule(appModule, this.rootUrl(ejbModule), persistence));
                    }
                    break block11;
                }
                if (PersistenceUnit.class.isInstance(result)) {
                    PersistenceUnit unit = (PersistenceUnit)PersistenceUnit.class.cast(result);
                    appModule.addPersistenceModule(new PersistenceModule(appModule, this.rootUrl(ejbModule), new Persistence(new PersistenceUnit[]{unit})));
                    break block11;
                }
                if (Beans.class.isInstance(result)) {
                    Beans beans = (Beans)Beans.class.cast(result);
                    ejbModule.setBeans(beans);
                    break block11;
                }
                throw new IllegalArgumentException(result + " not yet supported (" + m + ")");
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        return instance;
    }

    private String rootUrl(EjbModule ejbModule) {
        try {
            return ejbModule.getModuleUri().toURL().toExternalForm();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void configureClasses(WebModule web, EjbModule ejbModule, ApplicationComposer applicationComposer, org.apache.openejb.testing.Classes classes) {
        ejbModule.getEjbJar().setMetadataComplete(Boolean.valueOf(applicationComposer.metadataComplete()));
        LinkedList<ClassesArchive> archives = new LinkedList<ClassesArchive>();
        if (classes.value().length > 0) {
            archives.add(new ClassesArchive((Class[])classes.value()));
        }
        if (classes.cdi()) {
            Beans beans = new Beans();
            for (Class<?> c : classes.cdiAlternatives()) {
                beans.addAlternativeClass(c);
            }
            for (Class<?> c : classes.cdiDecorators()) {
                beans.addDecorator(c);
            }
            for (Class<?> c : classes.cdiInterceptors()) {
                beans.addInterceptor(c);
            }
            ejbModule.setBeans(beans);
            if (applicationComposer.metadataComplete()) {
                for (Class<?> c : classes.value()) {
                    beans.addManagedClass(null, c.getName());
                }
                String name = BeanContext.Comp.openejbCompName(web.getModuleId());
                CompManagedBean managedBean = new CompManagedBean(name, BeanContext.Comp.class);
                managedBean.setTransactionType(TransactionType.BEAN);
                ejbModule.getEjbJar().addEnterpriseBean((EnterpriseBean)managedBean);
            }
        }
        CompositeArchive archive = new CompositeArchive(archives);
        CompositeArchive finalArchive = classes.excludes().length > 0 ? new FilteredArchive((Archive)archive, Filters.invert((Filter)Filters.prefixes((String[])classes.excludes()))) : archive;
        ejbModule.setFinder((IAnnotationFinder)new FinderFactory.OpenEJBAnnotationFinder((Archive)finalArchive).link());
        web.setFinder(ejbModule.getFinder());
        web.getWebApp().setMetadataComplete(ejbModule.getEjbJar().isMetadataComplete());
    }

    private void configureDescriptor(AppModule appModule, Descriptor descriptor) {
        URL resource = appModule.getClassLoader().getResource(descriptor.path());
        try {
            appModule.getAltDDs().put(descriptor.name(), resource == null ? new File(descriptor.path()).toURI().toURL() : resource);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

