/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.openejb.config.SystemProperty;
import org.apache.openejb.config.sys.AbstractService;
import org.apache.openejb.config.sys.PropertiesAdapter;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.Service;
import org.apache.openejb.util.Join;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StackHandler
extends DefaultHandler {
    private static final boolean DEBUG = Boolean.getBoolean("openejb.sax.debug");
    private final List<DefaultHandler> handlers = new LinkedList<DefaultHandler>();

    protected DefaultHandler get() {
        return this.handlers.get(0);
    }

    protected DefaultHandler pop() {
        return this.handlers.remove(0);
    }

    protected void checkAttributes(Attributes attributes, String ... allowed) throws SAXException {
        this.checkAttributes(attributes, Arrays.asList(allowed));
    }

    protected void checkAttributes(Attributes attributes, List<String> allowed) throws SAXException {
        ArrayList<String> invalid = new ArrayList<String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (allowed.contains(attributes.getLocalName(i))) continue;
            invalid.add(attributes.getLocalName(i));
        }
        if (invalid.size() > 0) {
            throw new SAXException("Unsupported Attribute(s): " + Join.join(", ", invalid) + ".  Supported Attributes are: " + Join.join(", ", allowed) + ".  If the setting is a configuration property it must be placed inside the element body.");
        }
    }

    protected void push(DefaultHandler handler) {
        if (DEBUG) {
            for (DefaultHandler ignored : this.handlers) {
                System.out.print("  ");
            }
            System.out.println("+ " + handler);
        }
        this.handlers.add(0, handler);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (DEBUG) {
            for (DefaultHandler ignored : this.handlers) {
                System.out.print("  ");
            }
            System.out.println("> " + this.get());
        }
        this.get().startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.get().endElement(uri, localName, qName);
        if (!DEBUG) {
            this.pop();
        } else {
            for (DefaultHandler ignored : this.handlers) {
                System.out.print("  ");
            }
            System.out.println(" - " + this.pop());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.get().characters(ch, start, length);
    }

    public class DeclaredServiceElement
    extends ServiceElement<Service> {
        private final Collection<Service> services;

        public DeclaredServiceElement(Collection<Service> services) {
            super(StackHandler.this, (AbstractService)new Service());
            this.services = services;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            ((Service)this.service).setClazz(attributes.getValue("class"));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.services.add((Service)this.service);
            super.endElement(uri, localName, qName);
        }

        @Override
        protected List<String> getAttributes() {
            List<String> attributes = super.getAttributes();
            attributes.add("class");
            return attributes;
        }
    }

    public class ResourceElement
    extends ServiceElement<Resource> {
        private final Collection<Resource> resources;

        public ResourceElement(Collection<Resource> resources) {
            super(StackHandler.this, (AbstractService)new Resource());
            this.resources = resources;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String dependsOn;
            String aliases;
            super.startElement(uri, localName, qName, attributes);
            ((Resource)this.service).setJndi(attributes.getValue("jndi"));
            ((Resource)this.service).setPostConstruct(attributes.getValue("post-construct"));
            ((Resource)this.service).setPreDestroy(attributes.getValue("pre-destroy"));
            ((Resource)this.service).setTemplate(attributes.getValue("template"));
            ((Resource)this.service).setPropertiesProvider(attributes.getValue("property-provider"));
            if (((Resource)this.service).getPropertiesProvider() == null) {
                ((Resource)this.service).setPropertiesProvider(attributes.getValue("properties-provider"));
            }
            if ((aliases = attributes.getValue("aliases")) != null) {
                ((Resource)this.service).getAliases().addAll(Arrays.asList(aliases.split(",")));
            }
            if ((dependsOn = attributes.getValue("depends-on")) != null) {
                ((Resource)this.service).getDependsOn().addAll(Arrays.asList(dependsOn.split(",")));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.resources.add((Resource)this.service);
            super.endElement(uri, localName, qName);
        }

        @Override
        protected List<String> getAttributes() {
            List<String> attributes = super.getAttributes();
            attributes.add("jndi");
            attributes.add("aliases");
            attributes.add("properties-provider");
            attributes.add("property-provider");
            attributes.add("depends-on");
            return attributes;
        }
    }

    public static abstract class ServiceElement<S extends AbstractService>
    extends Content {
        final S service;
        final /* synthetic */ StackHandler this$0;

        protected ServiceElement(S service) {
            this.this$0 = var1_1;
            this.service = service;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (attributes.getValue("type") != null) {
                ((AbstractService)this.service).setType(attributes.getValue("type"));
            }
            if (attributes.getValue("jar") != null) {
                ((AbstractService)this.service).setJar(attributes.getValue("jar"));
            }
            if (attributes.getValue("provider") != null) {
                ((AbstractService)this.service).setProvider(attributes.getValue("provider"));
            }
            if (attributes.getValue("id") != null) {
                ((AbstractService)this.service).setId(attributes.getValue("id"));
            }
            if (attributes.getValue("class-name") != null) {
                ((AbstractService)this.service).setClassName(attributes.getValue("class-name"));
            }
            if (attributes.getValue("constructor") != null) {
                ((AbstractService)this.service).setConstructor(attributes.getValue("constructor"));
            }
            if (attributes.getValue("factory-name") != null) {
                ((AbstractService)this.service).setFactoryName(attributes.getValue("factory-name"));
            }
            if (attributes.getValue("classpath") != null) {
                ((AbstractService)this.service).setClasspath(attributes.getValue("classpath"));
            }
            if (attributes.getValue("classpath-api") != null) {
                ((AbstractService)this.service).setClasspathAPI(attributes.getValue("classpath-api"));
            }
            this.this$0.checkAttributes(attributes, this.getAttributes());
        }

        protected List<String> getAttributes() {
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("type");
            attributes.add("jar");
            attributes.add("provider");
            attributes.add("id");
            attributes.add("class-name");
            attributes.add("constructor");
            attributes.add("factory-name");
            attributes.add("classpath");
            return attributes;
        }

        @Override
        public void setValue(String text) {
            try {
                ((AbstractService)this.service).getProperties().putAll((Map<?, ?>)new PropertiesAdapter().unmarshal(text));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class SystemPropertyElement
    extends Content {
        private final List<String> allowed;
        private final SystemProperty built;
        private final List<SystemProperty> list;

        public SystemPropertyElement(List<SystemProperty> systemProperties) {
            this.allowed = Arrays.asList("name", "value");
            this.list = systemProperties;
            this.built = new SystemProperty();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            this.built.setName(attributes.getValue("name"));
            this.built.setValue(attributes.getValue("value"));
            StackHandler.this.checkAttributes(attributes, this.allowed);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.list.add(this.built);
            super.endElement(uri, localName, qName);
        }
    }

    public class Content
    extends DefaultHandler {
        private StringBuilder characters = new StringBuilder();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.characters = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.characters.append(new String(ch, start, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.setValue(this.characters.toString());
        }

        public void setValue(String text) {
        }
    }
}

