/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.dbcp;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.managed.ManagedConnection;
import org.apache.commons.dbcp2.managed.ManagedDataSource;
import org.apache.commons.dbcp2.managed.TransactionRegistry;
import org.apache.commons.pool2.ObjectPool;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.resource.jdbc.IsolationLevels;
import org.apache.openejb.resource.jdbc.dbcp.DataSourceSerialization;
import org.apache.openejb.resource.jdbc.dbcp.JMXBasicDataSource;
import org.apache.openejb.resource.jdbc.pool.XADataSourceResource;

public class BasicManagedDataSource
extends org.apache.commons.dbcp2.managed.BasicManagedDataSource
implements Serializable {
    private static final ReentrantLock lock = new ReentrantLock();
    private final String name;
    private Logger logger;
    private String passwordCipher;
    private String initialPassword;
    private JMXBasicDataSource jmxDs;

    public BasicManagedDataSource(String name) {
        this.registerAsMbean(name);
        this.name = name;
    }

    protected DataSource createDataSourceInstance() throws SQLException {
        final TransactionRegistry transactionRegistry = this.getTransactionRegistry();
        if (transactionRegistry == null) {
            throw new IllegalStateException("TransactionRegistry has not been set");
        }
        if (this.getConnectionPool() == null) {
            throw new IllegalStateException("Pool has not been set");
        }
        ManagedDataSource<PoolableConnection> pds = new ManagedDataSource<PoolableConnection>((ObjectPool)this.getConnectionPool(), transactionRegistry){

            public Connection getConnection() throws SQLException {
                return new ManagedConnection<PoolableConnection>(this.getPool(), transactionRegistry, this.isAccessToUnderlyingConnectionAllowed()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() throws SQLException {
                        if (!this.isClosedInternal()) {
                            try {
                                if (null != this.getDelegateInternal()) {
                                    super.close();
                                }
                            }
                            finally {
                                this.setClosedInternal(true);
                            }
                        }
                    }

                    public boolean isClosed() throws SQLException {
                        return this.isClosedInternal() || null != this.getDelegateInternal() && ((PoolableConnection)this.getDelegateInternal()).isClosed();
                    }
                };
            }
        };
        pds.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        return pds;
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        String xaDataSource = this.getXADataSource();
        if (xaDataSource != null & this.getXaDataSourceInstance() == null) {
            try {
                try {
                    Thread.currentThread().getContextClassLoader().loadClass(xaDataSource);
                }
                catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
                    this.setJndiXaDataSource(xaDataSource);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.createConnectionFactory();
    }

    private void setJndiXaDataSource(String xaDataSource) {
        this.setXaDataSourceInstance(XADataSourceResource.proxy(this.getDriverClassLoader() != null ? this.getDriverClassLoader() : Thread.currentThread().getContextClassLoader(), xaDataSource));
        if (this.getTransactionManager() == null) {
            this.setTransactionManager(OpenEJB.getTransactionManager());
        }
    }

    private void registerAsMbean(String name) {
        try {
            this.jmxDs = new JMXBasicDataSource(name, (BasicDataSource)this);
        }
        catch (Exception | NoClassDefFoundError e) {
            this.jmxDs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPasswordCipher() {
        ReentrantLock l = lock;
        l.lock();
        try {
            String string = this.passwordCipher;
            return string;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordCipher(String passwordCipher) {
        ReentrantLock l = lock;
        l.lock();
        try {
            this.passwordCipher = passwordCipher;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        ReentrantLock l = lock;
        l.lock();
        try {
            this.initialPassword = password;
            super.setPassword(password);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() {
        ReentrantLock l = lock;
        l.lock();
        try {
            String string = super.getUsername();
            return string;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserName(String string) {
        ReentrantLock l = lock;
        l.lock();
        try {
            super.setUsername(string);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJdbcDriver() {
        ReentrantLock l = lock;
        l.lock();
        try {
            String string = super.getDriverClassName();
            return string;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJdbcDriver(String string) {
        ReentrantLock l = lock;
        l.lock();
        try {
            super.setDriverClassName(string);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJdbcUrl() {
        ReentrantLock l = lock;
        l.lock();
        try {
            String string = super.getUrl();
            return string;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJdbcUrl(String string) {
        ReentrantLock l = lock;
        l.lock();
        try {
            super.setUrl(string);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultTransactionIsolation(String s) {
        ReentrantLock l = lock;
        l.lock();
        try {
            if (s == null || s.equals("")) {
                return;
            }
            int level2 = IsolationLevels.getIsolationLevel(s);
            super.setDefaultTransactionIsolation(level2);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxWait(int maxWait) {
        ReentrantLock l = lock;
        l.lock();
        try {
            super.setMaxWaitMillis((long)maxWait);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    protected DataSource createDataSource() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void wrapTransactionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        ReentrantLock l = lock;
        l.lock();
        try {
            try {
                this.unregisterMBean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.close();
        }
        finally {
            l.unlock();
        }
    }

    private void unregisterMBean() {
        if (this.jmxDs != null) {
            this.jmxDs.unregister();
        }
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        ReentrantLock l = lock;
        l.lock();
        try {
            if (null == this.logger) {
                this.logger = (Logger)DataSource.class.getDeclaredMethod("getParentLogger", new Class[0]).invoke((Object)this.createDataSource(), new Object[0]);
            }
            Logger logger = this.logger;
            return logger;
        }
        catch (Throwable e) {
            throw new SQLFeatureNotSupportedException();
        }
        finally {
            l.unlock();
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        return name;
    }

    Object writeReplace() throws ObjectStreamException {
        return new DataSourceSerialization(this.name);
    }
}

