/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.router;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.router.AbstractRouter;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class FailOverRouter
extends AbstractRouter {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB_SERVER, FailOverRouter.class);
    public static final String DEFAULT_STRATEGY = "default";
    private ExceptionSelector exceptionSelectorRuntime;
    private ErrorHandler errorHandlerRuntime;
    private Strategy strategyRuntime;
    private DataSource facade;
    private final List<DataSourceHolder> dataSources = new CopyOnWriteArrayList<DataSourceHolder>();
    private String delimiter = ",";
    private String strategy = "default";
    private String datasourceNames = "";

    @Override
    public DataSource getDataSource() {
        return this.facade;
    }

    @PostConstruct
    public void init() {
        this.initDataSources();
        this.initStrategy();
        this.initFacade();
    }

    public void setDatasourceNames(String datasourceNames) {
        this.datasourceNames = datasourceNames;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public void setStrategyInstance(Strategy strategy) {
        this.strategyRuntime = strategy;
    }

    public void setExceptionSelectorInstance(ExceptionSelector selector) {
        this.exceptionSelectorRuntime = selector;
    }

    public void setExceptionSelector(String selector) {
        try {
            this.exceptionSelectorRuntime = "mysql".equalsIgnoreCase(selector) ? new MySQLExceptionSelector() : (ExceptionSelector)ExceptionSelector.class.cast(Thread.currentThread().getContextClassLoader().loadClass(selector.trim()).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setErrorHandlerInstance(ErrorHandler errorHandler) {
        this.errorHandlerRuntime = errorHandler;
    }

    public void setErrorHandler(String errorHandler) {
        try {
            this.errorHandlerRuntime = (ErrorHandler)ErrorHandler.class.cast(Thread.currentThread().getContextClassLoader().loadClass(errorHandler.trim()).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void initStrategy() {
        switch (this.strategy) {
            case "round-robin": {
                this.strategyRuntime = new Strategy(){
                    private final AtomicInteger idx = new AtomicInteger(0);

                    @Override
                    public Collection<DataSourceHolder> prepare(Collection<DataSourceHolder> list) {
                        int step = FailOverRouter.this.strategy.contains("%") ? Math.max(1, Integer.parseInt(FailOverRouter.this.strategy.substring(FailOverRouter.this.strategy.lastIndexOf("%") + 1))) : 1;
                        ArrayList<DataSourceHolder> ds = new ArrayList<DataSourceHolder>(list);
                        int currentIdx = 0;
                        for (int i = 0; i < step; ++i) {
                            currentIdx = this.idx.incrementAndGet();
                        }
                        Collections.rotate(ds, 1 + currentIdx % ds.size());
                        return ds;
                    }

                    @Override
                    public void used(DataSourceHolder holder) {
                    }
                };
                break;
            }
            case "random": {
                this.strategyRuntime = new Strategy(){

                    @Override
                    public Collection<DataSourceHolder> prepare(Collection<DataSourceHolder> list) {
                        ArrayList<DataSourceHolder> ds = new ArrayList<DataSourceHolder>(list);
                        Collections.shuffle(ds);
                        return ds;
                    }

                    @Override
                    public void used(DataSourceHolder holder) {
                    }
                };
                break;
            }
            case "reverse": {
                this.strategyRuntime = new Strategy(){
                    private final AtomicInteger idx = new AtomicInteger();

                    @Override
                    public Collection<DataSourceHolder> prepare(Collection<DataSourceHolder> list) {
                        ArrayList<DataSourceHolder> ds = new ArrayList<DataSourceHolder>(list);
                        int times = this.idx.incrementAndGet() % ds.size();
                        for (int i = 0; i < times; ++i) {
                            Collections.reverse(ds);
                        }
                        return ds;
                    }

                    @Override
                    public void used(DataSourceHolder holder) {
                    }
                };
                break;
            }
            case "static": {
                this.strategyRuntime = new Strategy(){

                    @Override
                    public Collection<DataSourceHolder> prepare(Collection<DataSourceHolder> list) {
                        return list;
                    }

                    @Override
                    public void used(DataSourceHolder holder) {
                    }
                };
                break;
            }
            default: {
                this.strategyRuntime = new Strategy(){

                    @Override
                    public Collection<DataSourceHolder> prepare(Collection<DataSourceHolder> list) {
                        return list;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void used(DataSourceHolder holder) {
                        if (FailOverRouter.this.dataSources.get(0) == holder) {
                            return;
                        }
                        5 var2_2 = this;
                        synchronized (var2_2) {
                            if (FailOverRouter.this.dataSources.get(0) == holder) {
                                return;
                            }
                            DataSourceHolder old = FailOverRouter.this.dataSources.set(0, holder);
                            if (old != holder) {
                                FailOverRouter.this.dataSources.set(FailOverRouter.this.dataSources.lastIndexOf(holder), old);
                            }
                        }
                    }
                };
            }
        }
    }

    private void initDataSources() {
        this.dataSources.clear();
        for (String ds : this.datasourceNames.split(Pattern.quote(this.delimiter))) {
            try {
                String name = ds.trim();
                Object o = this.getOpenEJBResource(name);
                if (!DataSource.class.isInstance(o)) {
                    throw new IllegalArgumentException(name + " (" + o + ") is not a datasource");
                }
                LOGGER.debug("Found datasource '" + ds + "'");
                this.dataSources.add(new DataSourceHolder((DataSource)DataSource.class.cast(o), name));
            }
            catch (NamingException error) {
                throw new IllegalStateException(error);
            }
        }
        this.initFacade();
    }

    private void initFacade() {
        this.facade = (DataSource)DataSource.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)new FacadeHandler(this.dataSources, this.strategyRuntime, this.errorHandlerRuntime, this.exceptionSelectorRuntime)));
    }

    public Collection<DataSourceHolder> getDataSources() {
        return this.dataSources;
    }

    public void updateDataSources(Collection<DataSourceHolder> ds) {
        this.dataSources.clear();
        this.dataSources.addAll(ds);
        this.initFacade();
    }

    public static final class DataSourceHolder {
        private final DataSource dataSource;
        private final String name;

        public DataSourceHolder(DataSource dataSource, String name) {
            this.dataSource = dataSource;
            this.name = name;
        }
    }

    public static interface Strategy {
        public Collection<DataSourceHolder> prepare(Collection<DataSourceHolder> var1);

        public void used(DataSourceHolder var1);
    }

    public static interface ErrorHandler {
        public void onError(Map<String, Throwable> var1, DataSourceHolder var2);
    }

    public class MySQLExceptionSelector
    extends SQLExceptionSelector {
        private final Class<?> communicationException;

        public MySQLExceptionSelector() {
            try {
                this.communicationException = Thread.currentThread().getContextClassLoader().loadClass("com.mysql.jdbc.CommunicationsException");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("com.mysql.jdbc.CommunicationsException not available, please use another ExceptionSelector");
            }
        }

        @Override
        public boolean shouldFailover(SQLException ex) {
            String sqlState = ex.getSQLState();
            return sqlState != null && sqlState.startsWith("08") || this.communicationException.isInstance(ex);
        }
    }

    public abstract class SQLExceptionSelector
    implements ExceptionSelector {
        @Override
        public boolean shouldFailover(Throwable sqle) {
            return SQLException.class.isInstance(sqle) && this.shouldFailover((SQLException)SQLException.class.cast(sqle));
        }

        abstract boolean shouldFailover(SQLException var1);
    }

    public static interface ExceptionSelector {
        public boolean shouldFailover(Throwable var1);
    }

    private static class FacadeHandler
    implements InvocationHandler {
        private static final TransactionSynchronizationRegistry SYNCHRONIZATION_REGISTRY = SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
        private final TransactionManager transactionManager;
        private final Collection<DataSourceHolder> delegates;
        private final Strategy strategy;
        private final ErrorHandler handler;
        private final ExceptionSelector selector;

        public FacadeHandler(Collection<DataSourceHolder> dataSources, Strategy strategy, ErrorHandler handler, ExceptionSelector selector) {
            this.delegates = dataSources;
            this.strategy = strategy;
            this.handler = handler;
            this.selector = selector;
            this.transactionManager = OpenEJB.getTransactionManager();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            DataSource currentDs;
            Transaction transaction;
            if (Object.class.equals(method.getDeclaringClass())) {
                if ("toString".equals(method.getName())) {
                    return "DataSourceFacade" + this.delegates;
                }
                if ("hashCode".equals(method.getName())) {
                    return this.delegates.hashCode();
                }
                if ("equals".equals(method.getName())) {
                    return method.invoke((Object)this, args);
                }
            }
            if ((transaction = this.transactionManager.getTransaction()) != null && (currentDs = (DataSource)DataSource.class.cast(SYNCHRONIZATION_REGISTRY.getResource((Object)FacadeHandler.class.getName()))) != null) {
                return method.invoke((Object)currentDs, args);
            }
            int ex = 0;
            Collection<DataSourceHolder> sources = this.strategy.prepare(this.delegates);
            int size = sources.size();
            Object out = null;
            HashMap<String, Throwable> failed = null;
            DataSourceHolder used = null;
            Iterator<DataSourceHolder> i$ = sources.iterator();
            while (i$.hasNext()) {
                DataSourceHolder ds;
                used = ds = i$.next();
                try {
                    boolean set = method.getName().startsWith("set");
                    if (set) {
                        method.invoke((Object)ds.dataSource, args);
                    } else {
                        out = method.invoke((Object)ds.dataSource, args);
                    }
                    if (transaction != null) {
                        SYNCHRONIZATION_REGISTRY.putResource((Object)FacadeHandler.class.getName(), (Object)ds.dataSource);
                        break;
                    }
                    if (set) continue;
                    break;
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getTargetException();
                    if (this.selector != null && !this.selector.shouldFailover(cause)) {
                        if (failed != null) {
                            this.handler.onError(failed, ds);
                        }
                        throw cause;
                    }
                    if (this.handler != null) {
                        if (failed == null) {
                            failed = new HashMap<String, Throwable>();
                        }
                        failed.put(ds.name, ite.getCause());
                    }
                    if (++ex != size) continue;
                    if (failed != null) {
                        this.handler.onError(failed, null);
                    }
                    throw ite.getCause();
                }
            }
            if (failed != null) {
                this.handler.onError(failed, used);
            }
            this.strategy.used(used);
            return out;
        }
    }
}

