/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.impl.bridge;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassloadingBridge {
    static final String EXCEPTION_WHILE_INVOKING_METHOD_MESSAGE = "Exception while invoking method: ";
    static final String CALL_PROHIBITED = "It's not allowed to use ClassloadingBridge class from ";
    static final String CLASSLOADER_NOT_INITIALIZED = "Implementation classloader is not initialized";
    static final String CLASS_OR_METHOD_NULL = "Class [%s] and method to be invoked [%s] should not be null.";
    static final String CATALINA_HOME = "catalina.home";
    static final String IMPLEMENTATION_FOLDER = "impl";
    static final String ACCEPTED_CALLERS_KEY = "classloading.bridge.accepted.callers";
    static final String APPLICATION_ACCEPTED_CALLERS_KEY = "classloading.bridge.allow.unauthorized.calls.from.app";
    private static CallStackSecurityManager securityManagerForCheckingTheCaller = new CallStackSecurityManager();
    private static Logger logger = LoggerFactory.getLogger(ClassloadingBridge.class);
    private static URLClassLoader implClassLoader = null;
    private static Set<String> acceptedCallers = null;
    private static final String ACCEPTED_CALLERS_LIST_DELIMITER = ",";
    private static final int INVOCATION_DEPTH_IN_CURRENT_CLASS = 3;

    static {
        ClassloadingBridge.createClassLoader();
        ClassloadingBridge.initializeAcceptedCallers();
    }

    static void createClassLoader() {
        String configHome = (String)System.getProperties().get(CATALINA_HOME);
        File file = new File(configHome, IMPLEMENTATION_FOLDER);
        File[] classpath = file.listFiles();
        if (classpath != null) {
            URL[] urls = new URL[classpath.length];
            if (logger.isDebugEnabled()) {
                logger.debug("Creating implementation loader...");
            }
            int i = 0;
            while (i < classpath.length) {
                try {
                    urls[i] = classpath[i].toURL();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Adding url " + urls[i]);
                    }
                }
                catch (MalformedURLException e) {
                    logger.error("Unable to add " + classpath[i] + "to implementation loader", (Throwable)e);
                }
                ++i;
            }
            implClassLoader = new URLClassLoader(urls, ClassloadingBridge.class.getClassLoader());
            if (logger.isDebugEnabled()) {
                logger.debug("Implementation loader created.");
            }
        } else {
            logger.debug("Unable to list implementation folder " + file.getAbsolutePath());
        }
    }

    public static ClassLoader getImplClassLoader() {
        ClassloadingBridge.checkAccess();
        if (implClassLoader == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Implementation loader is null, the loader of current class will be used instead.");
            }
            return ClassloadingBridge.class.getClassLoader();
        }
        return implClassLoader;
    }

    public static Object invokeMethod(Class clazz, Object instance, String methodName, Class[] paramTypes, Object[] params) {
        ClassloadingBridge.checkAccess();
        if (logger.isDebugEnabled()) {
            logger.debug(ClassloadingBridge.getParamsValuesAsString(clazz, instance, methodName, paramTypes, params));
        }
        if (clazz == null || methodName == null) {
            throw new IllegalStateException(String.format(CLASS_OR_METHOD_NULL, clazz, methodName));
        }
        Method method = null;
        boolean isAccessible = false;
        try {
            method = clazz.getDeclaredMethod(methodName, paramTypes);
            if (logger.isDebugEnabled()) {
                logger.debug("Method " + methodName + " obtained");
            }
            if (!(isAccessible = method.isAccessible())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Trying to set method " + methodName + " to be accessible...");
                }
                method.setAccessible(true);
                if (logger.isDebugEnabled()) {
                    logger.debug("Method " + methodName + " is set to be accessible");
                }
            }
            if (instance != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Method " + methodName + " will be invoked on instance " + instance);
                }
                Object object = method.invoke(instance, params);
                return object;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Method " + methodName + " will be invoked on class " + clazz);
            }
            Object object = method.invoke((Object)clazz, params);
            return object;
        }
        catch (Exception e) {
            throw new IllegalStateException(EXCEPTION_WHILE_INVOKING_METHOD_MESSAGE + ClassloadingBridge.getParamsValuesAsString(clazz, instance, methodName, paramTypes, params), e);
        }
        finally {
            if (method != null && !isAccessible) {
                method.setAccessible(false);
                if (logger.isDebugEnabled()) {
                    logger.debug("Method " + methodName + " is reset to be inaccessible as it was");
                }
            }
        }
    }

    protected static String getParamsValuesAsString(Class clazz, Object instance, String methodName, Class[] paramTypes, Object[] params) {
        return String.valueOf(String.format("Class [%s], Instance [%s], method [%s]", clazz, instance, methodName)) + " param types " + (paramTypes == null ? null : Arrays.asList(paramTypes)) + " params " + (params == null ? null : Arrays.asList(params));
    }

    static void initializeAcceptedCallers() {
        if (acceptedCallers != null) {
            logger.error("Classloading bridge accepted callers list should not be modified once initialized");
        }
        HashSet<String> allCallers = new HashSet<String>();
        String systemCallers = System.getProperty(ACCEPTED_CALLERS_KEY);
        if (systemCallers == null || systemCallers.isEmpty()) {
            logger.error("No accepted callers list specified; the calls to the classloading bridge will fail");
        } else {
            allCallers.addAll(Arrays.asList(systemCallers.split(ACCEPTED_CALLERS_LIST_DELIMITER)));
        }
        String applicationCallers = System.getProperty(APPLICATION_ACCEPTED_CALLERS_KEY);
        if (applicationCallers != null && !applicationCallers.isEmpty()) {
            logger.warn("Application demands explicit access from " + applicationCallers + " to platform internal resources (classes, etc) that are not part of the officially supported SAP Cloud Platform API. This could cause compatibility issues in the future.");
            allCallers.addAll(Arrays.asList(applicationCallers.split(ACCEPTED_CALLERS_LIST_DELIMITER)));
        }
        acceptedCallers = Collections.unmodifiableSet(allCallers);
        if (logger.isDebugEnabled()) {
            logger.debug("Accepted callers: " + systemCallers);
            logger.debug("Application accepted callers: " + applicationCallers);
        }
    }

    private static void checkAccess() {
        Class[] classStack = securityManagerForCheckingTheCaller.getCallStack();
        if (classStack != null && classStack.length > 3) {
            String caller = classStack[3].getName();
            if (!acceptedCallers.contains(caller)) {
                if (logger.isWarnEnabled()) {
                    logger.warn(CALL_PROHIBITED + caller + ". Allowed callers are:  " + acceptedCallers);
                }
                throw new IllegalStateException(CALL_PROHIBITED + caller);
            }
        } else {
            List<Class> callStackList;
            List<Class> list = callStackList = classStack == null ? null : Arrays.asList(classStack);
            if (logger.isWarnEnabled()) {
                logger.warn(CALL_PROHIBITED + callStackList + ". Allowed callers are:  " + acceptedCallers);
            }
            throw new IllegalStateException(CALL_PROHIBITED + callStackList);
        }
    }

    static Set<String> getAcceptedCallers() {
        return acceptedCallers;
    }

    private static class CallStackSecurityManager
    extends SecurityManager {
        private CallStackSecurityManager() {
        }

        public Class[] getCallStack() {
            return this.getClassContext();
        }
    }
}

