/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.api;

import com.sap.core.connectivity.tunnel.api.LookupException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;

class TunnelServiceRegistry<ServiceT> {
    private static final Logger log = Logger.getLogger(TunnelServiceRegistry.class);
    private final Map<Class<? extends ServiceT>, ServiceT> cachedServices = new HashMap<Class<? extends ServiceT>, ServiceT>();

    TunnelServiceRegistry() {
    }

    public synchronized <T extends ServiceT> T getService(Class<T> serviceClass) {
        Object service = this.cachedServices.get(serviceClass);
        if (service == null) {
            service = this.loadService(serviceClass);
            this.cachedServices.put(serviceClass, service);
        }
        return (T)service;
    }

    public synchronized <T extends ServiceT> void registerService(Class<T> serviceClass, T service) {
        this.cachedServices.put(serviceClass, service);
    }

    public synchronized <T extends ServiceT> void clear() {
        this.cachedServices.clear();
    }

    private <T extends ServiceT> T loadService(Class<T> serviceClass) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(serviceClass);
        Iterator<T> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            T serviceObject = iterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found tunnel service implementation: " + serviceObject.getClass().getName()));
            }
            return serviceObject;
        }
        throw new LookupException("Unable to find tunnel service implementation for " + serviceClass.getName());
    }
}

