/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.api.management;

import com.sap.core.connectivity.tunnel.api.management.TracingConfiguration;
import com.sap.core.connectivity.tunnel.api.management.TracingConfigurationChangeEvent;
import com.sap.core.connectivity.tunnel.api.management.TracingConfigurationChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class DefaultTracingConfiguration
implements TracingConfiguration {
    private static final Logger log = Logger.getLogger(DefaultTracingConfiguration.class);
    private final Set<TracingConfigurationChangeListener> listeners = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    @Override
    public boolean isTracingEnabled(String tunnelId) {
        return false;
    }

    @Override
    public void addListener(TracingConfigurationChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(TracingConfigurationChangeListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTracingConfigurationChangedEvent(TracingConfigurationChangeEvent event) {
        Set<TracingConfigurationChangeListener> set = this.listeners;
        synchronized (set) {
            for (TracingConfigurationChangeListener listener : this.listeners) {
                try {
                    listener.configurationChanged(event);
                }
                catch (Exception e) {
                    log.error((Object)"Error invoking tunnel configuration listener", (Throwable)e);
                }
            }
        }
    }
}

