/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.api.sso;

import com.sap.core.connectivity.tunnel.api.sso.AbstractTrustedEntityConfiguration;

public final class ApplicationTrustConfiguration
extends AbstractTrustedEntityConfiguration {
    private final String account;
    private final String name;
    private final ApplicationType applicationType;

    public ApplicationTrustConfiguration(ApplicationTrustConfiguration other, boolean enabled) {
        super(enabled);
        this.account = other.account;
        this.name = other.name;
        this.applicationType = other.applicationType;
    }

    public ApplicationTrustConfiguration(String account, String name, ApplicationType type, boolean enabled) {
        super(enabled);
        this.account = account;
        this.name = name;
        this.applicationType = type;
    }

    public String getAccount() {
        return this.account;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    @Override
    protected AbstractTrustedEntityConfiguration.ConfigurationType getType() {
        return AbstractTrustedEntityConfiguration.ConfigurationType.TrustedApplication;
    }

    @Override
    protected int getIdHash() {
        int prime = 31;
        int result = this.account == null ? 0 : this.account.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.applicationType == null ? 0 : this.applicationType.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ApplicationTrustConfiguration)) {
            return false;
        }
        ApplicationTrustConfiguration other = (ApplicationTrustConfiguration)o;
        if (this.name == null || !this.name.equals(other.name)) {
            return false;
        }
        if (this.account == null || !this.account.equals(other.account)) {
            return false;
        }
        if (this.applicationType == null || !this.applicationType.equals((Object)other.applicationType)) {
            return false;
        }
        return this.isEnabled() == other.isEnabled();
    }

    public int hashCode() {
        int nameHash = this.name != null ? this.name.hashCode() : 0;
        int accountHash = this.account != null ? this.account.hashCode() : 0;
        int typeHash = this.applicationType != null ? this.applicationType.hashCode() : 0;
        return nameHash / 3 + accountHash / 3 + typeHash / 3;
    }

    public static enum ApplicationType {
        JAVA,
        HANA,
        UNKNOWN;


        public static ApplicationType fromString(String value) {
            for (ApplicationType type : ApplicationType.values()) {
                if (!type.toString().toLowerCase().equals(value.toLowerCase())) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

