/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.api.sso;

import com.sap.core.connectivity.tunnel.api.sso.AbstractTrustedEntityConfiguration;
import java.security.cert.X509Certificate;

public final class IdentityProviderConfiguration
extends AbstractTrustedEntityConfiguration {
    private final String name;
    private final String description;
    private final X509Certificate certificate;
    private final String base64EncodedPublicKey;

    public IdentityProviderConfiguration(IdentityProviderConfiguration other, boolean enabled) {
        super(enabled);
        this.name = other.getName();
        this.description = other.getDescription();
        this.certificate = other.getCertificate();
        this.base64EncodedPublicKey = other.getPublicKey();
    }

    public IdentityProviderConfiguration(String name, String description, X509Certificate certificate, boolean enabled) {
        super(enabled);
        this.name = name;
        this.description = description;
        this.certificate = certificate;
        this.base64EncodedPublicKey = null;
    }

    public IdentityProviderConfiguration(String name, String description, boolean enabled, String base64EncodedPublicKey) {
        super(enabled);
        this.name = name;
        this.description = description;
        this.certificate = null;
        this.base64EncodedPublicKey = base64EncodedPublicKey;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    protected AbstractTrustedEntityConfiguration.ConfigurationType getType() {
        return AbstractTrustedEntityConfiguration.ConfigurationType.TrusteIdp;
    }

    @Override
    protected int getIdHash() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public String getPublicKey() {
        return this.base64EncodedPublicKey;
    }
}

