/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LobLocatorBufferedInputStream;
import com.sybase.jdbc4.jdbc.LobLocatorBufferedReader;
import com.sybase.jdbc4.jdbc.LobLocatorInputStream;
import com.sybase.jdbc4.jdbc.LobLocatorOutputStream;
import com.sybase.jdbc4.jdbc.LobLocatorReader;
import com.sybase.jdbc4.jdbc.LobLocatorWriter;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybCharLob
extends SybLob
implements NClob {
    private static Logger LOG = Logger.getLogger(SybCharLob.class.getName());
    private static volatile long _logIdCounter = 0L;
    private AtomicLong _apiCount = new AtomicLong(0L);

    public SybCharLob(String string, ProtocolContext protocolContext, byte[] byArray, SybLob.LOB_TYPE lOB_TYPE) throws SQLException {
        super(string, protocolContext, byArray);
        this._lobType = lOB_TYPE;
        this.setLiteralSQL();
        this._lengthBuiltin = "char_length";
        this._logId = string + "_Cl" + _logIdCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            LobLocatorBufferedInputStream lobLocatorBufferedInputStream = new LobLocatorBufferedInputStream(new LobLocatorInputStream(this), 16384);
            return lobLocatorBufferedInputStream;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getAsciiStream", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            LobLocatorBufferedReader lobLocatorBufferedReader = new LobLocatorBufferedReader(new LobLocatorReader(this), 16384);
            return lobLocatorBufferedReader;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        LobLocatorBufferedReader lobLocatorBufferedReader;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l3 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l3);
                }
                long l4 = this.length();
                if (l < 1L || l > l4 || l + l2 > l4 + 1L) {
                    ErrorMessage.raiseError("JZ037");
                }
                lobLocatorBufferedReader = new LobLocatorBufferedReader(new LobLocatorReader(this, l, l2), 16384);
                if (!bl) break block5;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "long, long", new Object[]{l, l2}, l3);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "long, long", new Object[]{l, l2}, l3);
        }
        return lobLocatorBufferedReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long l, int n) throws SQLException {
        String string;
        block13: {
            long l2;
            boolean bl;
            block9: {
                String string2;
                block12: {
                    int n2;
                    block10: {
                        String string3;
                        block11: {
                            bl = LogUtil.isLoggingEnabled(LOG);
                            l2 = bl ? this._apiCount.incrementAndGet() : 0L;
                            try {
                                if (bl) {
                                    LogUtil.logBegin(LOG, this._logId, l2);
                                }
                                this.checkLocatorValidity();
                                if (l < 1L) {
                                    ErrorMessage.raiseError("JZ037");
                                } else if (n < 0) {
                                    ErrorMessage.raiseError("JZ038");
                                }
                                MdaManager mdaManager = this._context._conn.getMDA(this._context);
                                PreparedStatement preparedStatement = mdaManager.getMetaDataAccessor("LOB_GETBYTES", this._context);
                                preparedStatement.setInt(1, this._lobType.ordinal());
                                preparedStatement.setBytes(2, this.getLocator());
                                preparedStatement.setLong(3, l);
                                preparedStatement.setInt(4, n);
                                ResultSet resultSet = preparedStatement.executeQuery();
                                if (!resultSet.next()) break block9;
                                string = resultSet.getString(1);
                                n2 = resultSet.getInt(2);
                                if (string == null) break block10;
                                string3 = string;
                                if (!bl) break block11;
                            }
                            catch (Throwable throwable) {
                                if (bl) {
                                    LogUtil.logEnd(LOG, null, null, this._logId, "getSubString", "long, int", new Object[]{l, n}, l2);
                                }
                                throw throwable;
                            }
                            LogUtil.logEnd(LOG, null, null, this._logId, "getSubString", "long, int", new Object[]{l, n}, l2);
                        }
                        return string3;
                    }
                    if (n2 == 0 || l > (long)n2) break block9;
                    string2 = "";
                    if (!bl) break block12;
                    LogUtil.logEnd(LOG, null, null, this._logId, "getSubString", "long, int", new Object[]{l, n}, l2);
                }
                return string2;
            }
            string = null;
            if (!bl) break block13;
            LogUtil.logEnd(LOG, null, null, this._logId, "getSubString", "long, int", new Object[]{l, n}, l2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(String string, long l) throws SQLException {
        long l2;
        block7: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l3 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l3);
                }
                this.checkLocatorValidity();
                if (l < 1L) {
                    ErrorMessage.raiseError("JZ037");
                }
                long l4 = -1L;
                if (string != null) {
                    CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor("SEARCH_LOB", this._context);
                    callableStatement.setInt(1, this._lobType.ordinal());
                    callableStatement.setBytes(2, null);
                    callableStatement.setBytes(3, this.getLocator());
                    callableStatement.setLong(4, l);
                    callableStatement.registerOutParameter(5, -5);
                    callableStatement.setInt(6, 1);
                    callableStatement.setString(7, string);
                    callableStatement.execute();
                    l4 = callableStatement.getLong(5);
                    if (l4 < l) {
                        l4 = -1L;
                    }
                }
                l2 = l4;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "position", "String, long", new Object[]{string, l}, l3);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "position", "String, long", new Object[]{string, l}, l3);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Clob clob, long l) throws SQLException {
        long l2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l3 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l3);
                }
                l2 = super.searchLocator((SybLob)((Object)clob), l);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "position", "Clob, long", new Object[]{clob, l}, l3);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "position", "Clob, long", new Object[]{clob, l}, l3);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l, String string) throws SQLException {
        int n;
        block8: {
            long l2;
            boolean bl;
            block6: {
                int n2;
                block7: {
                    bl = LogUtil.isLoggingEnabled(LOG);
                    l2 = bl ? this._apiCount.incrementAndGet() : 0L;
                    try {
                        if (bl) {
                            LogUtil.logBegin(LOG, this._logId, l2);
                        }
                        if (l < 1L) {
                            ErrorMessage.raiseError("JZ037");
                        }
                        if (string == null) break block6;
                        this.checkLocatorValidity();
                        n2 = this.setData(l, string);
                        if (!bl) break block7;
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String", new Object[]{l, string}, l2);
                        }
                        throw throwable;
                    }
                    LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String", new Object[]{l, string}, l2);
                }
                return n2;
            }
            n = 0;
            if (!bl) break block8;
            LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String", new Object[]{l, string}, l2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        int n3;
        block8: {
            long l2;
            boolean bl;
            block6: {
                int n4;
                block7: {
                    bl = LogUtil.isLoggingEnabled(LOG);
                    l2 = bl ? this._apiCount.incrementAndGet() : 0L;
                    try {
                        if (bl) {
                            LogUtil.logBegin(LOG, this._logId, l2);
                        }
                        if (l < 1L) {
                            ErrorMessage.raiseError("JZ037");
                        }
                        if (string == null) break block6;
                        n4 = this.setString(l, string.substring(n - 1, n - 1 + n2));
                        if (!bl) break block7;
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String, int, int", new Object[]{l, string, n, n2}, l2);
                        }
                        throw throwable;
                    }
                    LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String, int, int", new Object[]{l, string, n, n2}, l2);
                }
                return n4;
            }
            n3 = 0;
            if (!bl) break block8;
            LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String, int, int", new Object[]{l, string, n, n2}, l2);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        BufferedOutputStream bufferedOutputStream;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l2);
                }
                if (l < 1L || l > this.length()) {
                    ErrorMessage.raiseError("JZ037");
                }
                bufferedOutputStream = new BufferedOutputStream(new LobLocatorOutputStream(this, l), 16384);
                if (!bl) break block5;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "long", new Object[]{l}, l2);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "long", new Object[]{l}, l2);
        }
        return bufferedOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        BufferedWriter bufferedWriter;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l2);
                }
                if (l < 1L || l > this.length()) {
                    ErrorMessage.raiseError("JZ037");
                }
                bufferedWriter = new BufferedWriter(new LobLocatorWriter(this, l), 16384);
                if (!bl) break block5;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "long", new Object[]{l}, l2);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "long", new Object[]{l}, l2);
        }
        return bufferedWriter;
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }
}

