/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LimiterInputStream;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybBCP;
import com.sybase.jdbc4.jdbc.SybBinaryLob;
import com.sybase.jdbc4.jdbc.SybCallableStatement;
import com.sybase.jdbc4.jdbc.SybCharLob;
import com.sybase.jdbc4.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.tds.SybBigDecimal;
import com.sybase.jdbc4.tds.TdsProtocolContext;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.LogUtil;
import com.sybase.jdbc4.utils.Misc;
import com.sybase.jdbcx.Capture;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybPreparedStatement
extends SybStatement
implements com.sybase.jdbcx.SybPreparedStatement,
ParameterMetaData {
    private static Logger LOG = Logger.getLogger(SybPreparedStatement.class.getName());
    private static volatile long _logIdCounter = 0L;
    private AtomicLong _apiCount = new AtomicLong(0L);
    private static final int MAX_PARAMETERS = 1000;
    protected static final int BASE_MAX_BATCH_PARAMETERS = 255;
    private static final int NOT_SET = 0;
    private static final int IN_PARENTHESES = 1;
    private static final int IN_VALUES_BLOCK = 2;
    private static final int IN_SET_BLOCK = 4;
    private static final int IN_WHERE_BLOCK = 8;
    private static final int IN_SINGLE_QUOTES = 16;
    private static final int IN_DOUBLE_QUOTES = 32;
    private static final int IN_CURLIES = 64;
    private static final int IN_CALL_BLOCK = 128;
    String _dynStmtName = null;
    private boolean _firstExecuteAfterResume = true;
    protected int _enableBCP = 0;
    protected LinkedList<int[]> _bulkTypes;
    protected LinkedList<Object[]> _bulkObject;
    protected LinkedList<int[]> _bulkScale;
    protected LinkedList<Calendar[]> _bulkCal;
    private int _rowPosition = 0;
    protected SybBCP _sybBCP = null;
    int _paramCount = 0;
    ArrayList<Param> _batchParams = null;
    protected String _sqlStr = null;
    protected String _paramColids = null;
    protected String _paramNames = null;
    private String _whereBlock = null;
    protected int[] _types;
    protected Object[] _object;
    protected int[] _scale;
    protected Calendar[] _cal;
    protected int _batchOffset = 0;
    private int _numRows = 0;
    private int[] _batchFirstRowParamType;
    protected boolean _isDynamic = false;
    protected boolean _homoGeneousBatch = false;
    protected boolean _sendBatchParamsImmediate = false;
    boolean _batchInitialized = false;
    private boolean _batchLock = false;
    private boolean _lobSetterCalled = false;
    private boolean _firstExecute = true;
    private String execKeyWord = "execute ";
    protected String _query = null;
    protected ParamManager _paramMgr;

    SybPreparedStatement(String string, ProtocolContext protocolContext, String string2, int n, int n2) throws SQLException {
        super(string, protocolContext);
        this._logId = string + "_Ps" + _logIdCounter++;
        this._dynStmtName = "placeholder";
        string2 = this.doEscapeProcessing(string2);
        this._sqlStr = this.processGenKeysRequest(n2, string2);
        this._paramMgr = this.countParams(this._sqlStr);
        this._paramCount = this._paramMgr._params.length;
        String string3 = "dyn" + n;
        ((TdsProtocolContext)this._context).setIsSelectSql((this._type & 2) == 2);
        this._protocol.dynamicPrepare(this._context, string3, this._sqlStr, this._paramMgr);
        this._dynStmtName = string3;
        if (this._paramCount > 0 && this._type != 256 && this.isInsertInSQL(this._sqlStr)) {
            this.prepareBCP(protocolContext);
        } else {
            this.initializeParamArrays(this._paramCount);
        }
        this._isDynamic = this._dynStmtName != null && !this.checkBatch();
        this._executionMode = this._isDynamic ? IConstants.STATEMENT_EXECUTION_MODE.DYNAMIC : IConstants.STATEMENT_EXECUTION_MODE.PARAMETERIZED;
        this._sendBatchParamsImmediate = this._context._conn._props.getBoolean(83) && !this._context._conn._props.getBoolean(15);
        this._homoGeneousBatch = this._context._conn._props.getBoolean(84) && !this._context._conn._props.getBoolean(15) && !(this instanceof SybCallableStatement);
    }

    SybPreparedStatement(String string, ProtocolContext protocolContext, String string2, int n) throws SQLException {
        super(string, protocolContext);
        this._logId = string + "_Ps" + _logIdCounter++;
        this.initializeParamArrays(this._paramCount);
        this._executionMode = IConstants.STATEMENT_EXECUTION_MODE.PARAMETERIZED;
        string2 = this.doEscapeProcessing(string2);
        this._sqlStr = this.processGenKeysRequest(n, string2);
        this._paramMgr = this.countParams(this._sqlStr);
        this._paramCount = this._paramMgr._params.length;
        if (this._paramCount > 0 && this._type != 256 && this.isInsertInSQL(this._sqlStr)) {
            this.prepareBCP(protocolContext);
        }
        this._sendBatchParamsImmediate = this._context._conn._props.getBoolean(83) && !this._context._conn._props.getBoolean(15);
        this._homoGeneousBatch = this._context._conn._props.getBoolean(84) && !this._context._conn._props.getBoolean(15) && !(this instanceof SybCallableStatement);
    }

    SybPreparedStatement(String string, ProtocolContext protocolContext, SybPreparedStatement sybPreparedStatement) throws SQLException {
        super(string, protocolContext);
        this._logId = string + "_Ps" + _logIdCounter++;
        this._query = sybPreparedStatement._query;
        this._paramMgr = new ParamManager(sybPreparedStatement._paramMgr, (SybStatement)this);
        this._paramCount = this._paramMgr._params.length;
        if (this._context._conn._props.getBoolean(58)) {
            ((TdsProtocolContext)protocolContext).copyColumnCache((TdsProtocolContext)sybPreparedStatement._context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybResultSet = sybResultSet2 = (SybResultSet)super.executeQuery(this._query, this._paramMgr);
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "executeQuery", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "executeQuery", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        ResultSet resultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            Object var5_4 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                ErrorMessage.raiseError("JZ0S3", "executeQuery(String)");
                resultSet = null;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "ResultSet", var5_4 != null ? var5_4._logId : "_", this._logId, "executeQuery", "String", new Object[]{string}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "ResultSet", var5_4 != null ? var5_4._logId : "_", this._logId, "executeQuery", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            int n = super.executeUpdate(this._query, this._paramMgr);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "executeUpdate", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string) throws SQLException {
        int n;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                ErrorMessage.raiseError("JZ0S3", "executeUpdate(String)");
                n = 0;
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "executeUpdate", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "executeUpdate", "String", new Object[]{string}, l);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        int n2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                ErrorMessage.raiseError("JZ0S3", "executeUpdate(String, int)");
                n2 = 0;
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "executeUpdate", "String, int", new Object[]{string, n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "executeUpdate", "String, int", new Object[]{string, n}, l);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        int n;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                ErrorMessage.raiseError("JZ0S3", "executeUpdate(String, int[])");
                n = 0;
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "executeUpdate", "String, int[]", new Object[]{string, nArray}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "executeUpdate", "String, int[]", new Object[]{string, nArray}, l);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        int n;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                ErrorMessage.raiseError("JZ0S3", "executeUpdate(String, String[])");
                n = 0;
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "executeUpdate", "String, String[]", new Object[]{string, stringArray}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "executeUpdate", "String, String[]", new Object[]{string, stringArray}, l);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNull(int n, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            Object object = null;
            if (n2 == -7) {
                ErrorMessage.raiseError("JZNNA");
            }
            if (n2 == 2005) {
                object = this._context._conn._nullClob;
            } else if (n2 == 2004) {
                object = this._context._conn._nullBlob;
            }
            this.setParam(n2, n, object);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setNull", "int, int", new Object[]{n, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setNull", "int, int", new Object[]{n, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                Debug.notImplemented(this, "setNull(int, int, String)");
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "setNull", "int, int, String", new Object[]{n, n2, string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setNull", "int, int, String", new Object[]{n, n2, string}, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        boolean bl2 = LogUtil.isLoggingEnabled(LOG);
        long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl2) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -7);
            Boolean bl3 = new Boolean(bl);
            this.setParam(-7, n, bl3);
            if (!bl2) return;
        }
        catch (Throwable throwable) {
            if (!bl2) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBoolean", "int, boolean", new Object[]{n, bl}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBoolean", "int, boolean", new Object[]{n, bl}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setByte(int n, byte by) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 5);
            Integer n2 = new Integer(by);
            if (n2 < 0) {
                this.setParam(5, n, n2);
            } else {
                this.setParam(-6, n, n2);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setByte", "int, byte", new Object[]{n, by}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setByte", "int, byte", new Object[]{n, by}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setShort(int n, short s) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 5);
            Integer n2 = new Integer(s);
            this.setParam(5, n, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setShort", "int, short", new Object[]{n, s}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setShort", "int, short", new Object[]{n, s}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInt(int n, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._enableBCP == 0) {
                this.checkDead();
            }
            this.checkIfMixedWithLob(n, 4);
            this.setParam(4, n, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setInt", "int, int", new Object[]{n, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setInt", "int, int", new Object[]{n, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setLong(int n, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -5);
            Long l3 = new Long(l);
            this.setParam(-5, n, l3);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setLong", "int, long", new Object[]{n, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setLong", "int, long", new Object[]{n, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFloat(int n, float f) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 7);
            Float f2 = new Float(f);
            this.setParam(7, n, f2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setFloat", "int, float", new Object[]{n, Float.valueOf(f)}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setFloat", "int, float", new Object[]{n, Float.valueOf(f)}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDouble(int n, double d) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 8);
            Double d2 = new Double(d);
            this.setParam(8, n, d2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setDouble", "int, double", new Object[]{n, d}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setDouble", "int, double", new Object[]{n, d}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 2);
            if (bigDecimal == null) {
                this.setNull(n, 2);
            } else {
                this.setParam(2, n, bigDecimal, bigDecimal.scale());
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBigDecimal", "int, BigDecimal", new Object[]{n, bigDecimal}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBigDecimal", "int, BigDecimal", new Object[]{n, bigDecimal}, l);
    }

    private void checkIfMixedWithLob(int n, int n2) throws SQLException {
        if (this._homoGeneousBatch && this._batchFirstRowParamType != null && this._batchFirstRowParamType.length > 0) {
            int n3 = this._batchFirstRowParamType[n - 1];
            if (n3 == -999) {
                this._batchFirstRowParamType[n - 1] = n2;
            } else if (n3 == 2005 || n3 == 2004) {
                ErrorMessage.raiseError("JZ042", String.valueOf(n2), String.valueOf(n3));
            }
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal, int n2, int n3) throws SQLException {
        this.checkDead();
        this.checkIfMixedWithLob(n, 2);
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal("0");
        }
        SybBigDecimal sybBigDecimal = new SybBigDecimal(bigDecimal, n2, n3);
        this.setParam(2, n, sybBigDecimal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setString(int n, String string) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 12);
            this.setParam(12, n, string);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setString", "int, String", new Object[]{n, string}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setString", "int, String", new Object[]{n, string}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -4);
            int n2 = 0;
            if (byArray != null) {
                n2 = byArray.length;
            }
            if (n2 > 255) {
                this.setParam(-4, n, byArray);
            } else {
                this.setParam(-3, n, byArray);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "parameterIndex", "int, byte[]", new Object[]{n, byArray}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "parameterIndex", "int, byte[]", new Object[]{n, byArray}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDate(int n, Date date) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 91);
            if (date == null || this._isDynamic || this._enableBCP > 0) {
                this.setParam(91, n, date);
            } else {
                this.setParam(91, n, new DateObject((Object)date, 91));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setDate", "int, java.sql.Date", new Object[]{n, date}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setDate", "int, java.sql.Date", new Object[]{n, date}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTime(int n, Time time) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 92);
            if (time == null || this._isDynamic || this._enableBCP > 0) {
                this.setParam(92, n, time);
            } else {
                this.setParam(92, n, new DateObject((Object)time, 92));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setTime", "int, java.sql.Time", new Object[]{n, time}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setTime", "int, java.sql.Time", new Object[]{n, time}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 93);
            if (timestamp == null || this._isDynamic || this._enableBCP > 0) {
                this.setParam(93, n, timestamp);
            } else {
                this.setParam(93, n, new DateObject((Object)timestamp, 93));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setTimestamp", "int, java.sql.Timestamp", new Object[]{n, timestamp}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setTimestamp", "int, java.sql.Timestamp", new Object[]{n, timestamp}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -1);
            if (inputStream == null) {
                this.setNull(n, -1);
            } else {
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, n2), "ISO8859_1");
                    String string = this._paramMgr.drainReader(inputStreamReader, n2);
                    if (string != null) {
                        this.setParam(12, n, string, 0);
                    } else {
                        this.setParam(-1, n, inputStreamReader, n2);
                    }
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "int, java.io.InputStream, int", new Object[]{n, inputStream, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "int, java.io.InputStream, int", new Object[]{n, inputStream, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -1);
            if (inputStream == null) {
                this.setNull(n, -1);
            } else {
                byte[] byArray = this._paramMgr.drainStreams(inputStream, n2);
                if (byArray != null) {
                    this.setBytes(n, byArray);
                } else {
                    this.setParam(-1, n, inputStream, n2);
                }
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setUnicodeStream", "int, ava.io.InputStream, int", new Object[]{n, inputStream, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setUnicodeStream", "int, ava.io.InputStream, int", new Object[]{n, inputStream, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -4);
            byte[] byArray = this._paramMgr.drainStreams(inputStream, n2);
            if (byArray != null) {
                this.setBytes(n, byArray);
            } else {
                this.setParam(-4, n, inputStream, n2);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "int, java.io.InputStream, int", new Object[]{n, inputStream, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "int, java.io.InputStream, int", new Object[]{n, inputStream, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        block9: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                this.checkDead();
                try {
                    if (this._isDynamic && this._enableBCP < 2) {
                        for (int i = this._batchOffset; i < this._batchOffset + this._paramCount; ++i) {
                            this._types[i] = -999;
                            this._scale[i] = 0;
                            this._cal[i] = null;
                            this._object[i] = null;
                        }
                        break block9;
                    }
                    this._paramMgr.clearParams(true);
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
            }
            finally {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "clearParameters", null, null, l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            if (object == null) {
                this.setParam(n2, n, null, n3);
            }
            switch (n2) {
                case -7: {
                    this.setParam(n2, n, Convert.objectToBoolean(object), n3);
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    this.setParam(n2, n, Convert.objectToInt(object), n3);
                    break;
                }
                case -5: {
                    this.setParam(n2, n, Convert.objectToLong(object), n3);
                    break;
                }
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    this.setString(n, Convert.objectToString(object));
                    break;
                }
                case -1: {
                    this.setParam(-1, n, Convert.objectToString(object));
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal;
                    if (n3 < 0) {
                        ErrorMessage.raiseError("JZ00I");
                    }
                    if ((bigDecimal = Convert.objectToBigDecimal(object)) != null) {
                        bigDecimal = this.setScale(bigDecimal, n3);
                    }
                    this.setParam(n2, n, bigDecimal, n3);
                    break;
                }
                case 7: {
                    this.setParam(n2, n, Convert.objectToFloat(object), n3);
                    break;
                }
                case 6: 
                case 8: {
                    this.setParam(n2, n, Convert.objectToDouble(object), n3);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.setBytes(n, Convert.objectToBytes(object));
                    break;
                }
                case 2004: {
                    this.setBlob(n, (Blob)Blob.class.cast(Convert.objectToLob(object, SybLob.LOB_TYPE.IMAGE)));
                    break;
                }
                case 2005: {
                    this.setClob(n, (Clob)Clob.class.cast(Convert.objectToLob(object, SybLob.LOB_TYPE.TEXT)));
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    this.setParam(n2, n, Convert.objectToDateObject(object, n2, null, null), n3);
                    break;
                }
                case 1111: 
                case 2000: {
                    if (object instanceof Serializable || object == null) {
                        this.setParam(2000, n, object);
                        break;
                    }
                }
                default: {
                    ErrorMessage.raiseError("JZ0SE");
                }
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setObject", "int, Object, int, int", new Object[]{n, object, n2, n3}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setObject", "int, Object, int, int", new Object[]{n, object, n2, n3}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            int n3 = 0;
            if (object != null) {
                if (object instanceof BigDecimal) {
                    n3 = ((BigDecimal)object).scale();
                }
                if (object instanceof Float || object instanceof Double) {
                    n3 = Misc.getScaleFromObject(object);
                }
            }
            this.setObject(n, object, n2, n3);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setObject", "int, Object, int", new Object[]{n, object, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setObject", "int, Object, int", new Object[]{n, object, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(int n, Object object) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            if (object == null) {
                ErrorMessage.raiseError("JZ0SE");
            }
            if (object instanceof Short) {
                this.setShort(n, (Short)object);
            } else if (object instanceof Byte) {
                this.setByte(n, (Byte)object);
            } else if (object instanceof String) {
                this.setString(n, (String)object);
            } else if (object instanceof BigDecimal) {
                this.setBigDecimal(n, (BigDecimal)object);
            } else if (object instanceof Boolean) {
                this.setParam(-7, n, object);
            } else if (object instanceof Integer) {
                this.setParam(4, n, object);
            } else if (object instanceof Long) {
                this.setParam(-5, n, object);
            } else if (object instanceof Float) {
                this.setParam(7, n, object);
            } else if (object instanceof Double) {
                this.setParam(8, n, object);
            } else if (object instanceof byte[]) {
                this.setBytes(n, (byte[])object);
            } else if (object instanceof Date) {
                this.setDate(n, (Date)object);
            } else if (object instanceof Time) {
                this.setTime(n, (Time)object);
            } else if (object instanceof Timestamp) {
                this.setTimestamp(n, (Timestamp)object);
            } else if (object instanceof Clob) {
                this.setClob(n, (Clob)object);
            } else if (object instanceof Blob) {
                this.setBlob(n, (Blob)object);
            } else if (object instanceof Serializable) {
                this.setParam(2000, n, object);
            } else {
                ErrorMessage.raiseError("JZ0SE");
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setObject", "int, Object", new Object[]{n, object}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setObject", "int, Object", new Object[]{n, object}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setURL(int n, URL uRL) {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            Debug.notImplemented(this, "setURL(int, URL)");
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setURL", "int, URL", new Object[]{n, uRL}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setURL", "int, URL", new Object[]{n, uRL}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            boolean bl2 = super.execute(this._query, this._paramMgr);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "execute", null, null, l);
            }
        }
    }

    private void addBulkBatch() throws SQLException {
        ++this._rowPosition;
        if (this._enableBCP >= 2) {
            try {
                this._sybBCP.bcpSendRow(this._object, this._types, this._scale, this._cal);
            }
            catch (IOException iOException) {
                this._rowPosition = 0;
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            return;
        }
        this._bulkObject.addLast((Object[])this._object.clone());
        this._bulkTypes.addLast((int[])this._types.clone());
        this._bulkScale.addLast((int[])this._scale.clone());
        this._bulkCal.addLast((Calendar[])this._cal.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        block31: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                int n;
                int n2;
                Object object;
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                if (this._enableBCP > 0) {
                    if (this._lobSetterCalled) {
                        this._lobSetterCalled = false;
                        ErrorMessage.raiseError("JZ043");
                        return;
                    }
                    this.addBulkBatch();
                    return;
                }
                if (this._isDynamic) {
                    ++this._numRows;
                } else if (this._batchParams == null) {
                    this._batchParams = new ArrayList(1000);
                }
                if (this._sendAsRpc) {
                    this._sendAsRpc = false;
                    this._executionMode = IConstants.STATEMENT_EXECUTION_MODE.PARAMETERIZED;
                    this._doneinproc = true;
                    this._query = this.execKeyWord + this._query;
                    object = this._paramMgr.getParams();
                    for (n2 = 0; n2 < ((Param[])object).length; ++n2) {
                        object[n2]._paramMarkerOffset += this.execKeyWord.length();
                    }
                    super.addBatch(this._query);
                } else {
                    boolean bl2;
                    if (!this._doneinproc && (this._query.toLowerCase().startsWith(this.execKeyWord) || this._query.toLowerCase().startsWith("exec "))) {
                        this._doneinproc = true;
                    } else if (this._batchCmdsCount == 0 && this instanceof SybCallableStatement && !(bl2 = this._context._conn._props.getBoolean(106)) && !this._query.toLowerCase().startsWith(this.execKeyWord) && !this._query.toLowerCase().startsWith("exec ")) {
                        this._doneinproc = true;
                        this._query = this.execKeyWord + this._query;
                        Param[] paramArray = this._paramMgr.getParams();
                        for (n = 0; n < paramArray.length; ++n) {
                            paramArray[n]._paramMarkerOffset += this.execKeyWord.length();
                        }
                    }
                    super.addBatch(this._query);
                }
                object = null;
                if (this._sendBatchParamsImmediate && !this._batchInitialized) {
                    boolean bl3 = this._sendBatchParamsImmediate = !this.checkBatch();
                    if (this._sendBatchParamsImmediate) {
                        this.checkStatementAndTransaction(true);
                        this._batchLock = this._protocol.initCommandExecSession(this._context);
                    }
                }
                if (this._isDynamic) {
                    this._batchOffset += this._paramCount;
                    if (this._enableBCP < 2) {
                        if (this._batchOffset >= this._types.length) {
                            n2 = this._types.length;
                            n = 2 * n2;
                            int[] nArray = new int[n];
                            System.arraycopy(this._types, 0, nArray, 0, n2);
                            this._types = nArray;
                            int[] nArray2 = new int[n];
                            System.arraycopy(this._scale, 0, nArray2, 0, n2);
                            this._scale = nArray2;
                            Calendar[] calendarArray = new Calendar[n];
                            System.arraycopy(this._cal, 0, calendarArray, 0, n2);
                            this._cal = calendarArray;
                            Object[] objectArray = new Object[n];
                            System.arraycopy(this._object, 0, objectArray, 0, n2);
                            this._object = objectArray;
                        }
                        n2 = this._batchOffset - this._paramCount;
                        System.arraycopy(this._types, n2, this._types, this._batchOffset, this._paramCount);
                        System.arraycopy(this._object, n2, this._object, this._batchOffset, this._paramCount);
                        System.arraycopy(this._scale, n2, this._scale, this._batchOffset, this._paramCount);
                        System.arraycopy(this._cal, n2, this._cal, this._batchOffset, this._paramCount);
                    }
                    if (!this._sendBatchParamsImmediate) break block31;
                    try {
                        this._protocol.sendDynamicExecuteParams(this._context, this._dynStmtName, this._paramMgr, this._numRows, this._object, this._types, this._cal, this._scale, this._homoGeneousBatch, !this._batchInitialized, this._firstExecute);
                        this._batchInitialized = true;
                        this._context._conn._batchSBPIInitialized = true;
                        this._firstExecute = false;
                        break block31;
                    }
                    catch (SQLException sQLException) {
                        this._protocol.cancel(this._context, true);
                        this._protocol.abortCommandSession(this._context);
                        this._batchInitialized = false;
                        this._context._conn._batchSBPIInitialized = false;
                        break block31;
                    }
                    finally {
                        this._batchOffset = 0;
                        this._numRows = 0;
                    }
                }
                for (n2 = 0; n2 < this._paramCount; ++n2) {
                    object = this._paramMgr._params[n2].cloneMe();
                    this._batchParams.add((Param)object);
                }
                if (this._sendBatchParamsImmediate) {
                    this._protocol.sendLanguageParams(this._context, this._query, this._paramMgr, this._batchParams, this._homoGeneousBatch, 1, !this._batchInitialized);
                    this._batchInitialized = true;
                    this._context._conn._batchSBPIInitialized = true;
                    this._batchParams.clear();
                }
            }
            finally {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "addBatch", null, null, l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addBatch(String string) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            ErrorMessage.raiseError("JZ0S3", "addBatch(String)");
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "addBatch", "String", new Object[]{string}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "addBatch", "String", new Object[]{string}, l);
    }

    private void clearBulkBatch() {
        while (!this._bulkObject.isEmpty()) {
            this._bulkObject.clear();
            this._bulkCal.clear();
            this._bulkScale.clear();
            this._bulkTypes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._enableBCP >= 2) {
                this._sybBCP.resetBCPInit();
                this._protocol.cancel(this._context, true);
            } else if (this._enableBCP == 1) {
                this.clearBulkBatch();
            }
            if (this._batchInitialized) {
                this._protocol.cancel(this._context, true);
                this._protocol.abortCommandSession(this._context);
                this._batchInitialized = false;
                this._context._conn._batchSBPIInitialized = false;
            }
            this._rowPosition = 0;
            super.clearBatch();
            this._batchParams = null;
            if (this._isDynamic) {
                this._batchOffset = 0;
                this._numRows = 0;
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "clearBatch", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] executeBulkBatch() throws SQLException {
        int[] nArray = new int[1];
        if (this._enableBCP == 3 && !this._context._conn.getAutoCommit()) {
            ErrorMessage.raiseError("JZBK5");
        }
        this.checkDead();
        if (this._enableBCP > 0 && this._rowPosition > 0) {
            try {
                if (this._enableBCP >= 2) {
                    nArray[0] = this._sybBCP.bcpDone();
                } else {
                    nArray[0] = this._sybBCP.bcpSendRow(this._bulkObject, this._bulkTypes, this._bulkScale, this._bulkCal);
                    this._sybBCP.bcpDone();
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            finally {
                this._sybBCP.resetBCPInit();
                this._rowPosition = 0;
            }
            return nArray;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int n;
        Vector<String> vector;
        String string;
        int[] nArray;
        int n2;
        int[] nArray2;
        block48: {
            block47: {
                boolean bl = LogUtil.isLoggingEnabled(LOG);
                long l = bl ? this._apiCount.incrementAndGet() : 0L;
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                if (this._enableBCP > 0) {
                    int[] nArray3 = this.executeBulkBatch();
                    return nArray3;
                }
                if (this._batchCmds == null) {
                    this._batchInitialized = false;
                    this._context._conn._batchSBPIInitialized = false;
                    this._batchLock = false;
                    int[] nArray4 = new int[]{};
                    return nArray4;
                }
                if (this._batchInitialized) {
                    try {
                        this._protocol.finishCommandExecSession(this._context, this._batchLock);
                        int[] nArray5 = this.batchLoop(this._paramMgr);
                        return nArray5;
                    }
                    finally {
                        this._context._batch = false;
                        this._batchInitialized = false;
                        this._context._conn._batchSBPIInitialized = false;
                        this._batchLock = false;
                        this._batchParams = null;
                        this._batchCmds = null;
                    }
                }
                nArray2 = new int[this._batchCmds.size()];
                if (this.checkBatch()) break block47;
                if (this._isDynamic) {
                    int[] nArray6 = super.executeBatch(this._paramMgr);
                    this._firstExecute = true;
                    int[] nArray7 = nArray6;
                    return nArray7;
                }
                boolean bl2 = this._context._conn._props.getBoolean(15);
                int n3 = 0;
                if (!bl2) {
                    n3 = this._dbmda == null ? 255 : this._dbmda.getMaxParamsPerBatch();
                }
                if (!bl2 && !this._homoGeneousBatch && this._batchCmdsCount * this._paramCount > n3 && this._paramCount <= n3) {
                    n2 = n3 / this._paramCount;
                    nArray = null;
                    string = (String)this._batchCmds.firstElement();
                    vector = new Vector<String>();
                    for (n = 0; n < n2; ++n) {
                        vector.add(string);
                    }
                    break block48;
                } else {
                    if (this._homoGeneousBatch && !bl2) {
                        boolean bl3 = true;
                        this.doEscapeProcessing(this._query);
                        if (this instanceof SybCallableStatement) {
                            int[] nArray8 = this.executeAsLanguageWithoutBatch();
                            return nArray8;
                        }
                        try {
                            this.getParameterMetaData();
                        }
                        catch (SQLException sQLException) {
                            this.chainWarning(ErrorMessage.createWarning("01S12"));
                            bl3 = false;
                        }
                        for (Object e : this._paramMgr._paramMdList) {
                            Param param = (Param)e;
                            if (param._sqlType != -4 && param._sqlType != -1 && param._sqlType != -16 && param._sqlType != -6) continue;
                            int[] nArray9 = this.executeAsLanguageWithoutBatch();
                            return nArray9;
                        }
                        try {
                            this.setExecutionMode(IConstants.STATEMENT_EXECUTION_MODE.LANGUAGE_BATCH);
                            this._protocol.languageBatch(this._context, this._query, this._paramMgr, this._batchParams, this._batchCmds.size(), bl3);
                            Object object = this.batchLoop(this._paramMgr);
                            return object;
                        }
                        finally {
                            this._batchParams.clear();
                            this._batchCmds.clear();
                            this._batchCmdsCount = 0;
                            this._context._batch = false;
                        }
                    }
                    int[] nArray10 = this.executeAsLanguageWithoutBatch();
                    return nArray10;
                }
                finally {
                    if (bl) {
                        LogUtil.logEnd(LOG, null, null, this._logId, "executeBatch", null, null, l);
                    }
                }
            }
            int n4 = 0;
            int n5 = 0;
            while (true) {
                if (n5 >= this._batchCmds.size()) {
                    this.clearBatch();
                    int[] nArray11 = nArray2;
                    return nArray11;
                }
                ParamManager paramManager = this.countParams((String)this._batchCmds.get(n5));
                int n6 = paramManager._params.length;
                for (int i = 0; i < n6; ++n4, ++i) {
                    Param param = this._batchParams.get(n4);
                    paramManager.setParam(i + 1, param._sqlType, param._inValue, param._scale);
                }
                try {
                    int[] nArray12 = super.executeBatch(paramManager);
                    nArray2[n5] = nArray12[0];
                }
                catch (SQLException sQLException) {
                    this.handleBatchException(sQLException, nArray2, n5);
                }
                ++n5;
            }
        }
        this._batchCmds = vector;
        n = this._batchCmdsCount;
        int n7 = 0;
        int n8 = 0;
        int n9 = n2;
        boolean bl = false;
        while (true) {
            Object object;
            if (n <= 0) {
                object = nArray2;
                return object;
            }
            if (n <= n2) {
                bl = true;
            }
            if (n < n2) {
                vector.clear();
                for (int i = 0; i < n; ++i) {
                    vector.add(string);
                }
                this._batchCmds = vector;
                n9 = n;
            }
            this._batchCmdsCount = n9;
            object = this.countParams(this.batchToString());
            for (int i = 0; i < this._paramCount * n9; ++n7, ++i) {
                Param param = this._batchParams.get(n7);
                ((ParamManager)object).setParam(i + 1, param._sqlType, param._inValue, param._scale);
            }
            try {
                nArray = super.executeBatch((ParamManager)object, bl);
            }
            catch (SQLException sQLException) {
                this.handleBatchException(sQLException, nArray2, n8);
            }
            if (nArray == null) continue;
            for (int i = 0; i < n9; ++n8, ++i) {
                nArray2[n8] = nArray[i];
            }
            n -= n9;
        }
    }

    private int[] executeAsLanguageWithoutBatch() throws SQLException {
        ParamManager paramManager = this.countParams(this.batchToString());
        int n = this._batchParams.size();
        for (int i = 0; i < n; ++i) {
            Param param = this._batchParams.get(i);
            paramManager.setParam(i + 1, param._sqlType, param._inValue, param._scale);
        }
        return super.executeBatch(paramManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -1);
            String string = this._paramMgr.drainReader(reader, n2);
            if (string != null) {
                this.setParam(12, n, string, 0);
            } else {
                this.setParam(-1, n, reader, n2);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "int, java.io.Reader, int", new Object[]{n, reader, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "int, java.io.Reader, int", new Object[]{n, reader, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this._lobSetterCalled = true;
            if (this._homoGeneousBatch && blob instanceof SybBinaryLob && this._batchFirstRowParamType != null && this._batchFirstRowParamType.length > 0) {
                int n2 = this._batchFirstRowParamType[n - 1];
                if (n2 == -999) {
                    this._batchFirstRowParamType[n - 1] = 2004;
                } else if (n2 != 2004) {
                    ErrorMessage.raiseError("JZ042", String.valueOf(2004), String.valueOf(n2));
                }
            }
            if (blob == null) {
                blob = this._context._conn._nullBlob;
            }
            this.setParam(2004, n, blob);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBlob", "int, Blob", new Object[]{n, blob}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBlob", "int, Blob", new Object[]{n, blob}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this._lobSetterCalled = true;
            if (this._homoGeneousBatch && clob instanceof SybCharLob && this._batchFirstRowParamType != null && this._batchFirstRowParamType.length > 0) {
                int n2 = this._batchFirstRowParamType[n - 1];
                if (n2 == -999) {
                    this._batchFirstRowParamType[n - 1] = 2005;
                } else if (n2 != 2005) {
                    ErrorMessage.raiseError("JZ042", String.valueOf(2005), String.valueOf(n2));
                }
            }
            if (clob == null) {
                clob = this._context._conn._nullClob;
            }
            this.setParam(2005, n, clob);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setClob", "int, Clob", new Object[]{n, clob}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setClob", "int, Clob", new Object[]{n, clob}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(int, NClob)");
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setNClob", "int, NClob", new Object[]{n, nClob}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setNClob", "int, NClob", new Object[]{n, nClob}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                Debug.notSupported(this, "setRef(int, Ref)");
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "setRef", "int, Ref", new Object[]{n, ref}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setRef", "int, Ref", new Object[]{n, ref}, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArray(int n, Array array) throws SQLException {
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                Debug.notSupported(this, "setArray(int, Array)");
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "setArray", "int, Array", new Object[]{n, array}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setArray", "int, Array", new Object[]{n, array}, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            ResultSetMetaData resultSetMetaData = null;
            if (this._dynStmtName != null) {
                resultSetMetaData = this._protocol.dynamicMetaData(this._context);
            }
            if (resultSetMetaData == null && this._currentRS != null) {
                resultSetMetaData = this._currentRS.getMetaData();
            }
            if (resultSetMetaData == null && this._context._conn._props.getBoolean(64)) {
                ErrorMessage.raiseError("JZ0MD");
            }
            ResultSetMetaData resultSetMetaData2 = resultSetMetaData;
            return resultSetMetaData2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getMetaData", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 91);
            if (this._isDynamic) {
                this.setParam(91, n, date);
                this.addCalendar(n, calendar);
            } else if (date == null || this._enableBCP > 0) {
                this.setParam(91, n, date);
            } else {
                this.setParam(91, n, new DateObject(date, calendar, 91));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setDate", "int, java.sql.Date, Calendar", new Object[]{n, date, calendar}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setDate", "int, java.sql.Date, Calendar", new Object[]{n, date, calendar}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 92);
            if (this._isDynamic) {
                this.setParam(92, n, time);
                this.addCalendar(n, calendar);
            } else if (time == null || this._enableBCP > 0) {
                this.setParam(92, n, time);
            } else {
                this.setParam(92, n, new DateObject(time, calendar, 92));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setTime", "int, ava.sql.Time, Calendar", new Object[]{n, time, calendar}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setTime", "int, ava.sql.Time, Calendar", new Object[]{n, time, calendar}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, 93);
            if (this._isDynamic) {
                this.setParam(93, n, timestamp);
                this.addCalendar(n, calendar);
            } else if (timestamp == null || this._enableBCP > 0) {
                this.setParam(93, n, timestamp);
            } else {
                this.setParam(93, n, new DateObject(timestamp, calendar, 93));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setTimestamp", "int, java.sql.Timestamp, Calendar", new Object[]{n, timestamp, calendar}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setTimestamp", "int, java.sql.Timestamp, Calendar", new Object[]{n, timestamp, calendar}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string) throws SQLException {
        boolean bl;
        block4: {
            boolean bl2 = LogUtil.isLoggingEnabled(LOG);
            long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl2) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                ErrorMessage.raiseError("JZ0S3", "execute(String)");
                bl = false;
                if (!bl2) break block4;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "execute", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "execute", "String", new Object[]{string}, l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int n) throws SQLException {
        boolean bl;
        block4: {
            boolean bl2 = LogUtil.isLoggingEnabled(LOG);
            long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl2) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                ErrorMessage.raiseError("JZ0S3", "execute(String, int)");
                bl = false;
                if (!bl2) break block4;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "execute", "String, int", new Object[]{string, n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "execute", "String, int", new Object[]{string, n}, l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        boolean bl;
        block4: {
            boolean bl2 = LogUtil.isLoggingEnabled(LOG);
            long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl2) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                ErrorMessage.raiseError("JZ0S3", "execute(String, int[])");
                bl = false;
                if (!bl2) break block4;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "execute", "String, int[]", new Object[]{string, nArray}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "execute", "String, int[]", new Object[]{string, nArray}, l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        boolean bl;
        block4: {
            boolean bl2 = LogUtil.isLoggingEnabled(LOG);
            long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl2) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                ErrorMessage.raiseError("JZ0S3", "execute(String, String[])");
                bl = false;
                if (!bl2) break block4;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "execute", "String, String[]", new Object[]{string, stringArray}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "execute", "String, String[]", new Object[]{string, stringArray}, l);
        }
        return bl;
    }

    private ParamManager countParams(String string) throws SQLException {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[1000];
        boolean bl = false;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        if (this instanceof SybCallableStatement && this._hasReturn) {
            stringBuffer = new StringBuffer("0,");
            ++n;
        }
        int n3 = string.length();
        block14: for (int i = 0; i < n3; ++i) {
            switch (string.charAt(i)) {
                case '?': {
                    int n4;
                    if (n2 != 0) continue block14;
                    nArray[n++] = i;
                    if (this instanceof SybCallableStatement) {
                        if (!bl) {
                            if (stringBuffer == null) {
                                stringBuffer = new StringBuffer();
                            }
                            if (this._hasReturn) {
                                stringBuffer.append(n - 1).append(",");
                            } else {
                                stringBuffer.append(n).append(",");
                            }
                        } else if (stringBuffer3 != null) {
                            if (stringBuffer2 == null) {
                                stringBuffer2 = new StringBuffer();
                            }
                            stringBuffer2.append("'");
                            stringBuffer2.append(stringBuffer3.toString().trim());
                            stringBuffer2.append("',");
                            stringBuffer3 = null;
                        }
                    }
                    if (n < (n4 = nArray.length)) continue block14;
                    int[] nArray2 = new int[n4 += 1000];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray = nArray2;
                    continue block14;
                }
                case '\'': {
                    switch (n2) {
                        case 39: {
                            n2 = 0;
                            continue block14;
                        }
                        case 34: {
                            continue block14;
                        }
                    }
                    n2 = 39;
                    continue block14;
                }
                case '\"': {
                    switch (n2) {
                        case 34: {
                            n2 = 0;
                            continue block14;
                        }
                        case 39: {
                            continue block14;
                        }
                    }
                    n2 = 34;
                    continue block14;
                }
                case '@': {
                    if (!(this instanceof SybCallableStatement)) continue block14;
                    bl = true;
                    stringBuffer3 = new StringBuffer();
                    for (int j = i; j < n3; ++j) {
                        char c = string.charAt(j);
                        if (c == '=') {
                            i = j;
                            continue block14;
                        }
                        stringBuffer3.append(c);
                    }
                    continue block14;
                }
            }
        }
        if (stringBuffer != null) {
            this._paramColids = stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        if (stringBuffer2 != null) {
            this._paramNames = stringBuffer2.substring(0, stringBuffer2.length() - 1);
        }
        if (this._batchCmds == null) {
            this._query = string;
        }
        return new ParamManager(n, nArray, this);
    }

    private void setParam(int n, int n2, Object object) throws SQLException {
        this.setParam(n, n2, object, 0);
    }

    protected void setParam(int n, int n2, Object object, int n3) throws SQLException {
        if (this._enableBCP > 0) {
            this.setParamBulk(n, n2, object, n3);
        } else {
            this.setParamRegular(n, n2, object, n3);
        }
    }

    protected void setParamBulk(int n, int n2, Object object, int n3) throws SQLException {
        int n4 = this._sybBCP.getId(n2);
        if (this._sybBCP._columnDefination.size() == 0 && this._sybBCP.hasDroppedColumns()) {
            int n5 = this._sybBCP.getDroppedColumnCountBeforeColumnIndex(n4);
            n4 += n5;
        }
        this._object[n4 - 1] = object;
        this._types[n4 - 1] = n;
        this._scale[n4 - 1] = n3;
        if (this._sybBCP._columnDefination.size() > 0) {
            this._paramMgr.setParam(n2, n4 - 1, n, object, n3);
        } else {
            this._paramMgr.setParam(n2, n, object, n3);
        }
    }

    protected void setParamRegular(int n, int n2, Object object, int n3) throws SQLException {
        if (this._isDynamic) {
            this.addObject(n2 += this._batchOffset, object);
            this.addType(n2, n);
            this.addScale(n2, n3);
        } else {
            this._paramMgr.setParam(n2, n, object, n3);
        }
    }

    private BigDecimal setScale(BigDecimal bigDecimal, int n) {
        bigDecimal = bigDecimal.signum() > 0 ? bigDecimal.setScale(n, RoundingMode.DOWN) : bigDecimal.setScale(n, RoundingMode.UP);
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendQuery(String string, ParamManager paramManager) throws SQLException {
        this.checkDead();
        if (this._isDynamic) {
            try {
                if (this._batchInitialized) {
                    this._protocol.finishCommandExecSession(this._context, this._batchLock);
                } else {
                    Capture capture;
                    boolean bl = true;
                    if (this._numRows == 0) {
                        this._numRows = 1;
                        bl = false;
                    }
                    if ((capture = this._context._conn.getCapture()) != null && capture.isResumed() && this._firstExecuteAfterResume) {
                        this._firstExecute = true;
                        this._firstExecuteAfterResume = false;
                    }
                    this._protocol.dynamicExecute(this._context, this._dynStmtName, paramManager, this._numRows, this._object, this._types, this._cal, this._scale, this._homoGeneousBatch && bl, this._firstExecute);
                    this._firstExecute = false;
                }
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            finally {
                System.arraycopy(this._object, this._batchOffset, this._object, 0, this._paramCount);
                System.arraycopy(this._types, this._batchOffset, this._types, 0, this._paramCount);
                System.arraycopy(this._scale, this._batchOffset, this._scale, 0, this._paramCount);
                System.arraycopy(this._cal, this._batchOffset, this._cal, 0, this._paramCount);
                this._batchOffset = 0;
                this._numRows = 0;
                this._batchLock = false;
                this._batchInitialized = false;
                this._batchCmds = null;
            }
            this._state = IConstants.CONNECTION_STATE.BUSY;
            return false;
        }
        if (this._batchCmds != null) {
            return super.sendQuery(string, paramManager);
        }
        return super.sendQuery(this._query, this._paramMgr);
    }

    public void switchContext(ProtocolContext protocolContext) {
        this._context = protocolContext;
    }

    @Override
    protected void deallocateDynamic() throws SQLException {
        if (this._enableBCP == 0 && this._dynStmtName != null) {
            this._protocol.dynamicDeallocate(this._context, this._dynStmtName);
        }
    }

    protected Vector createDynamicExecuteBatchParams() throws SQLException {
        Vector<ParamManager> vector = new Vector<ParamManager>();
        int n = 0;
        for (int i = 0; i < this._batchCmds.size(); ++i) {
            ParamManager paramManager = this.countParams((String)this._batchCmds.get(0));
            int n2 = paramManager._params.length;
            for (int j = 0; j < n2; ++j) {
                Param param = this._batchParams.get(n);
                paramManager.setParam(j + 1, param._sqlType, param._inValue, param._scale);
                ++n;
            }
            vector.add(paramManager);
        }
        return vector;
    }

    @Override
    protected boolean checkBatch() throws SQLException {
        boolean bl = super.checkBatch();
        boolean bl2 = false;
        if (this._dbmda != null) {
            bl2 = this._dbmda.execParameterizedBatchUpdatesInLoop();
            if (bl2 && this._context._conn._props.getBoolean(15)) {
                bl2 = false;
            }
            bl |= bl2;
        }
        return bl;
    }

    protected void extractParams() throws SQLException {
        int n;
        String string = "?,()={}";
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block8: for (n = 0; n < this._sqlStr.length(); ++n) {
            char c = this._sqlStr.charAt(n);
            if (Character.isWhitespace(c)) {
                ++n4;
                if (!bl) continue;
                vector.addElement(this._sqlStr.substring(n2, n));
                arrayList.add(n4 - 1);
                n4 = 1;
                bl = false;
                continue;
            }
            if (string.indexOf(c) != -1 && n3 == 0) {
                if (bl) {
                    vector.addElement(this._sqlStr.substring(n2, n));
                    arrayList.add(n4);
                    n4 = 0;
                    bl = false;
                }
                vector.addElement(String.valueOf(c));
                arrayList.add(n4);
                continue;
            }
            if (!bl) {
                n2 = n;
                bl = true;
            }
            if (c == '\'') {
                switch (n3) {
                    case 16: {
                        n3 &= 0xFFFFFFEF;
                        break;
                    }
                    case 32: {
                        break;
                    }
                    default: {
                        n3 |= 0x10;
                    }
                }
            }
            if (c != '\"') continue;
            n4 = 0;
            switch (n3) {
                case 32: {
                    n3 &= 0xFFFFFFDF;
                    continue block8;
                }
                case 16: {
                    continue block8;
                }
                default: {
                    n3 |= 0x20;
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        n3 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        this._paramNameList = new Vector();
        this._rowFmtIdxList = new Vector();
        int n8 = 1;
        this._literalIdxList = new Vector();
        this._literalValueList = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            String string2 = (String)vector.get(n);
            if ((string2.equals("(") || string2.equals(")")) && (n3 & 8) == 0) {
                n5 = string2.equals("(") ? ++n5 : --n5;
                if (n5 != 1) continue;
                n3 |= 1;
                continue;
            }
            if (string2.equals("{") || string2.equals("}")) {
                n6 = string2.equals("{") ? ++n6 : ++n6;
                if (n6 == 1) {
                    n3 |= 0x40;
                    continue;
                }
                n3 &= 0xFFFFFFBF;
                continue;
            }
            if (string2.equalsIgnoreCase("values") && n3 == 0) {
                n3 |= 2;
                continue;
            }
            if (string2.equalsIgnoreCase("set") && n3 == 0) {
                n3 |= 4;
                continue;
            }
            if (string2.equalsIgnoreCase("where") && n3 == 4) {
                n3 = 0;
                n3 |= 8;
                stringBuffer.append(string2);
                stringBuffer.append(' ');
                continue;
            }
            if (string2.equalsIgnoreCase("call")) {
                n3 |= 0x80;
                continue;
            }
            if (n3 == 1 && this._type == 16) {
                if (string2.equals(",")) continue;
                this._paramNameList.addElement(string2);
                continue;
            }
            if ((n3 & 3) == 3 || (n3 & 0xC0) == 192) {
                if (string2.equals("?")) {
                    this._rowFmtIdxList.addElement(new Integer(n7++));
                    continue;
                }
                if (string2.equals(",")) {
                    ++n8;
                    continue;
                }
                int n9 = this._literalIdxList.indexOf(n8);
                if (n9 != -1) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (int i = 0; i < (Integer)arrayList.get(n); ++i) {
                        stringBuffer2.append(" ");
                    }
                    this._literalValueList.set(n9, this._literalValueList.get(n9).toString() + stringBuffer2.toString() + vector.get(n));
                    continue;
                }
                this._literalIdxList.addElement(new Integer(n8));
                this._literalValueList.addElement(vector.get(n));
                continue;
            }
            if (n3 == 4) {
                if (!string2.equals("=") || !((String)vector.get(n + 1)).equals("?")) continue;
                this._paramNameList.addElement((String)vector.get(n - 1));
                this._rowFmtIdxList.addElement(new Integer(n7++));
                ++n8;
                continue;
            }
            if (n3 != 8) continue;
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        if (stringBuffer.length() > 0) {
            this._whereBlock = stringBuffer.toString();
            this._whereBlock.trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            try {
                if (this._dbmda == null) {
                    this._dbmda = (SybDatabaseMetaData)this._context._conn.getMetaData();
                }
                if (this._dbmda.getDatabaseProductName().indexOf("Anywhere") != -1) {
                    ParameterMetaData parameterMetaData = null;
                    return parameterMetaData;
                }
            }
            catch (SQLException sQLException) {
                ParameterMetaData parameterMetaData = null;
                return parameterMetaData;
            }
            if (this._dynStmtName == null) {
                try {
                    int n = this._context._conn.getDynStmtNum();
                    String string = "dyn" + n;
                    this._context._conn.setDynStmtNum(++n);
                    this._protocol.dynamicPrepare(this._context, string, this._sqlStr, this._paramMgr);
                    this._dynStmtName = string;
                }
                catch (SQLException sQLException) {
                    int n;
                    if (this._type != 16 && this._type != 8) {
                        throw sQLException;
                    }
                    this.extractParams();
                    StringBuffer stringBuffer = new StringBuffer("select ");
                    if (this._paramNameList == null || this._paramNameList.isEmpty()) {
                        stringBuffer.append('*');
                    } else {
                        for (n = 0; n < this._paramNameList.size(); ++n) {
                            stringBuffer.append((String)this._paramNameList.get(n));
                            if (n == this._paramNameList.size() - 1) continue;
                            stringBuffer.append(',');
                        }
                    }
                    stringBuffer.append(" from " + this._table);
                    if (this._whereBlock != null && this._whereBlock.length() > 0) {
                        stringBuffer.append(" " + this._whereBlock);
                    }
                    n = this._context._conn.getDynStmtNum();
                    String string = "dyn" + n;
                    this._context._conn.setDynStmtNum(++n);
                    this._protocol.dynamicPrepare(this._context, string, stringBuffer.toString(), this._paramMgr);
                    this._dynStmtName = string;
                }
            }
            SybPreparedStatement sybPreparedStatement = this;
            return sybPreparedStatement;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getParameterMetaData", null, null, l);
            }
        }
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        Debug.notImplemented(this, "getParameterClassName(int)");
        return null;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this._paramMgr._paramMdList.size();
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        this.checkIndex(n);
        return ((Param)this._paramMgr._paramMdList.get((int)(--n)))._regType;
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        this.checkIndex(n);
        return ((Param)this._paramMgr._paramMdList.get((int)(--n)))._sqlType;
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        this.checkIndex(n);
        return ((Param)this._paramMgr._paramMdList.get((int)(--n)))._sqlTypeName;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkIndex(n);
        return ((Param)this._paramMgr._paramMdList.get((int)(--n)))._precision;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkIndex(n);
        return ((Param)this._paramMgr._paramMdList.get((int)(--n)))._scale;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkIndex(n);
        return ((Param)this._paramMgr._paramMdList.get((int)(--n)))._isNullable;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.checkIndex(n);
        return ((Param)this._paramMgr._paramMdList.get((int)(--n)))._isSigned;
    }

    private void checkIndex(int n) throws SQLException {
        if (n < 1 || n > this._paramMgr._paramMdList.size()) {
            ErrorMessage.raiseError("JZ0SB", "" + n);
        }
    }

    public int getNumCols() {
        return this._paramCount;
    }

    public Protocol getProtocol() {
        return this._protocol;
    }

    public String getDbName() throws SQLException {
        return this._context._conn.getCatalog();
    }

    private void setEnableBCP(String string) throws SQLException {
        if (string == null || string.equalsIgnoreCase("NONE") || string.equalsIgnoreCase("FALSE")) {
            this._enableBCP = 0;
        } else if (string.equalsIgnoreCase("TRUE") || string.equalsIgnoreCase("ARRAYINSERT_WITH_MIXED_STATEMENTS")) {
            this._enableBCP = 1;
        } else if (string.equalsIgnoreCase("ARRAYINSERT")) {
            this._enableBCP = 2;
        } else if (string.equalsIgnoreCase("BCP")) {
            this._enableBCP = 3;
        } else if (string.equalsIgnoreCase("LOG_BCP")) {
            if (this._dbmda != null) {
                if (this._dbmda.isFastLoggedBCPSupported()) {
                    this._protocol.setOption(null, 14, true);
                } else {
                    this.chainWarning(ErrorMessage.createWarning("01S13"));
                }
            }
            this._enableBCP = 3;
        } else {
            ErrorMessage.raiseError("JZBKI");
        }
    }

    private void prepareBCP(ProtocolContext protocolContext) throws SQLException {
        this.setEnableBCP(protocolContext._conn._props.getString(68));
        if (this._enableBCP > 0) {
            this.extractParams();
            try {
                this._sybBCP = new SybBCP(this, this._enableBCP);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 2812) {
                    ErrorMessage.raiseError("JZBK1");
                }
                if (sQLException.getSQLState().equalsIgnoreCase("JZ0R2")) {
                    ErrorMessage.raiseError("JZBK3");
                }
                this.handleSQLE(sQLException);
            }
            int n = this._sybBCP.getColumnCount();
            if (n == 0) {
                ErrorMessage.raiseError("JZBK3");
            }
            this.initializeParamArrays(n);
            if (this._enableBCP == 1 && this._bulkObject == null) {
                this._bulkObject = new LinkedList();
                this._bulkTypes = new LinkedList();
                this._bulkScale = new LinkedList();
                this._bulkCal = new LinkedList();
            }
            boolean bl = false;
            if (this._sybBCP._columnDefination.size() > 0) {
                bl = true;
            }
            for (int i = 0; i < n; ++i) {
                this._sybBCP.getColumnMetaDataAll(15 * i, 2 * i);
                this._sybBCP.setColumnIdList(i, bl);
                if (this._sybBCP.getColumnDefault() != null) {
                    this._sybBCP.findDefaults(this._paramMgr._params[0], i);
                }
                this._sybBCP.setEncrypted();
            }
        } else {
            this.initializeParamArrays(this._paramCount);
        }
    }

    private boolean isInsertInSQL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        boolean bl = false;
        int n = stringTokenizer.nextToken().compareToIgnoreCase("insert");
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    private void initializeParamArrays(int n) {
        this._types = new int[n];
        this._scale = new int[n];
        this._cal = new Calendar[n];
        this._object = new Object[n];
        this._batchFirstRowParamType = new int[n];
        for (int i = 0; i < n; ++i) {
            this._types[i] = -999;
            this._batchFirstRowParamType[i] = -999;
        }
    }

    protected void addCalendar(int n, Calendar calendar) {
        this._cal[n - 1] = calendar != null ? (Calendar)calendar.clone() : calendar;
    }

    private void addObject(int n, Object object) {
        this._object[n - 1] = object;
    }

    private void addScale(int n, int n2) {
        this._scale[n - 1] = n2;
    }

    private void addType(int n, int n2) {
        this._types[n - 1] = n2;
    }

    protected ParamManager setParamsFromArrays() throws SQLException {
        for (int i = 0; i < this._paramMgr._params.length; ++i) {
            Object object = this._object[i];
            switch (this._types[i]) {
                case 91: 
                case 92: 
                case 93: {
                    object = this._cal[i] != null ? new DateObject(object, this._cal[i], this._types[i]) : new DateObject(object, this._types[i]);
                }
            }
            this._paramMgr.setParam(i + 1, this._types[i], object, this._scale[i]);
        }
        return this._paramMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNString(int n, String string) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -9);
            this.setParam(-9, n, string);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setNString", "int, String", new Object[]{n, string}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setNString", "int, String", new Object[]{n, string}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -1);
            this.setAsciiStream(n, inputStream, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "int, InputStream", new Object[]{n, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "int, InputStream", new Object[]{n, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -1);
            if (inputStream == null) {
                this.setNull(n, -1);
            } else {
                int n2 = this.checkLongLength(l);
                this.setAsciiStream(n, inputStream, n2);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "int, InputStream, long", new Object[]{n, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "int, InputStream, long", new Object[]{n, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -4);
            this.setBinaryStream(n, inputStream, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "int, InputStream", new Object[]{n, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "int, InputStream", new Object[]{n, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -4);
            int n2 = this.checkLongLength(l);
            this.setBinaryStream(n, inputStream, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "int, InputStream, long", new Object[]{n, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "int, InputStream, long", new Object[]{n, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -1);
            this.setCharacterStream(n, reader, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "int, Reader", new Object[]{n, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "int, Reader", new Object[]{n, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -1);
            int n2 = this.checkLongLength(l);
            this.setCharacterStream(n, reader, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "int, Reader", new Object[]{n, reader}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "int, Reader", new Object[]{n, reader}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -16);
            this.setParam(-16, n, reader, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setNCharacterStream", "int, Reader", new Object[]{n, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setNCharacterStream", "int, Reader", new Object[]{n, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -16);
            int n2 = this.checkLongLength(l);
            this.setParam(-16, n, reader, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "executeQuery", "int, Reader, long", new Object[]{n, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "executeQuery", "int, Reader, long", new Object[]{n, reader, l}, l2);
    }

    protected int checkLongLength(long l) {
        int n;
        if (l > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
            this._context._conn.chainWarnings(ErrorMessage.createWarning("01S11"));
        } else {
            n = (int)l;
        }
        return n;
    }

    @Override
    protected String batchToString() {
        return this._isDynamic ? this._dynStmtName : super.batchToString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -1);
            this.setParam(-1, n, reader, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setClob", "int, Reader", new Object[]{n, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setClob", "int, Reader", new Object[]{n, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            if (l < -1L) {
                ErrorMessage.raiseError("JZ039");
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -1);
            int n2 = this.checkLongLength(l);
            this.setParam(-1, n, reader, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setClob", "int, Reader, long", new Object[]{n, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setClob", "int, Reader, long", new Object[]{n, reader, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(int, Reader)");
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setNClob", "int, Reader", new Object[]{n, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setNClob", "int, Reader", new Object[]{n, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(int, Reader, long)");
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setNClob", "int, Reader, long", new Object[]{n, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setNClob", "int, Reader, long", new Object[]{n, reader, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -4);
            this.setParam(-4, n, inputStream, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBlob", "int, InputStream", new Object[]{n, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBlob", "int, InputStream", new Object[]{n, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            if (l < -1L) {
                ErrorMessage.raiseError("JZ039");
            }
            this.checkDead();
            this.checkIfMixedWithLob(n, -4);
            int n2 = this.checkLongLength(l);
            this.setParam(-4, n, inputStream, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBlob", "int, InputStream, long", new Object[]{n, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBlob", "int, InputStream, long", new Object[]{n, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            Debug.notImplemented(this, "public void setRowId(int arg0, RowId arg1)");
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setRowId", "int, RowId", new Object[]{n, rowId}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setRowId", "int, RowId", new Object[]{n, rowId}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            Debug.notImplemented(this, "public void setSQLXML(int arg0, SQLXML arg1)");
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setSQLXML", "int, SQLXML", new Object[]{n, sQLXML}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setSQLXML", "int, SQLXML", new Object[]{n, sQLXML}, l);
    }

    @Override
    protected void checkStatementAndTransaction(boolean bl) throws SQLException {
        if (this._batchInitialized) {
            return;
        }
        super.checkStatementAndTransaction(bl);
    }

    protected boolean isBatchingInitialized() {
        return this._batchInitialized;
    }
}

