/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.charset.CharsetUtil;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.security.asn1.ASN1InputStream;
import com.sybase.jdbc4.security.asn1.DERSequence;
import com.sybase.jdbc4.security.asn1.x509.RSAPublicKeyStructure;
import com.sybase.jdbc4.security.util.Base64Tools;
import com.sybase.jdbc4.tds.Encryption;
import com.sybase.jdbc4.tds.MsgToken;
import com.sybase.jdbc4.tds.Tds;
import com.sybase.jdbc4.tds.TdsDataObject;
import com.sybase.jdbc4.tds.TdsInt;
import com.sybase.jdbc4.tds.TdsJdbcInputStream;
import com.sybase.jdbc4.tds.TdsProtocolContext;
import com.sybase.jdbc4.utils.JCEProviderUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.sql.SQLException;
import javax.crypto.Cipher;

public final class SecLoginContext {
    private byte[] _salt = null;
    private byte[] _nonce = null;
    private Tds _protocol = null;
    private Cipher _cipherSuite = null;
    private int _encryptMsgId;

    SecLoginContext(Tds tds, int n) throws SQLException {
        this._protocol = tds;
        this._encryptMsgId = n;
        SybProperty sybProperty = this._protocol.getSybProperty();
        if (this._encryptMsgId == 14 || this._encryptMsgId == 30) {
            try {
                Object object = sybProperty.getObject(66);
                boolean bl = sybProperty.getBoolean(104);
                JCEProviderUtil.initProvider(object, bl);
            }
            catch (Exception exception) {
                ErrorMessage.raiseError("JZ028", new SQLException(exception));
            }
        }
    }

    void getKey(TdsProtocolContext tdsProtocolContext) throws IOException, SQLException {
        TdsDataObject tdsDataObject;
        this._protocol.nextResult(tdsProtocolContext);
        int n = tdsProtocolContext._in.readUnsignedByte();
        int n2 = 0;
        if (this._encryptMsgId == 14 || this._encryptMsgId == 30) {
            tdsDataObject = new TdsInt(tdsProtocolContext);
            ((TdsInt)tdsDataObject)._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(n2);
            ((TdsInt)tdsDataObject).getInt();
            try {
                this._cipherSuite = JCEProviderUtil.createCipherSuite();
            }
            catch (GeneralSecurityException generalSecurityException) {
                ErrorMessage.raiseError("JZ0LA", "RSA/ECB/OAEPWithSHA1AndMGF1Padding or RSA/NONE/OAEPWithSHA1AndMGF1Padding");
            }
            ++n2;
        }
        tdsDataObject = new TdsJdbcInputStream(null, tdsProtocolContext, this._protocol);
        ((TdsJdbcInputStream)tdsDataObject)._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(n2);
        this._salt = ((TdsJdbcInputStream)tdsDataObject).getBytes();
        ++n2;
        if (this._encryptMsgId == 30) {
            TdsJdbcInputStream tdsJdbcInputStream = new TdsJdbcInputStream(null, tdsProtocolContext, this._protocol);
            tdsJdbcInputStream._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(n2);
            this._nonce = tdsJdbcInputStream.getBytes();
        }
        tdsProtocolContext._lastResult = -1;
        this._protocol.nextResult(tdsProtocolContext);
    }

    void sendEncPwd(TdsProtocolContext tdsProtocolContext, String string) throws SQLException, IOException {
        Object object;
        Object object2;
        if (string == null) {
            string = "";
        }
        byte[] byArray = this._protocol._charsetName == null ? string.getBytes() : (this._protocol._charsetName.equals("x-SybUTF8") ? CharsetUtil.fromSybUTF8(string) : string.getBytes(this._protocol._charsetName));
        byte[] byArray2 = null;
        int n = 2;
        int n2 = 3;
        int n3 = -3;
        if (this._encryptMsgId == 14 || this._encryptMsgId == 30) {
            if (this._encryptMsgId == 30) {
                n = 31;
                n2 = 32;
                n3 = -4;
                byArray = this.prependNonce(byArray);
            } else {
                n = 15;
                n2 = 22;
            }
            try {
                object2 = this._protocol._charsetName == null ? new String(this._salt) : (this._protocol._charsetName.equals("x-SybUTF8") ? CharsetUtil.toSybUTF8(this._salt) : new String(this._salt, this._protocol._charsetName));
                object = new ASN1InputStream(this.decodePEM(new StringReader((String)object2)));
                DERSequence dERSequence = (DERSequence)((ASN1InputStream)object).readObject();
                RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure(dERSequence);
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKeyStructure.getModulus(), rSAPublicKeyStructure.getPublicExponent());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
                this._cipherSuite.init(1, publicKey);
                byArray2 = this._cipherSuite.doFinal(byArray);
            }
            catch (GeneralSecurityException generalSecurityException) {
                ErrorMessage.raiseError("JZ0P4");
            }
        } else {
            byArray2 = new byte[33];
            object2 = new Encryption();
            int n4 = ((Encryption)object2).pwd_encrypt(this._salt, this._salt.length, byArray, byArray.length, byArray2);
            byArray2[32] = (byte)n4;
        }
        object2 = new MsgToken(1, (short)n);
        object = new ParamManager(1, tdsProtocolContext);
        ((ParamManager)object).setParam(1, n3, (Object)byArray2, 0);
        ((MsgToken)object2).send(this._protocol._out);
        this._protocol.sendParamStream((ParamManager)object, this._protocol._out);
        object2 = new MsgToken(1, (short)n2);
        object = new ParamManager(2, tdsProtocolContext);
        ((ParamManager)object).setParam(1, 12, null, 0);
        ((ParamManager)object).setParam(2, n3, (Object)byArray2, 0);
        ((MsgToken)object2).send(this._protocol._out);
        this._protocol.sendParamStream((ParamManager)object, this._protocol._out);
        this._protocol._out.flush();
    }

    private byte[] decodePEM(Reader reader) throws SQLException, IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        boolean bl = false;
        StringWriter stringWriter = new StringWriter();
        while ((string = bufferedReader.readLine()) != null) {
            if (!bl && string.startsWith("-----BEGIN")) {
                bl = true;
                continue;
            }
            if (bl && string.startsWith("-----END")) break;
            stringWriter.write(string);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64Tools.decode(new StringReader(stringWriter.toString()), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] prependNonce(byte[] byArray) {
        byte[] byArray2 = new byte[this._nonce.length + byArray.length];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = i < this._nonce.length ? this._nonce[i] : byArray[i - this._nonce.length];
        }
        return byArray2;
    }
}

