/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.csi.test;

import com.sap.security.core.server.csi.URLChecker;
import com.sap.security.core.server.csi.XSSEncoder;
import com.sap.security.core.server.csi.util.URLEncoder;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Locale;

public final class URLTester {
    public static String[] _goodURLs = new String[]{"http://hostname:50000/dtr/ws/N1XMOD..                                          ", "http://www.test.de                                                             ", "HTTP://WWW.TEST.DE                                                             ", "Http://WWW.Test.De                                                             ", "http:www.test.de                                                               ", "http://www.test.de#last?id=me                                                  ", "http://www.test.de/My%20Documents.html                                         ", "http://www.test.de?%253c%2520script%3a%3e%20%20                                ", "http://www.test.de?me=%2527scrip%20t%2527                                      ", "http://www.test.de?me=%2527script%2527%26you=23                                ", "http://www.test.de?me=1%2b1                                                    ", "/sap/../lang/package-summary.html#charenc                                      ", "Http://www.test.de/one/two/../../four?#Idontknow                               ", "com.sap.eu&param4=%3A+%21%22%C2%A7%24%25%26%2F%28%29%3F%C3%BC%C3%B6%C3%A4%C3   ", "../../resources/WebDynpro/global/SSR                                           ", "news:                                                                          ", "mailto:                                                                        "};
    public static String[] _badURLs = new String[]{"http://example.test/index.cgi?cgi-bin/index.cgi%00.html                        ", "file://a/.././g?<script></script>                                              ", "file://a/../../../.././test                                                    ", "javascript:alert('s');                                                         ", "about:blank                                                                    ", "http://www.hallo.de/ich.html?test=<script>alert('Hi')</script>                 ", "http://www.hallo.de/ich.html?test=%3cscript%3ealert(%27hello%27)%3c%2fscript%3e", "Http://www.test.de/one/two/../../../four?#Idontknow                            "};
    public static String[] _nowGoodUURLs = new String[]{"about:blank                                                                    ", "flash://test.de/                                                               ", "mailto:addr1%2C%20addr2                                                        ", "mailto:                                                                        ", "MailTo:                                                                        ", "mailto:addr1%2C%20addr2                                                        ", "http://www.sap.com                                                             ", "http://sap.com                                                                 "};
    public static String[] _whiteCheckURLs = new String[]{"http://www.sap.com/?kkk=d                                                      ", "http://www.sap.de/?kkk=d                                                       "};

    public static void main(String[] args) {
        int i;
        URLChecker goodChecker = new URLChecker();
        URLChecker badChecker = new URLChecker();
        URLChecker nowGoodChecker = new URLChecker();
        URLChecker whiteListCheck = new URLChecker();
        for (i = 0; i < _goodURLs.length; ++i) {
            System.out.print("Check good URL: " + _goodURLs[i]);
            try {
                if (goodChecker.isValid(_goodURLs[i].trim())) {
                    System.out.print(" OK\n");
                    continue;
                }
                System.out.print(" NOT OK\n");
                continue;
            }
            catch (MalformedURLException e) {
                System.out.print(" NOT OK\n");
            }
        }
        for (i = 0; i < _badURLs.length; ++i) {
            System.out.print("Check bad  URL: " + _badURLs[i]);
            try {
                if (!badChecker.isValid(_badURLs[i].trim())) {
                    System.out.print(" OK\n");
                    continue;
                }
                System.out.print(" NOT OK\n");
                continue;
            }
            catch (MalformedURLException e) {
                System.out.print(" OK, error: " + e.getLocalizedMessage() + "\n");
            }
        }
        nowGoodChecker.addProtocol("flash");
        nowGoodChecker.addProtocol("about");
        nowGoodChecker.addProtocol("mailto");
        nowGoodChecker.setHosts(new String[]{"www.sap.com", "sap.com", "test.de"});
        for (i = 0; i < _nowGoodUURLs.length; ++i) {
            System.out.print("Check cust URL: " + _nowGoodUURLs[i]);
            try {
                if (nowGoodChecker.isValid(_nowGoodUURLs[i].trim())) {
                    System.out.print(" OK\n");
                    continue;
                }
                System.out.print(" NOT OK\n");
                continue;
            }
            catch (MalformedURLException e) {
                System.out.print(" NOT OK\n");
            }
        }
        whiteListCheck.setWhiteURLPattern("(.*)www\\.sap\\.com*");
        whiteListCheck.addWhiteURLPattern("(.*)\\.de");
        for (i = 0; i < _whiteCheckURLs.length; ++i) {
            System.out.print("Check whit URL: " + _whiteCheckURLs[i]);
            try {
                if (whiteListCheck.isValid(_whiteCheckURLs[i].trim())) {
                    System.out.print(" OK\n");
                    continue;
                }
                System.out.print(" NOT OK\n");
                continue;
            }
            catch (MalformedURLException e) {
                System.out.print(" NOT OK, error: " + e.getLocalizedMessage() + "\n");
            }
        }
        System.out.println("Start Excaping");
        try {
            URLTester.checkXSSMLEscaping(false);
            URLTester.checkXSSMLEscaping(true);
            System.out.println("XML / HTML Excaping Done");
            URLTester.checkXSSURLEscaping(false);
            URLTester.checkXSSURLEscaping(true);
            System.out.println("URL Excaping Done");
            URLTester.checkXSSJSEscaping(false);
            URLTester.checkXSSJSEscaping(true);
            System.out.println("JavaScript Excaping Done");
            URLTester.checkXSSCSSEscaping(false);
            URLTester.checkXSSCSSEscaping(true);
            System.out.println("CSS Excaping Done");
        }
        catch (UnsupportedEncodingException e) {
            System.out.print("Escaping error: " + e + "\n");
        }
    }

    public static boolean checkDynamic(String uri) {
        try {
            URLChecker c = new URLChecker(uri);
            c.setDefaultProtocol("https");
            return c.isValid();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void checkXSSMLEscaping(boolean aboveFF) throws UnsupportedEncodingException {
        int i;
        String _char;
        CharSequence _out = _char = "";
        for (i = 0; i < 256; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeHTML(_char, aboveFF);
            if (i >= 0 && i < 32) {
                if (i == 9) {
                    URLTester.checkValue(_out, "&#x9;");
                    continue;
                }
                if (i == 10) {
                    URLTester.checkValue(_out, "&#xa;");
                    continue;
                }
                if (i == 13) {
                    URLTester.checkValue(_out, "&#xd;");
                    continue;
                }
                URLTester.checkValue(_out, "&#xfffd;");
                continue;
            }
            if (i >= 32 && i < 44) {
                if (i == 34) {
                    URLTester.checkValue(_out, "&quot;");
                    continue;
                }
                if (i == 38) {
                    URLTester.checkValue(_out, "&amp;");
                    continue;
                }
                URLTester.checkValue(_out, "&#x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + ";");
                continue;
            }
            if (i >= 44 && i < 58) {
                if (i == 47) {
                    URLTester.checkValue(_out, "&#x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + ";");
                    continue;
                }
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 58 && i < 65) {
                if (i == 60) {
                    URLTester.checkValue(_out, "&lt;");
                    continue;
                }
                if (i == 62) {
                    URLTester.checkValue(_out, "&gt;");
                    continue;
                }
                URLTester.checkValue(_out, "&#x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + ";");
                continue;
            }
            if (i >= 65 && i < 91) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 91 && i < 97) {
                if (i == 95) {
                    URLTester.checkValue(_out, new String(new char[]{(char)i}));
                    continue;
                }
                URLTester.checkValue(_out, "&#x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + ";");
                continue;
            }
            if (i >= 97 && i < 123) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 123 && i < 127) {
                URLTester.checkValue(_out, "&#x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + ";");
                continue;
            }
            if (i >= 127 && i < 160) {
                URLTester.checkValue(_out, "&#xfffd;");
                continue;
            }
            if (i < 160 || i >= 256) continue;
            URLTester.checkValue(_out, "&#x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + ";");
        }
        for (i = 8232; i < 8234; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeHTML(_char, aboveFF);
            URLTester.checkValue(_out, "&#x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + ";");
        }
        for (i = 256; i < 5000; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeHTML(_char, aboveFF);
            if (!aboveFF) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            URLTester.checkValue(_out, "&#x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + ";");
        }
        for (i = 20000; i < 21000; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeHTML(_char, aboveFF);
            if (!aboveFF) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            URLTester.checkValue(_out, "&#x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + ";");
        }
    }

    private static void checkXSSURLEscaping(boolean aboveFF) throws UnsupportedEncodingException {
        int i;
        String _char;
        CharSequence _out = _char = "";
        for (i = 0; i < 256; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeURL(_char, aboveFF);
            if (i >= 0 && i < 16) {
                URLTester.checkValue(_out, "%0" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (i >= 16 && i < 48) {
                if (i == 42) {
                    URLTester.checkValue(_out, new String(new char[]{(char)i}));
                    continue;
                }
                if (i == 45) {
                    URLTester.checkValue(_out, new String(new char[]{(char)i}));
                    continue;
                }
                if (i == 46) {
                    URLTester.checkValue(_out, new String(new char[]{(char)i}));
                    continue;
                }
                URLTester.checkValue(_out, "%" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (i >= 48 && i < 58) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 58 && i < 65) {
                URLTester.checkValue(_out, "%" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (i >= 65 && i < 91) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 91 && i < 97) {
                if (i == 95) {
                    URLTester.checkValue(_out, new String(new char[]{(char)i}));
                    continue;
                }
                URLTester.checkValue(_out, "%" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (i >= 97 && i < 123) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 123 && i < 127) {
                URLTester.checkValue(_out, "%" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            URLTester.checkValue(_out, URLEncoder.encode(new String(new char[]{(char)i}), "UTF-8").toLowerCase(Locale.ENGLISH));
        }
        for (i = 8232; i < 8234; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeURL(_char, aboveFF);
            URLTester.checkValue(_out, URLEncoder.encode(new String(new char[]{(char)i}), "UTF-8").toLowerCase(Locale.ENGLISH));
        }
        for (i = 256; i < 5000; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeURL(_char, aboveFF);
            URLTester.checkValue(_out, URLEncoder.encode(new String(new char[]{(char)i}), "UTF-8").toLowerCase(Locale.ENGLISH));
        }
        for (i = 20000; i < 21000; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeURL(_char, aboveFF);
            URLTester.checkValue(_out, URLEncoder.encode(new String(new char[]{(char)i}), "UTF-8").toLowerCase(Locale.ENGLISH));
        }
    }

    private static void checkXSSJSEscaping(boolean aboveFF) throws UnsupportedEncodingException {
        int i;
        String _char;
        CharSequence _out = _char = "";
        for (i = 0; i < 256; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeJavaScript(_char, aboveFF);
            if (i >= 0 && i < 16) {
                URLTester.checkValue(_out, "\\x0" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (i >= 16 && i < 48) {
                if (i == 44) {
                    URLTester.checkValue(_out, new String(new char[]{(char)i}));
                    continue;
                }
                if (i == 46) {
                    URLTester.checkValue(_out, new String(new char[]{(char)i}));
                    continue;
                }
                URLTester.checkValue(_out, "\\x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (i >= 48 && i < 58) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 58 && i < 65) {
                URLTester.checkValue(_out, "\\x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (i >= 65 && i < 91) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 91 && i < 97) {
                if (i == 95) {
                    URLTester.checkValue(_out, new String(new char[]{(char)i}));
                    continue;
                }
                URLTester.checkValue(_out, "\\x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (i >= 97 && i < 123) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 123 && i < 127) {
                URLTester.checkValue(_out, "\\x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            URLTester.checkValue(_out, "\\x" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
        }
        for (i = 8232; i < 8234; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeJavaScript(_char, aboveFF);
            URLTester.checkValue(_out, "\\u" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
        }
        for (i = 256; i < 5000; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeJavaScript(_char, aboveFF);
            if (!aboveFF) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i < 4096) {
                URLTester.checkValue(_out, "\\u0" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
                continue;
            }
            URLTester.checkValue(_out, "\\u" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
        }
        for (i = 20000; i < 21000; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeJavaScript(_char, aboveFF);
            if (!aboveFF) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            URLTester.checkValue(_out, "\\u" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH));
        }
    }

    private static void checkXSSCSSEscaping(boolean aboveFF) throws UnsupportedEncodingException {
        int i;
        String _char;
        CharSequence _out = _char = "";
        for (i = 0; i < 256; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeCSS(_char, aboveFF);
            if (i >= 0 && i < 16) {
                URLTester.checkValue(_out, "\\0" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + " ");
                continue;
            }
            if (i >= 16 && i < 48) {
                URLTester.checkValue(_out, "\\" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + " ");
                continue;
            }
            if (i >= 48 && i < 58) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 58 && i < 65) {
                URLTester.checkValue(_out, "\\" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + " ");
                continue;
            }
            if (i >= 65 && i < 91) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 91 && i < 97) {
                URLTester.checkValue(_out, "\\" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + " ");
                continue;
            }
            if (i >= 97 && i < 123) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            if (i >= 123 && i < 127) {
                URLTester.checkValue(_out, "\\" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + " ");
                continue;
            }
            URLTester.checkValue(_out, "\\" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + " ");
        }
        for (i = 8232; i < 8234; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeCSS(_char, aboveFF);
            URLTester.checkValue(_out, "\\" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + " ");
        }
        for (i = 256; i < 5000; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeCSS(_char, aboveFF);
            if (!aboveFF) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            URLTester.checkValue(_out, "\\" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + " ");
        }
        for (i = 20000; i < 21000; ++i) {
            _char = new Character((char)i).toString();
            _out = XSSEncoder.encodeCSS(_char, aboveFF);
            if (!aboveFF) {
                URLTester.checkValue(_out, new String(new char[]{(char)i}));
                continue;
            }
            URLTester.checkValue(_out, "\\" + Integer.toHexString(i).toLowerCase(Locale.ENGLISH) + " ");
        }
    }

    private static void checkValue(CharSequence in, String exp) throws UnsupportedEncodingException {
        if (in == null) {
            throw new UnsupportedEncodingException("Null encoding");
        }
        if (0 != ((Object)in).toString().compareTo(exp)) {
            throw new UnsupportedEncodingException("Wrong output encoding, expected: " + exp);
        }
    }
}

