/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.csi.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class URLDecoder {
    static Class _URLDecoder;
    static Method _decode;
    static final String INVOKE_COMMAND_ATTR = "decode";
    static final String defaultDec = "UTF-8";

    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, defaultDec);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String decodeAll(String s, String enc) {
        return URLDecoder.decodeAll(s, enc, false);
    }

    public static String decodeAll(String s, String enc, boolean ignoreExceptions) {
        int cnt = 0;
        try {
            String decoded = null;
            String decoded2 = s;
            do {
                try {
                    decoded = decoded2;
                    decoded2 = URLDecoder.decodeEx(decoded, enc);
                    ++cnt;
                }
                catch (Exception ee) {
                    if (cnt > 0 && !ignoreExceptions) continue;
                }
            } while (!decoded.equalsIgnoreCase(decoded2));
            return decoded;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String decode2Depth(String s, String enc, int limit) {
        try {
            String decoded;
            int depth = 0;
            String decoded2 = s;
            while (!(decoded = decoded2).equalsIgnoreCase(decoded2 = URLDecoder.decodeEx(decoded, enc)) && ++depth <= limit + 1) {
            }
            if (depth > limit) {
                return "";
            }
            return decoded;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int decodedDepth(String s, int limit) {
        try {
            String decoded;
            int depth = 0;
            String decoded2 = s;
            while (!(decoded = decoded2).equalsIgnoreCase(decoded2 = URLDecoder.decode(decoded)) && ++depth < limit + 1) {
            }
            return depth - 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int decodedDepth(String s) {
        return URLDecoder.decodedDepth(s, Integer.MAX_VALUE);
    }

    public static String decode(String s, String enc) {
        try {
            return (String)_decode.invoke((Object)_URLDecoder, s, enc);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String decodeEx(String s, String enc) throws UnsupportedEncodingException {
        try {
            return (String)_decode.invoke((Object)_URLDecoder, s, enc);
        }
        catch (InvocationTargetException ive) {
            throw new UnsupportedEncodingException(ive.getTargetException().getLocalizedMessage());
        }
        catch (Exception e) {
            return "";
        }
    }

    static {
        try {
            if (_URLDecoder == null) {
                _URLDecoder = Class.forName("java.net.URLDecoder");
            }
            if (_decode == null) {
                _decode = _URLDecoder.getMethod(INVOKE_COMMAND_ATTR, String.class, String.class);
            }
        }
        catch (ClassNotFoundException ex) {
            _URLDecoder = null;
            _decode = null;
        }
        catch (Exception e) {
            _URLDecoder = null;
            _decode = null;
        }
    }
}

