/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tenant.api;

import com.sap.core.tenant.api.TenantService;
import com.sap.core.tenant.common.TenantData;
import com.sap.core.tenant.service.impl.TenantServiceImpl;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class Tenant {
    public static final String TENANT_HEADER_NAME = "tenant_alias";
    public static final String IGNORE_TENANT_FROM_URL_HEADER_NAME = "SAP-Account-IgnoreFromURL";
    @Deprecated
    public static final String DEFAULT_ID = "default";
    private static final Logger log = Logger.getLogger(Tenant.class);
    private static TenantServiceImpl service;
    private static Object synchronizationMonitor;
    private static boolean isOSGi;

    static {
        synchronizationMonitor = new Object();
        isOSGi = System.getProperty("osgi.configuration.area") != null;
    }

    protected void setTenantService(TenantService tenantService) {
        Tenant.setTenantService0(tenantService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void setTenantService0(TenantService tenantService) {
        service = (TenantServiceImpl)tenantService;
        Object object = synchronizationMonitor;
        synchronized (object) {
            synchronizationMonitor.notifyAll();
        }
    }

    public static TenantData getData() {
        Tenant.checkTenantService();
        return service.getCurrentTenantData();
    }

    public static String getAccountName() {
        TenantData tData = Tenant.getData();
        return tData != null ? tData.getAccountName() : null;
    }

    public static String getId() {
        TenantData data = Tenant.getData();
        if (data == null) {
            return null;
        }
        return data.getId();
    }

    public static String getAccountDisplayName(String tenantId) {
        Tenant.checkTenantService();
        return service.getAccountDisplayName(tenantId);
    }

    public static String getCustomerId() {
        TenantData data = Tenant.getData();
        if (data == null) {
            return null;
        }
        return data.getCustomerId();
    }

    public static List<TenantData> getSusbcribedTenants() {
        Tenant.checkTenantService();
        return service.getSubscribedTenants();
    }

    public static Map<String, String> getAccountAttributes(String accountName) {
        Tenant.checkTenantService();
        return service.getAccountAttributes(accountName);
    }

    public static Map<String, String> getAccountAttributes(String accountName, String attributeName) {
        Tenant.checkTenantService();
        return service.getAccountAttributes(accountName, attributeName);
    }

    public static boolean isAvailable() {
        Tenant.checkTenantService();
        return service.isTenantAvailable();
    }

    public static void inheritFromParentThread() {
        Tenant.checkTenantService();
        service.inheritFromParentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkTenantService() {
        if (service == null) {
            if (isOSGi) {
                Object object = synchronizationMonitor;
                synchronized (object) {
                    try {
                        int waitTimeMillis = Tenant.getWaitTimeInSeconds() * 1000;
                        long startTimeMillis = System.currentTimeMillis();
                        while (service == null && System.currentTimeMillis() - startTimeMillis < (long)waitTimeMillis) {
                            synchronizationMonitor.wait(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        log.error((Object)("Wait for the Tenant Service OSGi service was interupted because of " + e.toString()), (Throwable)e);
                    }
                }
            }
            service = TenantServiceImpl.getInstance();
            if (service == null) {
                String errorMessage = " TenantData is not available because Tenant Service is not yet initialized. This usually means that a declarative service isinvoking the static methods of the Tenant class during its activation phase. If this is the case, access the Tenancy API through the TenantService OSGi service";
                log.debug((Object)errorMessage);
                throw new IllegalStateException("TenantData is not available because Tenant Service is not yet initialized.");
            }
        }
    }

    private static int getWaitTimeInSeconds() {
        String waitPropsValue = System.getProperty("TenancyWait", "15");
        try {
            return Integer.valueOf(waitPropsValue);
        }
        catch (Exception e) {
            log.warn((Object)("Will wait up to 10 seconds because of " + e.toString()), (Throwable)e);
            return 10;
        }
    }
}

