/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tenant.service.impl;

import com.sap.cloud.account.InvalidTenantException;
import com.sap.cloud.account.TenantAlreadySetException;
import com.sap.core.tenant.api.TenantService;
import com.sap.core.tenant.common.TenantAdministrationException;
import com.sap.core.tenant.common.TenantData;
import com.sap.core.tenant.common.TenantUtils;
import com.sap.core.tenant.registry.runtime.api.Registry;
import com.sap.core.tenant.valve.helper.TenantValveHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.osgi.service.component.ComponentContext;
import org.slf4j.MDC;

public class TenantServiceImpl
implements TenantService {
    private static final Logger LOGGER = Logger.getLogger((String)TenantServiceImpl.class.getName());
    private static final String MDC_TENANT_ALIAS_KEY = "tenant_alias";
    private static final String MDC_TENANT_ID_KEY = "tenant_id";
    private static InheritableThreadLocal<TenantData> threadLocal = new InheritableThreadLocal();
    private static Registry tenantRegistry = null;
    private TenantData vmTenantData = null;
    private String missingVMTenantDataErrorMessage = "";
    private static TenantServiceImpl tenantServiceInstance = null;
    private static InheritableThreadLocal<Boolean> threadLocalInherit = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }

        @Override
        protected Boolean childValue(Boolean parentValue) {
            return false;
        }
    };

    public void setCurrentTenantAndInherit(TenantData tenantData) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"tenantService.setCurrentTenantAndInherit() method is called");
        }
        this.checkTenantData(tenantData);
        threadLocal.set(new TenantData(tenantData));
        this.inheritFromParentThread();
        MDC.put((String)MDC_TENANT_ALIAS_KEY, (String)tenantData.getAlias());
        MDC.put((String)MDC_TENANT_ID_KEY, (String)tenantData.getId());
    }

    public void inheritFromParentThread() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"tenantService.inheritFromParentThread() method is called");
        }
        threadLocalInherit.set(true);
    }

    @Override
    public boolean isTenantAvailable() {
        TenantData tenantData = (TenantData)threadLocal.get();
        return tenantData != null;
    }

    @Override
    public <V> V execute(String tenantId, Callable<V> callable) throws TenantAlreadySetException, InvalidTenantException, Exception {
        TenantData newTenantData = null;
        try {
            newTenantData = tenantRegistry.getTenantDataById(tenantId);
        }
        catch (TenantAdministrationException administrationException) {
            throw new InvalidTenantException("Tenant Id " + tenantId + " is invalid. ", (Exception)((Object)administrationException));
        }
        if (newTenantData == null) {
            throw new InvalidTenantException("Tenant Id \"" + tenantId + "\" is not valid or not subscribed for the current application.");
        }
        TenantData currentTenantData = this.getCurrentTenant();
        try {
            this.setCurrentTenantAndInherit(newTenantData);
            V v = callable.call();
            return v;
        }
        finally {
            if (currentTenantData != null) {
                this.setCurrentTenantAndInherit(currentTenantData);
            } else {
                this.removeCurrentTenant();
            }
        }
    }

    public void removeCurrentTenant() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"tenantService.removeCurrentTenant() method is called");
        }
        try {
            MDC.remove((String)MDC_TENANT_ALIAS_KEY);
            MDC.remove((String)MDC_TENANT_ID_KEY);
        }
        finally {
            threadLocal.set(null);
            threadLocalInherit.set(false);
        }
    }

    private TenantData getCurrentTenant() {
        return (TenantData)threadLocal.get();
    }

    @Override
    public TenantData getCurrentTenantData() {
        boolean inherited = (Boolean)threadLocalInherit.get();
        if (!inherited) {
            if (this.vmTenantData != null) {
                return this.vmTenantData;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("tenantService.getCurrentTenant() will return DefaultTenantData because " + this.missingVMTenantDataErrorMessage));
            }
            try {
                return tenantRegistry.getDefaultTenant();
            }
            catch (TenantAdministrationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return (TenantData)threadLocal.get();
    }

    private void checkTenantData(TenantData tenantData) {
        if (tenantData == null) {
            throw new IllegalArgumentException("Tenant data must not be empty");
        }
    }

    @Override
    public List<TenantData> getSubscribedTenants() {
        try {
            return tenantRegistry.getSubscribedTenants();
        }
        catch (TenantAdministrationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Map<String, String> getAccountAttributes(String accountName) {
        try {
            return tenantRegistry.getAccountAttributes(accountName);
        }
        catch (TenantAdministrationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Map<String, String> getAccountAttributes(String accountName, String attributeName) {
        try {
            return tenantRegistry.getAccountAttributes(accountName, attributeName);
        }
        catch (TenantAdministrationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getAccountDisplayName(String tenantId) {
        try {
            return tenantRegistry.getAccountDisplayName(tenantId);
        }
        catch (TenantAdministrationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void activate(ComponentContext context) {
        this.activate();
    }

    protected void activate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"initializing tenant data ...");
        }
        try {
            this.initializeVMTenantData();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Tenant data of the current VM is not available, will return the tenant data of the default tenant for the account to which this VM belongs.", (Throwable)ex);
        }
        if (LOGGER.isDebugEnabled()) {
            String message = "Tenant data initialization completed";
            if (this.missingVMTenantDataErrorMessage != null && !this.missingVMTenantDataErrorMessage.isEmpty()) {
                message = String.valueOf(message) + "  with message: " + this.missingVMTenantDataErrorMessage;
            }
            LOGGER.debug((Object)message);
        }
    }

    private void initializeVMTenantData() {
        Object[] tenantURLs;
        if (this.checkIfRunningOnSpecialNodes()) {
            this.missingVMTenantDataErrorMessage = "VM TenantData cannot be retrieved because there is no VM tenant on this Node. We are running on orchestrator or domainDB or monitoring node.";
            return;
        }
        Properties tenantProps = null;
        try {
            tenantProps = this.getTenantURLs();
        }
        catch (Exception ex) {
            throw new IllegalStateException("TenantData is not available because of an error reading the local tenant configuration file.", ex);
        }
        if (tenantProps == null) {
            throw new IllegalStateException("TenantData is not available because the local tenant configuration file is missing.");
        }
        String tenantURLsPropertyValue = tenantProps.getProperty("tenant.urls");
        if (tenantURLsPropertyValue == null) {
            throw new IllegalStateException("TenantData is not available because the local tenant configuration file does not contain correct information.");
        }
        String tenantAlias = null;
        Object[] objectArray = tenantURLs = tenantURLsPropertyValue.split(";");
        int n = tenantURLs.length;
        int n2 = 0;
        while (n2 < n) {
            String tenantURL = objectArray[n2];
            String foundTenantAlias = new TenantUtils().getTenantId(tenantURL);
            if (foundTenantAlias != null) {
                if (tenantAlias == null) {
                    tenantAlias = foundTenantAlias;
                } else if (!tenantAlias.equals(foundTenantAlias)) {
                    this.missingVMTenantDataErrorMessage = "VM TenantData cannot be retrieved because there are at least 2 tenant aliases in the local tenant configuration file. Found tenant aliases are: " + tenantAlias + " and " + foundTenantAlias + ".";
                    return;
                }
            } else {
                this.missingVMTenantDataErrorMessage = "VM TenantData cannot be retrieved because this VM is started for all tenants. Associated URL is : " + tenantURL + ".";
                return;
            }
            ++n2;
        }
        if (tenantAlias == null) {
            this.missingVMTenantDataErrorMessage = "VM TenantData cannot be retrieved because tenant.urls property in the local tenant configuration file is empty. Found tenant.urls=" + Arrays.toString(tenantURLs) + ".";
            return;
        }
        try {
            this.vmTenantData = tenantRegistry.getTenantData(tenantAlias);
            if (this.vmTenantData == null) {
                throw new IllegalStateException("Invalid tenant: " + tenantAlias);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("VM TenantData is not available because of " + ex.toString(), ex);
        }
    }

    private boolean checkIfRunningOnSpecialNodes() {
        if (!this.checkIfAgentIsInstalled()) {
            return true;
        }
        FileInputStream is = null;
        try {
            boolean isOnMonitoringVM;
            is = new FileInputStream("space.properties");
            Properties p = new Properties();
            p.load(is);
            if (p.isEmpty()) {
                LOGGER.error((Object)"space.properties are empty. Will assume that we are runing not on the orchestrator");
                return false;
            }
            String valueOfComponentProperty = p.getProperty("component");
            String valueOfJpSpace = p.getProperty("jpSpace");
            boolean isOnDomainDB = valueOfComponentProperty == null && valueOfJpSpace == null;
            boolean isOnOrchestrator = "orchestrator".equalsIgnoreCase(valueOfComponentProperty) && "ngjpinfra".equalsIgnoreCase(valueOfJpSpace);
            boolean bl = isOnMonitoringVM = "monitoring".equalsIgnoreCase(valueOfComponentProperty) && "ngjpinfra".equalsIgnoreCase(valueOfJpSpace);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("isOnDomainDB:" + isOnDomainDB + ", isOnOrchestrator:" + isOnOrchestrator + ", isOnMonitoringVM:" + isOnMonitoringVM));
            }
            boolean bl2 = isOnDomainDB || isOnMonitoringVM || isOnOrchestrator;
            return bl2;
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"space.properties could not be found. Will assume that we are runing not on the orchestrator", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Could not parse space.propertie file. Will assume that we are runing not on the orchestrator", (Throwable)e);
            return false;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    LOGGER.warn((Object)"space.properties InputStream could not be closed", (Throwable)e);
                }
            }
        }
    }

    protected void setRegistry(Registry registry) {
        TenantServiceImpl.setRegistry0(registry);
    }

    protected static synchronized void setRegistry0(Registry registry) {
        tenantRegistry = registry;
    }

    private int getWaitTimeInSeconds() {
        String waitPropsValue = System.getProperty("TenancyWait", "15");
        try {
            return Integer.valueOf(waitPropsValue);
        }
        catch (Exception ex) {
            LOGGER.warn((Object)("Will wait up to 10 seconds because of " + ex.toString()), (Throwable)ex);
            return 10;
        }
    }

    private Properties getTenantURLs() throws IOException {
        int iterationsToTry = this.getWaitTimeInSeconds() * 10;
        int i = 0;
        while (i < iterationsToTry) {
            try {
                Properties tenantProps = new Properties();
                tenantProps.load(new FileInputStream("../agent/tenant_urls.cfg"));
                return tenantProps;
            }
            catch (FileNotFoundException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Local tenant configuration file is missing. Will repeat the search after 100ms.", (Throwable)e);
                }
                if (i % 200 == 0 && i > 0) {
                    LOGGER.error((Object)("../agent/tenant_urls.cfg file is not available " + i / 100 + "0 sec after the start of the server. Will wait up to 300 sec."));
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.warn((Object)(String.valueOf(e.toString()) + "will be ignored."), (Throwable)e);
                }
                ++i;
            }
        }
        return null;
    }

    private boolean checkIfAgentIsInstalled() {
        try {
            return new File("../agent").exists();
        }
        catch (SecurityException se) {
            LOGGER.error((Object)("Cannot check if agent exist failed due to" + se.toString()), (Throwable)se);
            return false;
        }
    }

    public static synchronized TenantServiceImpl getInstance() {
        Registry registry;
        if (tenantServiceInstance == null && (registry = TenantServiceImpl.getRegistryAsJavaService()) != null) {
            tenantServiceInstance = new TenantServiceImpl();
            tenantServiceInstance.setRegistry(registry);
            tenantServiceInstance.activate();
            TenantValveHelper.setRegistry0(registry);
            TenantValveHelper.setTenantService0(tenantServiceInstance);
        }
        return tenantServiceInstance;
    }

    static Registry getRegistryAsJavaService() {
        Registry result = null;
        ServiceLoader<Registry> registryLoader = ServiceLoader.load(Registry.class, TenantServiceImpl.class.getClassLoader());
        Iterator<Registry> iterator = registryLoader.iterator();
        if (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }
}

