/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tenant.valve.helper;

import com.sap.core.tenant.api.TenantService;
import com.sap.core.tenant.common.TenantAdministrationException;
import com.sap.core.tenant.common.TenantData;
import com.sap.core.tenant.common.TenantDataAccessor;
import com.sap.core.tenant.registry.runtime.api.Registry;
import com.sap.core.tenant.service.impl.TenantServiceImpl;
import org.apache.log4j.Logger;

public class TenantValveHelper
implements TenantDataAccessor {
    private static final Logger LOGGER = Logger.getLogger((String)TenantValveHelper.class.getName());
    private static Registry tenantRegistry;
    private static TenantServiceImpl tenantService;
    private static boolean isOSGi;

    static {
        isOSGi = System.getProperty("osgi.configuration.area") != null;
    }

    protected void setRegistry(Registry registry) {
        TenantValveHelper.setRegistry0(registry);
    }

    public static synchronized void setRegistry0(Registry registry) {
        tenantRegistry = registry;
    }

    protected void setTenantService(TenantService tenantService) {
        TenantValveHelper.setTenantService0(tenantService);
    }

    public static synchronized void setTenantService0(TenantService tenantService) {
        TenantValveHelper.tenantService = (TenantServiceImpl)tenantService;
    }

    public Registry getTenantRegistry() {
        this.checkTenantRegistry();
        return tenantRegistry;
    }

    public boolean isValidTenantHostname(String tenantHostname) {
        return tenantHostname != null && !tenantHostname.isEmpty();
    }

    private void checkTenantRegistry() {
        if (tenantRegistry == null) {
            if (!isOSGi) {
                TenantServiceImpl.getInstance();
                if (tenantRegistry != null) {
                    return;
                }
            }
            LOGGER.error((Object)"Tenant Registry Service can not be found. Check whether the appropriate bundles have been started.");
            throw new IllegalStateException("Tenant Registry Service can not be found. Check whether the appropriate bundles have been started.");
        }
    }

    private void checkTenantService() {
        if (tenantService == null) {
            if (!isOSGi) {
                TenantServiceImpl.getInstance();
                if (tenantService != null) {
                    return;
                }
            }
            LOGGER.error((Object)"Tenant Service can not be found. Check whether the appropriate bundles have been started.");
            throw new IllegalStateException("Tenant Service can not be found. Check whether the appropriate bundles have been started.");
        }
    }

    public void setCurrentTenantAndInherit(TenantData tenantData) {
        this.checkTenantService();
        tenantService.setCurrentTenantAndInherit(tenantData);
    }

    public void removeCurrentTenant() {
        this.checkTenantService();
        tenantService.removeCurrentTenant();
    }

    public TenantData getTenantData(String tenantId, String urlPrefix) throws TenantAdministrationException {
        return this.getTenantRegistry().getTenantData(tenantId, urlPrefix);
    }

    public TenantData getTenantData(String tenantId) throws TenantAdministrationException {
        return this.getTenantRegistry().getTenantData(tenantId);
    }

    public String getIgnoreTenantFromURLHeaderName() {
        return "SAP-Account-IgnoreFromURL";
    }

    public String getTenantHeaderName() {
        return "tenant_alias";
    }
}

