/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.mail.client;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.cloud.runtime.kotyo.mail.client.MailPropertiesHandler;
import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.mail.Authenticator;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailObjectFactory
implements ObjectFactory {
    static final String LOCAL_TRANSPORT_CLASS = "com.sap.cloud.runtime.kotyo.mail.client.local.routing.LocalTransport";
    private static final Logger LOG = LoggerFactory.getLogger(MailObjectFactory.class);
    private static boolean runningLocally;

    public MailObjectFactory() {
        runningLocally = this.checkRunningLocally();
    }

    boolean checkRunningLocally() {
        try {
            Class.forName(this.getLocalTransportClassName());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    protected String getLocalTransportClassName() {
        return LOCAL_TRANSPORT_CLASS;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        MailObjectFactory.validate(obj);
        Properties sessionProperties = this.getProperties(name);
        if (sessionProperties == null) {
            throw new NameNotFoundException("Cannot obtain session properties for the given lookup name [" + name + "].");
        }
        try {
            return this.getSession(sessionProperties);
        }
        catch (NoSuchProviderException e) {
            NameNotFoundException nameNotFoundException = new NameNotFoundException("Failed to set local transport provider " + e.getMessage());
            nameNotFoundException.initCause(e);
            throw nameNotFoundException;
        }
    }

    Properties getProperties(Name name) throws NamingException {
        ConnectivityConfiguration connectivityConfiguration = this.loadConnectivityConfiguration();
        if (connectivityConfiguration == null) {
            throw new NamingException("Cannot lookup configuration for mail destination");
        }
        DestinationConfiguration destinationConfiguration = null;
        try {
            destinationConfiguration = connectivityConfiguration.getConfiguration(name.toString());
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            NamingException exception = new NamingException();
            exception.setRootCause(e);
            throw exception;
        }
        if (destinationConfiguration == null) {
            if (runningLocally) {
                return this.getLocalDefaultProviderProperties();
            }
            throw new NamingException("No destination with name [" + name + "] found");
        }
        Properties destinationProperties = new Properties();
        destinationProperties.putAll((Map<?, ?>)destinationConfiguration.getAllProperties());
        return destinationProperties;
    }

    ConnectivityConfiguration loadConnectivityConfiguration() {
        ServiceLoader<ConnectivityConfiguration> loader = ServiceLoader.load(ConnectivityConfiguration.class, ClassloadingBridge.getImplClassLoader());
        Iterator<ConnectivityConfiguration> iterator = loader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    Session getSession(Properties sessionProperties) throws NoSuchProviderException {
        final MailPropertiesHandler handler = new MailPropertiesHandler(sessionProperties);
        final String mailUser = handler.getUser();
        Properties filteredProperties = handler.getSessionProperties();
        Session session = null;
        if (mailUser == null) {
            session = Session.getInstance((Properties)filteredProperties);
        } else {
            Authenticator authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(mailUser, handler.getPassword());
                }
            };
            session = Session.getInstance((Properties)filteredProperties, (Authenticator)authenticator);
        }
        if (handler.isLocalTransport()) {
            LOG.debug("Setting local transport provider...");
            this.setLocalTransportProvider(session, sessionProperties);
            LOG.debug("Local transport provider set.");
        }
        return session;
    }

    void setLocalTransportProvider(Session session, Properties properties) throws NoSuchProviderException {
        Provider smtpProvider = new Provider(Provider.Type.TRANSPORT, properties.getProperty("mail.transport.protocol"), properties.getProperty("mail.smtp.provider.class"), properties.getProperty("mail.smtp.provider.vendor"), properties.getProperty("mail.smtp.provider.version"));
        session.setProvider(smtpProvider);
    }

    Properties getLocalDefaultProviderProperties() {
        Properties properties = new Properties();
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.provider.class", LOCAL_TRANSPORT_CLASS);
        properties.put("mail.smtp.provider.vendor", "SAP");
        properties.put("mail.smtp.provider.version", "1.0.0");
        return properties;
    }

    static void validate(Object object) throws NameNotFoundException {
        if (!(object instanceof Reference)) {
            throw new NameNotFoundException("Object [" + object + "] is not instance of [" + Reference.class.getName() + "]");
        }
        Reference reference = (Reference)object;
        if (!Session.class.getName().equals(reference.getClassName())) {
            throw new NameNotFoundException("Object reference class name [" + reference.getClassName() + "] is not of type [" + Session.class.getName() + "]");
        }
    }
}

