/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.mail.client;

import java.util.Map;
import java.util.Properties;

public class MailPropertiesHandler {
    private static final String MAIL_PASSWORD = "mail.password";
    private static final String MAIL_SMTP_PROVIDER_CLASS = "mail.smtp.provider.class";
    private final Properties properties;

    MailPropertiesHandler(Properties properties) {
        this.properties = properties;
    }

    boolean isLocalTransport() {
        return "com.sap.cloud.runtime.kotyo.mail.client.local.routing.LocalTransport".equals(this.properties.getProperty(MAIL_SMTP_PROVIDER_CLASS));
    }

    String getPassword() {
        return this.properties.getProperty(MAIL_PASSWORD);
    }

    String getUser() {
        return this.properties.getProperty("mail.user");
    }

    Properties getSessionProperties() {
        Properties filteredProperties = new Properties();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!this.isSessionRelevantProperty(key)) continue;
            filteredProperties.setProperty(key, (String)entry.getValue());
        }
        return filteredProperties;
    }

    private boolean isSessionRelevantProperty(String keyName) {
        return !keyName.equalsIgnoreCase("TYPE") && !keyName.equalsIgnoreCase("NAME") && !keyName.equalsIgnoreCase(MAIL_PASSWORD);
    }
}

