/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.impl.bridge.security;

import com.sap.core.jpaas.security.auth.lib.callback.AuthnStateCallback;
import com.sap.core.jpaas.security.auth.lib.callbackhandler.WebCallbackHandler;
import com.sap.core.jpaas.security.auth.service.lib.AuthImplAccessor;
import com.sap.core.jpaas.security.auth.service.lib.AuthenticationStack;
import com.sap.core.jpaas.security.auth.service.lib.CallbackHandlerService;
import com.sap.core.jpaas.security.auth.service.lib.ResourceContainer;
import com.sap.engine.lib.security.login.SubjectWrapper;
import com.sap.security.auth.login.LoginContextFactory;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.RealmBase;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticator
extends AuthenticatorBase
implements ResourceContainer {
    private static final String ATTRIBUTE_USER_IMPERSIONATION = "user.impersonation";
    private static final String PARAMETER_IMPERSONATION_SCENARIO = "hcp.user.proxy";
    protected static final String info = "com.sap.core.jpaas.security.auth.service/1.0";
    private static final String LOGIN_AUTHN_METHOD_NAME = "com.sap.cloud.security.login.authn.method.name";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAuthenticator.class);
    private static final String DEFAULT_AUTHENTICATION_METHOD = "FORM";
    private static final String NONE_AUTHENTICATION_METHOD = "NONE";
    protected AuthImplAccessor authImplAccessor;
    private RealmBase REALM;
    private static ThreadLocal<Request> REQUEST = new InheritableThreadLocal<Request>();
    private static ThreadLocal<HttpServletResponse> RESPONSE = new InheritableThreadLocal<HttpServletResponse>();
    private boolean isStarted = false;
    public static final String CONFIGURATION_PID = "com.sap.core.jpaas.security.auth.service";
    private static final boolean useSAML = !Boolean.getBoolean("jpaas_no_saml");
    private static final Object METHOD_POST = "POST";
    private static final Object SAML2_JPAAS_PRINCIPAL_CLASS_NAME = "com.sap.core.jpaas.security.saml2.sp.loginmodule.SAML2JPaaSPrincipal";

    public AbstractAuthenticator() {
        this.initializeAuthImplAccessor();
        this.REALM = this.authImplAccessor.getUserRealm();
    }

    protected abstract void initializeAuthImplAccessor();

    public void login(String username, String password, Request request) throws ServletException {
        throw new ServletException("This method is not implemented");
    }

    public void logout(Request request) {
        if (request.getRemoteUser() != null) {
            try {
                LoginContext loginContext = LoginContextFactory.createLoginContext();
                loginContext.logout();
            }
            catch (LoginException e) {
                e.printStackTrace();
            }
        }
    }

    public void startInternal() throws LifecycleException {
        if (!this.isStarted) {
            super.startInternal();
            this.isStarted = true;
        }
        this.context.setRealm((Realm)this.REALM);
    }

    public void stopInternal() throws LifecycleException {
        if (this.isStarted) {
            super.stopInternal();
            this.isStarted = false;
        }
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            StringBuilder headers = new StringBuilder();
            headers.append(request.getMethod()).append(" ");
            headers.append(request.getRequestURI()).append(" ");
            headers.append(request.getProtocol()).append("\n");
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration values = request.getHeaders(name);
                if (values == null) continue;
                while (values.hasMoreElements()) {
                    headers.append(name).append(": ").append((String)values.nextElement()).append("\n");
                }
            }
            LOG.debug(headers.toString());
        }
        if (useSAML) {
            this.authImplAccessor.checkSessionConsistency(request);
        }
        this.setContainer((Container)request.getContext());
        try {
            SubjectWrapper wrapper;
            HttpSession httpSession;
            REQUEST.set(request);
            RESPONSE.set((HttpServletResponse)response);
            this.authImplAccessor.initialize(request, (ResourceContainer)this);
            this.authImplAccessor.validateClientCertHeader(request);
            Session session = request.getSessionInternal(false);
            if (session != null && (httpSession = request.getSession(false)) != null && (wrapper = (SubjectWrapper)httpSession.getAttribute("com.sap.security.auth.login.Subject")) != null) {
                Principal principal = wrapper.getPrincipal();
                if (request.getMethod().equals(METHOD_POST) && principal.getClass().getName().equals(SAML2_JPAAS_PRINCIPAL_CLASS_NAME) && this.isImpersonationParameterPresent(request.getQueryString())) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Triggering login with user impersonation. Impersonating principal is [{}]", new Object[]{principal});
                    }
                    request.setAttribute(ATTRIBUTE_USER_IMPERSIONATION, (Object)Boolean.TRUE);
                    LoginContext loginContext = LoginContextFactory.createLoginContext();
                    loginContext.login();
                    return;
                }
            }
            super.invoke(request, response);
        }
        catch (Exception e) {
            LOG.error("Authenticator.invoke() failed", (Throwable)e);
            throw new ServletException("Authenticator.invoke() failed", (Throwable)e);
        }
        finally {
            this.authImplAccessor.cleanup((ResourceContainer)this);
            RESPONSE.remove();
            REQUEST.remove();
        }
    }

    private boolean isImpersonationParameterPresent(String queryString) {
        String[] queryParts;
        if (queryString == null) {
            return false;
        }
        for (String queryPart : queryParts = queryString.split("&")) {
            String[] queryParameterPair = queryPart.split("=");
            if (queryParameterPair.length <= 1 || !PARAMETER_IMPERSONATION_SCENARIO.equals(queryParameterPair[0])) continue;
            return Boolean.parseBoolean(queryParameterPair[1]);
        }
        return false;
    }

    protected boolean isContinuationRequired(Request request) {
        String path = this.context.getPath();
        String decodedUri = request.getDecodedRequestURI();
        if (!decodedUri.startsWith(path) || !decodedUri.endsWith("/j_security_check")) {
            Session internalSession = request.getSessionInternal(false);
            if (internalSession == null) {
                return false;
            }
            SavedRequest savedRequest = (SavedRequest)internalSession.getNote("org.apache.catalina.authenticator.REQUEST");
            return savedRequest != null && decodedUri.equals(savedRequest.getDecodedRequestURI());
        }
        return true;
    }

    public boolean doAuthenticate(Request request, HttpServletResponse response) throws IOException {
        return this.authImplAccessor.authenticate(request, response);
    }

    public AuthenticationStack getAuthenticationConfiguration() {
        String authMethod = this.getAuthMethod();
        return this.authImplAccessor.getAuthenticationStack(authMethod);
    }

    protected String getAuthMethod() {
        Object attribute;
        LoginConfig login = REQUEST.get().getContext().getLoginConfig();
        HttpSession session = REQUEST.get().getSession(false);
        if (session != null && (attribute = session.getAttribute(LOGIN_AUTHN_METHOD_NAME)) instanceof String) {
            return (String)attribute;
        }
        if (login != null && !NONE_AUTHENTICATION_METHOD.equals(login.getAuthMethod())) {
            return login.getAuthMethod();
        }
        return DEFAULT_AUTHENTICATION_METHOD;
    }

    public CallbackHandler getCallbackHandler() throws LoginException {
        return this.getCallbackHandler(null);
    }

    public CallbackHandler getCallbackHandler(String authMethod) throws LoginException {
        CallbackHandlerService service;
        if (authMethod == null) {
            authMethod = this.getAuthMethod();
        }
        if ((service = this.authImplAccessor.getCallbackHandlerService(authMethod)) != null) {
            final CallbackHandler delegate = service.constructCallbackHandler();
            if (delegate == null) {
                LOG.error("Cannot get callback handler from callback handler service.");
                try {
                    RESPONSE.get();
                    RESPONSE.get().sendError(500, "Internal Server Error");
                }
                catch (IOException e) {
                    LOG.error("Cannot send error response ");
                }
                throw new LoginException("Cannot get callback handler from callback handler service.");
            }
            if (delegate instanceof WebCallbackHandler) {
                WebCallbackHandler webCallbackHandler = (WebCallbackHandler)delegate;
                webCallbackHandler.setRequest((HttpServletRequest)REQUEST.get());
                webCallbackHandler.setResponse(RESPONSE.get());
                webCallbackHandler.setAuthMethod(authMethod);
                LoginConfig loginConfig = this.context.getLoginConfig();
                if (loginConfig != null) {
                    webCallbackHandler.setLoginPage(loginConfig.getLoginPage());
                    webCallbackHandler.setErrorPage(loginConfig.getErrorPage());
                }
                LOG.info("[{}] is instance of WebCallbackHandler and request [{}], response [{}] and authentication method [{}] are set. loginConfig = {}", new Object[]{webCallbackHandler.getClass().getName(), REQUEST.get(), RESPONSE.get(), authMethod, loginConfig});
            }
            return new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback != AuthnStateCallback.LOGIN_OK) continue;
                        this.completeAuthentication();
                    }
                    delegate.handle(callbacks);
                }

                private void completeAuthentication() {
                    String principalName = AbstractAuthenticator.this.authImplAccessor.getAuthenticatedPrincipal();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("User is now authenticated with account [{}]", (Object)principalName);
                    }
                    Principal principal = AbstractAuthenticator.this.authImplAccessor.getPrincipal(AbstractAuthenticator.this.REALM, principalName);
                    String authMethodName = AbstractAuthenticator.this.authImplAccessor.getAuthMethodName();
                    AbstractAuthenticator.this.register((Request)REQUEST.get(), (HttpServletResponse)RESPONSE.get(), principal, authMethodName, principal.getName(), null);
                    AbstractAuthenticator.this.authImplAccessor.addTenantCookie((Request)REQUEST.get(), (HttpServletResponse)RESPONSE.get());
                }
            };
        }
        LOG.error("No CallbackHandlerService is registered for authentication method [{}] and there is no default CallbackHandlerService.", (Object)authMethod);
        try {
            RESPONSE.get();
            RESPONSE.get().sendError(500, "Internal Server Error");
        }
        catch (IOException e) {
            LOG.error("Cannot send error response ");
        }
        throw new LoginException("Cannot get callback handler service.");
    }

    public String getRequestedResource() {
        return REQUEST.get().getContext().getPath();
    }

    public static void setSessionAttribute(String key, Object value) {
        HttpSession session;
        if (REQUEST.get() != null && (session = REQUEST.get().getSession(false)) != null) {
            session.setAttribute(key, value);
        }
    }

    public static Object getSessionAttribute(String key) {
        HttpSession session;
        if (REQUEST.get() != null && (session = REQUEST.get().getSession(false)) != null) {
            return session.getAttribute(key);
        }
        return null;
    }

    public static Request getRequest() {
        return REQUEST.get();
    }

    public static HttpServletResponse getResponse() {
        return RESPONSE.get();
    }
}

