/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.impl.bridge.security.helper;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.jpaas.security.auth.service.lib.AuthImplAccessor;
import com.sap.core.jpaas.security.auth.service.lib.AuthenticationStack;
import com.sap.core.jpaas.security.auth.service.lib.CallbackHandlerService;
import com.sap.core.jpaas.security.auth.service.lib.ResourceContainer;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndirectAuthenticatorHelper
implements AuthImplAccessor {
    AuthImplAccessor implAccessor;
    private static final Logger logger = LoggerFactory.getLogger(IndirectAuthenticatorHelper.class);

    public IndirectAuthenticatorHelper() {
        try {
            Class<?> clazz = ClassloadingBridge.getImplClassLoader().loadClass("com.sap.security.auth.service.webcontainer.internal.DirectAuthenticatorHelper");
            this.implAccessor = (AuthImplAccessor)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public void initialize(Request request, ResourceContainer resourceContainer) {
        this.implAccessor.initialize(request, resourceContainer);
    }

    public void cleanup(ResourceContainer resourceContainer) {
        this.implAccessor.cleanup(resourceContainer);
    }

    public AuthenticationStack getAuthenticationStack(String authMethod) {
        return this.implAccessor.getAuthenticationStack(authMethod);
    }

    public CallbackHandlerService getCallbackHandlerService(String authMethod) {
        return this.implAccessor.getCallbackHandlerService(authMethod);
    }

    public String getAuthenticatedPrincipal() {
        return this.implAccessor.getAuthenticatedPrincipal();
    }

    public String getAuthMethodName() {
        return this.implAccessor.getAuthMethodName();
    }

    public RealmBase getUserRealm() {
        return this.implAccessor.getUserRealm();
    }

    public Principal getPrincipal(RealmBase realm, String username) {
        return this.getPrincipal(username);
    }

    protected Principal getPrincipal(String username) {
        if (username == null) {
            return null;
        }
        return new TomcatPrincipal(username);
    }

    public boolean authenticate(Request request, HttpServletResponse response) throws IOException {
        return this.implAccessor.authenticate(request, response);
    }

    public void validateClientCertHeader(Request request) {
        this.implAccessor.validateClientCertHeader(request);
    }

    public void checkSessionConsistency(Request request) throws UnsupportedEncodingException {
        this.implAccessor.checkSessionConsistency(request);
    }

    public void addTenantCookie(Request request, HttpServletResponse response) {
        this.implAccessor.addTenantCookie(request, response);
    }

    class TomcatPrincipal
    extends GenericPrincipal {
        public TomcatPrincipal(String name) {
            super(name, null, null);
        }

        public boolean hasRole(String role) {
            try {
                User user;
                UserProvider users = UserManagementAccessor.getUserProvider();
                if (users != null && (user = users.getUser(this.name)) != null) {
                    return user.hasRole(role);
                }
            }
            catch (PersistenceException e) {
                logger.error("User account " + this.name + " cannot be accessed!", (Throwable)e);
            }
            return false;
        }

        public String[] getRoles() {
            throw new UnsupportedOperationException("Listing of user roles is not supported!");
        }
    }
}

