/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd;

import com.sap.cloud.vmservice.cmd.GsonProvider;
import com.sap.cloud.vmservice.cmd.process.ProcessClient;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.retrofit.RetrofitErrorHandler;
import com.sap.core.utils.security.logon.BasicAuthHttpClientProvider;
import com.sap.jpaas.infrastructure.console.command.AccountCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.Console;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.client.HttpClient;
import retrofit.ErrorHandler;
import retrofit.RestAdapter;
import retrofit.client.ApacheClient;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public abstract class AbstractCommand
extends AccountCommand {
    private static final String VIRTUAL_MACHINES_GROUP = "virtual machines";
    protected static final int DEFAULT_CMD_ERROR_CODE = 166;
    private static final String ENDPOINT_PATTERN = "https://api.%s/virtualMachines/v2/accounts/%s";
    protected static final String GB = "GB";
    private String endpoint;
    private String csrfPath;
    protected HttpClient httpClient;

    public String getGroup() {
        return VIRTUAL_MACHINES_GROUP;
    }

    public void init() {
        this.endpoint = String.format(ENDPOINT_PATTERN, this.extractHost(), this.account);
        this.csrfPath = this.endpoint + "/csrf";
        super.init();
        this.checkParameters();
        this.httpClient = this.createHttpClient();
    }

    public void cleanup() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    protected String extractHost() {
        try {
            return new URL(super.getHost()).getHost();
        }
        catch (MalformedURLException e) {
            return super.getHost();
        }
    }

    protected void checkParameters() {
        CheckHelper.checkArgSpecified((String)"-a", (String)"--account", (String)this.account);
    }

    protected HttpClient createHttpClient() {
        try {
            return BasicAuthHttpClientProvider.createCsrfHttpClient((String)this.endpoint, (String)this.getUser(), (String)this.getPassword(), (String)this.csrfPath);
        }
        catch (IOException e) {
            throw new CommandException("Cannot execute command.", (Throwable)e, 166);
        }
    }

    protected <T> T getClient(Class<T> service) {
        RestAdapter adapter = new RestAdapter.Builder().setClient((Client)new ApacheClient(this.httpClient)).setEndpoint(this.endpoint).setConverter((Converter)new GsonConverter(GsonProvider.getInstance())).setErrorHandler((ErrorHandler)new RetrofitErrorHandler()).build();
        return (T)adapter.create(service);
    }

    protected ProcessUtil createProcessUtil() {
        return new ProcessUtil(this.getClient(ProcessClient.class));
    }

    protected boolean isMissing(String value) {
        return value == null || value.trim().isEmpty();
    }

    protected List<String> getParameters() {
        LinkedList<String> parameters = new LinkedList<String>();
        Collections.addAll(parameters, "host", this.extractHost(), "subaccount", this.account);
        return parameters;
    }

    protected void dumpParameters(String title) {
        List<String> parameters = this.getParameters();
        DumpHelper.dumpOperationList((String)this.user, (String)title, (Object[])parameters.toArray());
    }

    protected void checkConfirmation(String message, boolean forced) {
        if (forced) {
            return;
        }
        String userInput = this.getUserInput(message);
        while (!userInput.equals("y") && !userInput.equals("n")) {
            userInput = this.getUserInput(String.format("'%s' is not recognized: use 'y' or 'n':", userInput));
        }
        if (userInput.equals("n")) {
            throw new CommandException("No confirmation given. Command terminated.");
        }
    }

    private String getUserInput(String message) {
        Console console = System.console();
        return console.readLine(message, new Object[0]);
    }
}

