/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.cloud.vmservice.cmd.AbstractCommand;
import com.sap.cloud.vmservice.cmd.validator.UUIDValidator;
import com.sap.cloud.vmservice.cmd.validator.VirtualMachineNameValidator;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineClient;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineModel;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.Collections;
import java.util.List;

public abstract class AbstractVirtualMachineCommand
extends AbstractCommand {
    @Parameter(names={"-i", "-id", "--vm-id", "--id"}, description="ID of the virtual machine.", validateWith=UUIDValidator.class)
    protected String vmId;
    @Parameter(names={"-n", "-name", "--name"}, description="Name of the virtual machine.", validateWith=VirtualMachineNameValidator.class)
    protected String vmName;

    @Override
    protected void checkParameters() {
        super.checkParameters();
        if (this.isMissing(this.vmId) && this.isMissing(this.vmName)) {
            throw new ParameterException("One of the parameters --id or --name must be specified.");
        }
        if (!this.isMissing(this.vmId) && !this.isMissing(this.vmName)) {
            throw new ParameterException("Only one of the parameters --id or --name must be specified.");
        }
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        if (this.isMissing(this.vmId)) {
            Collections.addAll(parameters, "name", this.vmName);
        } else {
            Collections.addAll(parameters, "id", this.vmId);
        }
        return parameters;
    }

    protected VirtualMachineModel getVmById() {
        return this.getClient(VirtualMachineClient.class).get(this.vmId);
    }

    protected VirtualMachineModel getVmFromName() {
        List<VirtualMachineModel> virtualMachineModels = this.getClient(VirtualMachineClient.class).getAll(this.vmName);
        if (virtualMachineModels.isEmpty()) {
            throw new CommandException(String.format("Virtual machine with name %s does not exist in subaccount %s", this.vmName, this.account));
        }
        return virtualMachineModels.get(0);
    }
}

