/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.accesspoint;

import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractVirtualMachineCommand;
import com.sap.cloud.vmservice.cmd.accesspoint.AccessPointClient;
import com.sap.cloud.vmservice.cmd.accesspoint.AccessPointModel;
import com.sap.cloud.vmservice.cmd.accesspoint.AccessPointRequest;
import com.sap.cloud.vmservice.cmd.error.handlers.ErrorHandler;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Parameters(commandDescription="Registers an access point URL for a virtual machine specified by name or ID.")
public class RegisterAccessPointCommand
extends AbstractVirtualMachineCommand {
    public String getName() {
        return "register-access-point";
    }

    public void run() {
        this.dumpParameters("Register access point for the specified virtual machine");
        AccessPointModel accessPoint = this.registerAccessPoint();
        DumpHelper.dump((String)"Access point created successfully");
        DumpHelper.dump((String)String.format("Access point: %s", accessPoint.getUrl()));
    }

    private AccessPointModel registerAccessPoint() {
        try {
            AccessPointClient accessPointClient = this.getClient(AccessPointClient.class);
            if (this.isMissing(this.vmId)) {
                this.vmId = this.getVmFromName().getId();
            }
            AccessPointRequest request = new AccessPointRequest();
            request.setVirtualMachineId(this.vmId);
            Response response = accessPointClient.create(request);
            ProcessUtil processUtil = this.createProcessUtil();
            ProcessResponse processResponse = processUtil.waitForStatusChange(response);
            return this.getAccessPoint(processResponse, processUtil, accessPointClient);
        }
        catch (RetrofitError e) {
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.handleBadRequest(e);
            errorHandler.handleConflict(e);
            throw new CommandException("Cannot register access point.", (Throwable)e, 166);
        }
    }

    private AccessPointModel getAccessPoint(ProcessResponse processResponse, ProcessUtil processUtil, AccessPointClient accessPointClient) {
        if (ProcessStatus.SUCCESS == processResponse.getStatus()) {
            String accessPointLocation = processResponse.getResourceLocations().get(0);
            String accessPointId = processUtil.getEntityIdFromLocation(accessPointLocation);
            return accessPointClient.get(accessPointId);
        }
        throw new CommandException(String.format("Creation of access point failed. %s", processResponse.getErrorMessage()));
    }
}

