/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.accesspoint;

import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractVirtualMachineCommand;
import com.sap.cloud.vmservice.cmd.accesspoint.AccessPointClient;
import com.sap.cloud.vmservice.cmd.accesspoint.AccessPointModel;
import com.sap.cloud.vmservice.cmd.error.handlers.ErrorHandler;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Parameters(commandDescription="Unregisters the access point URL registered for a virtual machine specified by name or ID.")
public class UnregisterAccessPointCommand
extends AbstractVirtualMachineCommand {
    public String getName() {
        return "unregister-access-point";
    }

    public void run() {
        this.dumpParameters("Unregister access point for the specified virtual machine");
        this.unregisterAccessPoint();
        DumpHelper.dump((String)"Access point is unregistered.");
    }

    private void unregisterAccessPoint() {
        try {
            AccessPointClient accessPointClient = this.getClient(AccessPointClient.class);
            AccessPointModel accessPoint = this.isMissing(this.vmId) ? this.getVmFromName().getAccessPoint() : this.getVmById().getAccessPoint();
            if (accessPoint == null) {
                String identifierType = this.vmName == null ? "ID" : "name";
                String identifierValue = this.vmName == null ? this.vmId : this.vmName;
                throw new CommandException(String.format("There is no registered access point for virtual machine with %s %s in subaccount %s.", identifierType, identifierValue, this.account));
            }
            Response response = accessPointClient.delete(accessPoint.getId());
            ProcessUtil processUtil = this.createProcessUtil();
            ProcessResponse processResponse = processUtil.waitForStatusChange(response);
            if (ProcessStatus.SUCCESS != processResponse.getStatus()) {
                throw new CommandException(String.format("Unable to unregister access point. %s", processResponse.getErrorMessage()));
            }
        }
        catch (RetrofitError e) {
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.handleNotFound(e);
        }
    }
}

