/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.error.handlers;

import com.sap.cloud.vmservice.cmd.ErrorMessage;
import com.sap.cloud.vmservice.cmd.retrofit.RetrofitUtils;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class ErrorHandler {
    protected String getDescription(Response response) {
        ErrorMessage errorMessage = RetrofitUtils.read(response, ErrorMessage.class);
        if (errorMessage != null) {
            return errorMessage.getDescription();
        }
        return null;
    }

    public void handleNotFound(RetrofitError e) {
        Response response = e.getResponse();
        if (response.getStatus() == 404) {
            String description = this.getDescription(response);
            throw new CommandException(description);
        }
    }

    public void handleNotFound(RetrofitError e, String description) {
        Response response = e.getResponse();
        if (response.getStatus() == 404) {
            throw new CommandException(description);
        }
    }

    public void handleBadRequest(RetrofitError e) {
        Response response = e.getResponse();
        if (response.getStatus() == 400) {
            String description = this.getDescription(response);
            throw new CommandException(description);
        }
    }

    public void handleConflict(RetrofitError e) {
        Response response = e.getResponse();
        if (response.getStatus() == 409) {
            String description = this.getDescription(response);
            throw new CommandException(description);
        }
    }
}

