/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.error.handlers;

import com.sap.cloud.vmservice.cmd.error.handlers.ErrorHandler;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineRequest;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.Locale;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class VirtualMachineErrorHandler
extends ErrorHandler {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String VM_QUOTA_EXCEEDED_STEPS_MESSAGE = "1. Delete some of the virtual machines to free quota" + LINE_SEPARATOR + "2. Select another size for your virtual machine" + LINE_SEPARATOR + "3. Check the quotas of your subaccount in the cockpit" + LINE_SEPARATOR + "4. Extend your quota" + LINE_SEPARATOR;
    private static final String VOLUME_QUOTA_EXCEEDED_STEPS_MESSAGE = "1. Delete some of the volumes to free quota" + LINE_SEPARATOR + "2. Select another size for your virtual machine" + LINE_SEPARATOR + "3. Delete some of virtual machines with their volumes to free quota" + LINE_SEPARATOR;
    private static final String NO_SUCH_VOLUME_SNAPSHOT_ERROR_MESSAGE = "Volume snapshot '%s' does not exist in subaccount '%s'. Provide ID of an existing volume snapshot. Use 'list-volume-snapshots' to get the list of existing volume snapshots.";
    private static final String NO_SUCH_VOLUME_ERROR_MESSAGE = "Volume '%s' does not exist in subaccount '%s'. Provide ID of an existing volume; use 'list-volumes' to get the list of existing volumes.";
    private static final String NOT_FOUND = "Virtual machine with %s %s does not exist in subaccount %s.";

    public void checkCreateVMForError(VirtualMachineRequest request, RetrofitError e, String account) {
        Response response = e.getResponse();
        String description = this.getDescription(response);
        int status = response.getStatus();
        if (status == 404) {
            this.handleVolumeNotFound(request, description, account);
            this.handleVolumeSnapshotNotFound(request, description, account);
        } else if (status == 409) {
            this.handleConflict(description);
        }
    }

    private void handleConflict(String description) {
        throw new CommandException(description);
    }

    private void handleVolumeNotFound(VirtualMachineRequest request, String description, String account) {
        String volumeId = request.getVolumeId();
        if (volumeId != null && this.responseContainsAllIgnoreCase(description, "volume", volumeId, "does not exist")) {
            throw new CommandException(String.format(NO_SUCH_VOLUME_ERROR_MESSAGE, volumeId, account));
        }
    }

    private void handleVolumeSnapshotNotFound(VirtualMachineRequest request, String description, String account) {
        String snapshotId = request.getSnapshotId();
        if (snapshotId != null && this.responseContainsAllIgnoreCase(description, "volume snapshot", snapshotId, "does not exist")) {
            throw new CommandException(String.format(NO_SUCH_VOLUME_SNAPSHOT_ERROR_MESSAGE, snapshotId, account));
        }
    }

    public void handleVirtualMachineNotFound(RetrofitError e, String identifierType, String identifierValue, String account) {
        if (e.getResponse().getStatus() == 404) {
            throw new CommandException(String.format(NOT_FOUND, identifierType, identifierValue, account));
        }
    }

    public void handleQuotaExceeded(String description) {
        if (description.contains("Not enough quota for volumes")) {
            StringBuilder message = new StringBuilder(description).append(LINE_SEPARATOR).append("You can:").append(LINE_SEPARATOR).append(VOLUME_QUOTA_EXCEEDED_STEPS_MESSAGE);
            throw new CommandException(message.toString());
        }
        if (description.contains("quota")) {
            StringBuilder message = new StringBuilder(description).append(LINE_SEPARATOR).append("You can:").append(LINE_SEPARATOR).append(VM_QUOTA_EXCEEDED_STEPS_MESSAGE);
            throw new CommandException(message.toString());
        }
    }

    private boolean responseContainsAllIgnoreCase(String description, String ... strings) {
        boolean result = true;
        for (String string : strings) {
            result &= description.toLowerCase(Locale.ENGLISH).contains(string.toLowerCase(Locale.ENGLISH));
        }
        return result;
    }
}

