/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.process;

import com.sap.cloud.vmservice.cmd.process.ClockUtil;
import com.sap.cloud.vmservice.cmd.process.ProcessClient;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.concurrent.TimeUnit;
import retrofit.client.Header;
import retrofit.client.Response;

public class ProcessUtil {
    private static final long DELAY_SECONDS = 5L;
    private static final long TIMEOUT_MILIS = TimeUnit.MINUTES.toMillis(12L);
    private static final long WARNING_ELAPSED_TIME = TimeUnit.MINUTES.toMillis(6L);
    private ClockUtil clockUtil = new ClockUtil();
    private ProcessClient processClient;

    public ProcessUtil(ProcessClient processClient) {
        this.processClient = processClient;
    }

    public ProcessResponse waitForStatusChange(Response response) {
        long startTime;
        String processId = this.getProcessIdFromResponse(response);
        System.out.print("Executing");
        long currentTime = startTime = this.clockUtil.getCurrentTimeMillis();
        long elapsedTime = currentTime - startTime;
        while (elapsedTime < TIMEOUT_MILIS) {
            ProcessResponse processResponse = this.processClient.get(processId);
            if (ProcessStatus.RUNNING != processResponse.getStatus()) {
                this.printSuccessfulProcessResult(processResponse.getStatus());
                return processResponse;
            }
            System.out.print(".");
            this.clockUtil.delay(5L);
            currentTime = this.clockUtil.getCurrentTimeMillis();
            elapsedTime = currentTime - startTime;
            if (elapsedTime < WARNING_ELAPSED_TIME) continue;
            System.out.println();
            System.out.print("Still working");
        }
        throw new CommandException("Operation timeout reached.");
    }

    private String getProcessIdFromResponse(Response response) {
        String location = this.getLocationHeader(response);
        return this.getEntityIdFromLocation(location);
    }

    private String getLocationHeader(Response response) {
        for (Header next : response.getHeaders()) {
            if (next.getName() == null || !next.getName().equals("Location")) continue;
            return next.getValue();
        }
        throw new CommandException("Cannot execute command.");
    }

    public String getEntityIdFromLocation(String location) {
        return location.substring(location.lastIndexOf(47) + 1);
    }

    private void printSuccessfulProcessResult(ProcessStatus status) {
        if (status == ProcessStatus.SUCCESS) {
            System.out.println();
            DumpHelper.dump((String)"Success.");
        }
    }

    public void setClockUtil(ClockUtil clockUtil) {
        this.clockUtil = clockUtil;
    }
}

