/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.retrofit;

import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import retrofit.ErrorHandler;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class RetrofitErrorHandler
implements ErrorHandler {
    private static final String AUTHORIZATION_FAILED_ERROR_MESSAGE = "Authorization failed. Please check your user name and password";

    public Throwable handleError(RetrofitError cause) {
        Response response = cause.getResponse();
        if (response == null) {
            throw new CommandException("Host cannot be reached.");
        }
        switch (response.getStatus()) {
            case 401: 
            case 403: {
                throw new SecurityException(AUTHORIZATION_FAILED_ERROR_MESSAGE);
            }
        }
        return cause;
    }
}

