/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.retrofit;

import com.google.gson.stream.JsonReader;
import com.sap.cloud.vmservice.cmd.ErrorMessage;
import com.sap.cloud.vmservice.cmd.GsonProvider;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import retrofit.client.Response;

public class RetrofitUtils {
    private RetrofitUtils() {
    }

    public static <T> T read(Response response, Class<T> type) {
        if (response.getBody() == null) {
            return null;
        }
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(response.getBody().in()));
            return (T)GsonProvider.getInstance().fromJson(reader, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDescription(Response response) {
        ErrorMessage errorMessage = RetrofitUtils.read(response, ErrorMessage.class);
        String description = null;
        if (errorMessage != null) {
            description = errorMessage.getDescription();
        }
        return description;
    }
}

