/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.securitygrouprules;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.cloud.vmservice.cmd.AbstractVirtualMachineCommand;
import com.sap.cloud.vmservice.cmd.securitygrouprules.PrintSecurityGroupRulesUtil;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleModel;
import com.sap.cloud.vmservice.cmd.validator.PortRangeValidator;
import com.sap.cloud.vmservice.cmd.validator.SecurityGroupRuleSourceTypeValidator;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.util.List;

public abstract class AbstractSecurityGroupRuleCommand
extends AbstractVirtualMachineCommand {
    @Parameter(names={"--source-type"}, description="Type of the virtual machine specified in source id. [JAVA, HANA]", validateWith=SecurityGroupRuleSourceTypeValidator.class)
    protected String type;
    @Parameter(names={"--source-id"}, description="The name of the JAVA app or HANA name")
    protected String source;
    @Parameter(names={"--from-port"}, description="Starting port of the security group rule.", validateWith=PortRangeValidator.class)
    protected String fromPort;
    @Parameter(names={"--to-port"}, description="Ending port of the security group rule.", validateWith=PortRangeValidator.class)
    protected String toPort;

    @Override
    protected void checkParameters() {
        super.checkParameters();
        CheckHelper.checkArgSpecified(null, (String)"--source-id", (String)this.source);
        CheckHelper.checkArgSpecified(null, (String)"--source-type", (String)this.type);
        this.validatePorts();
        this.type = this.type.toUpperCase();
    }

    private void validatePorts() {
        CheckHelper.checkArgSpecified(null, (String)"--from-port", (String)this.fromPort);
        CheckHelper.checkArgSpecified(null, (String)"--to-port", (String)this.toPort);
        this.validateFromPortIsSmallerThanToPort();
    }

    private void validateFromPortIsSmallerThanToPort() {
        int to;
        int from = Integer.parseInt(this.fromPort);
        if (from > (to = Integer.parseInt(this.toPort))) {
            throw new ParameterException("--from-port parameter is greater than --to-port parameter value. Please provide a valid range");
        }
    }

    protected void printOutput(List<SecurityGroupRuleModel> rules) {
        PrintSecurityGroupRulesUtil printSecurityGroupRulesUtil = new PrintSecurityGroupRulesUtil();
        printSecurityGroupRulesUtil.printOutput(rules, this.vmName);
    }
}

