/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.securitygrouprules;

import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.error.handlers.SecurityGroupRuleErrorHandler;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.cloud.vmservice.cmd.securitygrouprules.AbstractSecurityGroupRuleCommand;
import com.sap.cloud.vmservice.cmd.securitygrouprules.ProtocolType;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleClient;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleDTO;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleModel;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleRequest;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SourceType;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Parameters(commandDescription="Creates security group rule for a virtual machine.")
public class CreateSecurityGroupRuleCommand
extends AbstractSecurityGroupRuleCommand {
    private SecurityGroupRuleClient securityGroupRuleClient;

    public String getName() {
        return "create-security-rule";
    }

    public void run() {
        this.dumpParameters("Creating security group rule");
        this.createSecurityGroupRule();
        this.printOutput(this.securityGroupRuleClient.getAll(this.vmId));
    }

    public List<SecurityGroupRuleDTO> runForStructuredOutput() {
        this.createSecurityGroupRule();
        List<SecurityGroupRuleModel> models = this.securityGroupRuleClient.getAll(this.vmId);
        ArrayList<SecurityGroupRuleDTO> result = new ArrayList<SecurityGroupRuleDTO>();
        for (SecurityGroupRuleModel securityGroupRuleModel : models) {
            result.add(new SecurityGroupRuleDTO(securityGroupRuleModel));
        }
        return result;
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        Collections.addAll(parameters, "type", this.type);
        Collections.addAll(parameters, "source", this.source);
        Collections.addAll(parameters, "fromPort", String.valueOf(this.fromPort));
        Collections.addAll(parameters, "toPort", String.valueOf(this.toPort));
        return parameters;
    }

    private void createSecurityGroupRule() {
        try {
            this.securityGroupRuleClient = this.getClient(SecurityGroupRuleClient.class);
            if (this.isMissing(this.vmId)) {
                this.vmId = this.getVmFromName().getId();
            }
            SecurityGroupRuleRequest request = this.createSecurityGroupRuleRequest();
            Response response = this.securityGroupRuleClient.create(this.vmId, request);
            ProcessUtil processUtil = this.createProcessUtil();
            ProcessResponse processResponse = processUtil.waitForStatusChange(response);
            if (ProcessStatus.SUCCESS != processResponse.getStatus()) {
                throw new CommandException(String.format("Creation of security group rule failed. %s", processResponse.getErrorMessage()));
            }
        }
        catch (RetrofitError e) {
            SecurityGroupRuleErrorHandler errorHandler = new SecurityGroupRuleErrorHandler();
            errorHandler.handleError(e);
            throw new CommandException("Cannot create security group rule.", (Throwable)e, 166);
        }
    }

    private SecurityGroupRuleRequest createSecurityGroupRuleRequest() {
        SecurityGroupRuleRequest request = new SecurityGroupRuleRequest();
        request.setType(SourceType.valueOf(this.type));
        request.setProtocol(ProtocolType.TCP);
        request.setSource(this.source);
        request.setFromPort(Integer.parseInt(this.fromPort));
        request.setToPort(Integer.parseInt(this.toPort));
        return request;
    }
}

