/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.securitygrouprules;

import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.error.handlers.SecurityGroupRuleErrorHandler;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.cloud.vmservice.cmd.securitygrouprules.AbstractSecurityGroupRuleCommand;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleClient;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleDTO;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleModel;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SourceType;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Parameters(commandDescription="Deletes a security group rule configured for a virtual machine.")
public class DeleteSecurityGroupRuleCommand
extends AbstractSecurityGroupRuleCommand {
    private static final String SOURCE_ACCESS_POINT = "Access Point";
    private SecurityGroupRuleClient securityGroupRuleClient;

    public String getName() {
        return "delete-security-rule";
    }

    public void run() {
        this.dumpParameters("Delete security group rule");
        this.deleteSecurityGroupRule();
        this.printOutput(this.securityGroupRuleClient.getAll(this.vmId));
    }

    public List<SecurityGroupRuleDTO> runForStructuredOutput() {
        this.deleteSecurityGroupRule();
        List<SecurityGroupRuleModel> models = this.securityGroupRuleClient.getAll(this.vmId);
        ArrayList<SecurityGroupRuleDTO> result = new ArrayList<SecurityGroupRuleDTO>();
        for (SecurityGroupRuleModel securityGroupRuleModel : models) {
            result.add(new SecurityGroupRuleDTO(securityGroupRuleModel));
        }
        return result;
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        Collections.addAll(parameters, "type", this.type);
        Collections.addAll(parameters, "source", this.source);
        Collections.addAll(parameters, "fromPort", String.valueOf(this.fromPort));
        Collections.addAll(parameters, "toPort", String.valueOf(this.toPort));
        return parameters;
    }

    private void deleteSecurityGroupRule() {
        try {
            SecurityGroupRuleModel securityGroupRuleModel;
            this.securityGroupRuleClient = this.getClient(SecurityGroupRuleClient.class);
            if (this.isMissing(this.vmId)) {
                this.vmId = this.getVmFromName().getId();
            }
            if (SOURCE_ACCESS_POINT.equals((securityGroupRuleModel = this.getSecurityGroupRule(this.securityGroupRuleClient)).getSource()) && SourceType.CIDR == securityGroupRuleModel.getType()) {
                throw new CommandException("Security group rule with these parameters belongs to an access point and cannot be deleted.");
            }
            Response response = this.securityGroupRuleClient.delete(this.vmId, securityGroupRuleModel.getId());
            ProcessUtil processUtil = this.createProcessUtil();
            ProcessResponse processResponse = processUtil.waitForStatusChange(response);
            if (ProcessStatus.SUCCESS != processResponse.getStatus()) {
                throw new CommandException(String.format("Deletion of security group rule failed. %s", processResponse.getErrorMessage()));
            }
        }
        catch (RetrofitError e) {
            SecurityGroupRuleErrorHandler errorHandler = new SecurityGroupRuleErrorHandler();
            errorHandler.handleError(e);
            throw new CommandException("Cannot delete security group rule.", (Throwable)e, 166);
        }
    }

    private SecurityGroupRuleModel getSecurityGroupRule(SecurityGroupRuleClient client) {
        List<SecurityGroupRuleModel> securityRules = client.getAll(this.vmId);
        for (SecurityGroupRuleModel rule : securityRules) {
            if (!rule.getType().name().equals(this.type) || !rule.getSource().equals(this.source) || rule.getFromPort() != Integer.parseInt(this.fromPort) || rule.getToPort() != Integer.parseInt(this.toPort)) continue;
            return rule;
        }
        String identifierType = this.vmName == null ? "ID" : "name";
        String identifierValue = this.vmName == null ? this.vmId : this.vmName;
        throw new CommandException(String.format("Security group rule with these parameters does not exist for virtual machine with %s %s in subaccount %s", identifierType, identifierValue, this.account));
    }
}

