/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.securitygrouprules;

import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractVirtualMachineCommand;
import com.sap.cloud.vmservice.cmd.error.handlers.VirtualMachineErrorHandler;
import com.sap.cloud.vmservice.cmd.securitygrouprules.PrintSecurityGroupRulesUtil;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleClient;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleDTO;
import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleModel;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.util.ArrayList;
import java.util.List;
import retrofit.RetrofitError;

@Parameters(commandDescription="Lists the security rules configured for a virtual machine")
public class ListSecurityGroupRulesCommand
extends AbstractVirtualMachineCommand {
    private SecurityGroupRuleClient securityGroupRuleClient;

    public String getName() {
        return "list-security-rules";
    }

    public void run() {
        this.dumpParameters("List available security group rules");
        List<SecurityGroupRuleModel> securityRules = this.getSecurityRules();
        this.printOutput(securityRules);
    }

    public List<SecurityGroupRuleDTO> runForStructuredOutput() {
        List<SecurityGroupRuleModel> rawResult = this.getSecurityRules();
        ArrayList<SecurityGroupRuleDTO> result = new ArrayList<SecurityGroupRuleDTO>();
        for (SecurityGroupRuleModel model : rawResult) {
            result.add(new SecurityGroupRuleDTO(model));
        }
        return result;
    }

    @Override
    protected void checkParameters() {
        CheckHelper.checkArgSpecified((String)"-a", (String)"--account", (String)this.account);
        if (this.isMissing(this.vmId) && this.isMissing(this.vmName)) {
            throw new ParameterException("One of the parameters --id or --name must be specified.");
        }
        if (!this.isMissing(this.vmId) && !this.isMissing(this.vmName)) {
            throw new ParameterException("Only one of the parameters --id or --name must be specified.");
        }
    }

    protected void printOutput(List<SecurityGroupRuleModel> rules) {
        PrintSecurityGroupRulesUtil printSecurityGroupRulesUtil = new PrintSecurityGroupRulesUtil();
        printSecurityGroupRulesUtil.printOutput(rules, this.vmName);
    }

    private List<SecurityGroupRuleModel> getSecurityRules() {
        try {
            this.securityGroupRuleClient = this.getClient(SecurityGroupRuleClient.class);
            if (this.isMissing(this.vmId)) {
                this.vmId = this.getVmFromName().getId();
            }
            return this.securityGroupRuleClient.getAll(this.vmId);
        }
        catch (RetrofitError e) {
            String identifierType = this.vmName == null ? "ID" : "name";
            String identifierValue = this.vmName == null ? this.vmId : this.vmName;
            VirtualMachineErrorHandler errorHandler = new VirtualMachineErrorHandler();
            errorHandler.handleVirtualMachineNotFound(e, identifierType, identifierValue, this.account);
            throw new CommandException("Cannot list security group rules.", (Throwable)e, 166);
        }
    }
}

