/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.securitygrouprules;

import com.sap.cloud.vmservice.cmd.securitygrouprules.SecurityGroupRuleModel;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.List;

public class PrintSecurityGroupRulesUtil {
    private static final String FIELD_NAME_SOURCE_ID = "Source ID";
    private static final String FIELD_NAME_FROM_PORT = "From Port";
    private static final String FIELD_NAME_TO_PORT = "To Port";
    private static final String FIELD_NAME_SOURCE_TYPE = "Source Type";

    public void printOutput(List<SecurityGroupRuleModel> rules, String vmName) {
        if (rules == null || rules.isEmpty()) {
            DumpHelper.dump((String)String.format("There are no security groups configured for virtual machine '%s'", vmName));
        } else {
            this.printSecurityGroups(rules);
        }
    }

    private void printSecurityGroups(List<SecurityGroupRuleModel> rules) {
        int columnSourceIdMax = FIELD_NAME_SOURCE_ID.length();
        int columnFromPortMax = FIELD_NAME_FROM_PORT.length();
        int columnToPortMax = FIELD_NAME_TO_PORT.length();
        int columnSourceTypeMax = FIELD_NAME_SOURCE_TYPE.length();
        for (SecurityGroupRuleModel rule : rules) {
            if (rule.getSource().length() <= columnSourceIdMax) continue;
            columnSourceIdMax = rule.getSource().length();
        }
        String lineFormat = " %-" + columnSourceIdMax + "s | %-" + columnSourceTypeMax + "s | %-" + columnFromPortMax + "s | %-" + columnToPortMax + "s";
        System.out.println();
        this.printHeader(lineFormat);
        this.printLine(lineFormat, this.padString(columnSourceIdMax), this.padString(columnSourceTypeMax), this.padString(columnFromPortMax), this.padString(columnToPortMax));
        for (SecurityGroupRuleModel rule : rules) {
            this.printLine(lineFormat, rule.getSource(), rule.getType().name(), String.valueOf(rule.getFromPort()), String.valueOf(rule.getToPort()));
        }
    }

    private void printHeader(String lineFormat) {
        this.printLine(lineFormat, FIELD_NAME_SOURCE_ID, FIELD_NAME_SOURCE_TYPE, FIELD_NAME_FROM_PORT, FIELD_NAME_TO_PORT);
    }

    private void printLine(String lineFormat, String gcuSourceId, String gcuSourceType, String fromPortName, String toPortName) {
        DumpHelper.dump((String)String.format(lineFormat, gcuSourceId, gcuSourceType, fromPortName, toPortName));
    }

    private String padString(int stringLength) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringLength; ++i) {
            stringBuilder.append("=");
        }
        return stringBuilder.toString();
    }
}

