/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.validator;

import java.util.regex.Pattern;

public class NameValidationUtil {
    private static final Pattern REGEX_NAME_PATTERN = Pattern.compile("[\\w-]{1,128}");
    private static final Pattern PATTERN_NAME_SIZE_RESTRICTION = Pattern.compile(".{1,30}$");
    private static final Pattern PATTERN_START_WITH_LETTER = Pattern.compile("[A-Za-z].*");
    private static final Pattern PATTERN_CONTAINS_ONLY_ALPHANUMERIC = Pattern.compile("[A-Za-z0-9]*");

    public boolean validateName(String name) {
        return REGEX_NAME_PATTERN.matcher(name).matches();
    }

    public boolean validateVirtualMachineNameLength(String name) {
        return PATTERN_NAME_SIZE_RESTRICTION.matcher(name).matches();
    }

    public boolean validateVirtualMachineNameStartsWithLetter(String name) {
        return PATTERN_START_WITH_LETTER.matcher(name).matches();
    }

    public boolean validateVirtualMachineNameContainsOnlyAlphanumeric(String name) {
        return PATTERN_CONTAINS_ONLY_ALPHANUMERIC.matcher(name).matches();
    }
}

