/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.validator;

import com.beust.jcommander.IParameterValidator;
import com.sap.cloud.vmservice.cmd.validator.NameValidationUtil;
import com.sap.jpaas.infrastructure.console.exception.ParameterValidationException;

public class VirtualMachineNameValidator
implements IParameterValidator {
    private NameValidationUtil nameValidationUtil = new NameValidationUtil();

    public void validate(String name, String value) {
        if (value != null && !value.trim().isEmpty()) {
            if (!this.nameValidationUtil.validateVirtualMachineNameLength(value)) {
                throw new ParameterValidationException(name, value, "The virtual machine name must not exceed 30 characters");
            }
            if (!this.nameValidationUtil.validateVirtualMachineNameStartsWithLetter(value)) {
                throw new ParameterValidationException(name, value, "The virtual machine name must start with a letter (a-z, A-Z)");
            }
            if (!this.nameValidationUtil.validateVirtualMachineNameContainsOnlyAlphanumeric(value)) {
                throw new ParameterValidationException(name, value, "The virtual machine name must contain only alphanumeric (0-9, a-z, A-Z) characters");
            }
        }
    }
}

