/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.virtualmachine;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractCommand;
import com.sap.cloud.vmservice.cmd.error.handlers.VirtualMachineErrorHandler;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.cloud.vmservice.cmd.validator.FileLocationValidator;
import com.sap.cloud.vmservice.cmd.validator.NameValidationUtil;
import com.sap.cloud.vmservice.cmd.validator.PublicKeyNameValidator;
import com.sap.cloud.vmservice.cmd.validator.UUIDValidator;
import com.sap.cloud.vmservice.cmd.validator.VirtualMachineNameValidator;
import com.sap.cloud.vmservice.cmd.validator.VirtualMachineSizeValidator;
import com.sap.cloud.vmservice.cmd.virtualmachine.KeyPairGenerator;
import com.sap.cloud.vmservice.cmd.virtualmachine.PublicKeyModel;
import com.sap.cloud.vmservice.cmd.virtualmachine.SshKeyType;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineClient;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineRequest;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Parameters(commandDescription="Creates a new virtual machine and starts it.")
public class CreateVirtualMachineCommand
extends AbstractCommand {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String CREATION_OF_PRIVATE_KEY_FAILED = "Creation of private key failed.";
    @Parameter(names={"-n", "-name", "--name"}, description="Name of the virtual machine.", validateWith=VirtualMachineNameValidator.class)
    protected String vmName;
    @Parameter(names={"-z", "--size"}, description="The size of the newly created virtual machine. Acceptable values: x-small, small, medium, large, x-large.", validateWith=VirtualMachineSizeValidator.class)
    protected String size;
    @Parameter(names={"--preserve-volume"}, description="Choose to preserve the volume on virtual machine termination.")
    protected boolean preserveVolume;
    @Parameter(names={"-v", "--volume-id"}, description="Unique identifier of the volume from which the virtual machine will be created.", validateWith=UUIDValidator.class)
    protected String volumeId;
    @Parameter(names={"-s", "--volume-snapshot-id"}, description="Unique identifier of the volume snapshot.", validateWith=UUIDValidator.class)
    protected String snapshotId;
    @Parameter(names={"-k", "--ssh-key-name"}, description="The name of the already existing public key to be used to login on the newly created virtual machine.", validateWith=PublicKeyNameValidator.class)
    protected String sshKeyName;
    @Parameter(names={"-l", "--ssh-key-location"}, description="The path to a public key of certificate that will be uploaded and used to log in on the newly created virtual machine.", validateWith=FileLocationValidator.class)
    protected String sshKeyLocation;
    @Parameter(names={"-pkp", "--private-key-passphrase"}, description="Passphrase to use to encrypt the private key.")
    protected String privateKeyPassphrase = "";
    @Parameter(names={"-pkpc", "--private-key-passphrase-confirmation"}, description="Private key passphrase confirmation.")
    protected String privateKeyPassphraseConfirmation = "";
    @Parameter(names={"-y", "-sync", "--synchronous"}, description="Waits for the operation to complete.")
    protected boolean synchronous;
    @Parameter(names={"-f", "--force"}, description="The confirmation can be overridden")
    private boolean force;
    private VirtualMachineErrorHandler errorHandler = new VirtualMachineErrorHandler();

    public String getName() {
        return "create-vm";
    }

    @Override
    protected void checkParameters() {
        super.checkParameters();
        CheckHelper.checkArgSpecified((String)"-n", (String)"--name", (String)this.vmName);
        CheckHelper.checkArgSpecified((String)"-z", (String)"--size", (String)this.size);
        if (!this.isMissing(this.volumeId) && !this.isMissing(this.snapshotId)) {
            throw new ParameterException("Command expects -v (--volume-id) or -s (--volume-snapshot-id), not both");
        }
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        Collections.addAll(parameters, "name", this.vmName, "size", this.size, "synchronous", String.valueOf(this.synchronous), "force", String.valueOf(this.force), "preserveVolume", String.valueOf(this.preserveVolume));
        if (!this.isMissing(this.volumeId)) {
            Collections.addAll(parameters, "volume id", this.volumeId);
        }
        if (!this.isMissing(this.snapshotId)) {
            Collections.addAll(parameters, "snapshot id", this.snapshotId);
        }
        if (!this.isMissing(this.sshKeyName)) {
            Collections.addAll(parameters, "ssh key name", this.sshKeyName);
        }
        if (!this.isMissing(this.sshKeyLocation)) {
            Collections.addAll(parameters, "ssh key location", this.sshKeyLocation);
        }
        return parameters;
    }

    public void run() {
        this.setVMNameToLowerCase();
        this.dumpParameters("Create a new virtual machine");
        VirtualMachineRequest request = this.getVirtualMachineRequest();
        PublicKeyModel publicKey = new PublicKeyModel();
        if (this.sshKeyName == null && this.sshKeyLocation == null) {
            publicKey.setName(this.vmName);
            publicKey.setValue(this.getPublicKeyValueFromNewKeyPair());
        }
        if (this.sshKeyName != null && this.sshKeyLocation == null) {
            publicKey.setName(this.sshKeyName);
            System.out.println(String.format("INFO: The key '%s' will be used.", this.sshKeyName));
        }
        if (this.sshKeyName == null && this.sshKeyLocation != null) {
            this.setPublicKeyAttributesUsingLocalKey(publicKey, this.extractPublicKeyNameFromPublicKeyLocation());
        }
        if (this.sshKeyName != null && this.sshKeyLocation != null) {
            this.setPublicKeyAttributesUsingLocalKey(publicKey, this.sshKeyName);
        }
        request.setPublicKey(publicKey);
        this.createVirtualMachine(request);
    }

    private void setVMNameToLowerCase() {
        if (!this.vmName.equals(this.vmName.toLowerCase())) {
            DumpHelper.dumpWarningMessage((String)"The virtual machine name contains upper case (A-Z) characters, that will be converted to lower case prior execution.");
            this.vmName = this.vmName.toLowerCase();
        }
    }

    private VirtualMachineRequest getVirtualMachineRequest() {
        VirtualMachineRequest request = new VirtualMachineRequest();
        request.setName(this.vmName);
        request.setSize(this.size);
        request.setSnapshotId(this.snapshotId);
        request.setVolumeId(this.volumeId);
        return request;
    }

    private String getPublicKeyValueFromNewKeyPair() {
        String privateKeyPath = this.getUserWorkingDirectory() + File.separator + this.extractHost() + File.separator + this.account + File.separator + this.vmName + ".key";
        if (!this.force) {
            this.confirmPrivateKeyLocation(privateKeyPath);
        }
        if (!this.force && this.privateKeyPassphrase.isEmpty()) {
            this.askForPrivateKeyPassphrase();
        }
        if (!this.privateKeyPassphrase.equals(this.privateKeyPassphraseConfirmation)) {
            throw new CommandException("Passphrase confirmation failed!");
        }
        Map<SshKeyType, String> keyPair = KeyPairGenerator.generateKeyPairWithPassphrase(this.privateKeyPassphrase);
        this.writeContentToSpecifiedFile(privateKeyPath, keyPair.get((Object)SshKeyType.PRIVATE_KEY));
        return keyPair.get((Object)SshKeyType.PUBLIC_KEY);
    }

    private String getUserWorkingDirectory() {
        try {
            return Paths.get(System.getProperty("user.dir"), new String[0]).toFile().getCanonicalPath();
        }
        catch (IOException e) {
            throw new CommandException("Generation of new key pair failed. Unable to access user working directory.", (Throwable)e, 166);
        }
    }

    private String extractPublicKeyNameFromPublicKeyLocation() {
        NameValidationUtil nameValidationUtil = new NameValidationUtil();
        String publicKeyFileName = FilenameUtils.getBaseName((String)this.sshKeyLocation);
        if (!nameValidationUtil.validateName(publicKeyFileName)) {
            String errorMessage = String.format("The file that contains the public key has an invalid name %s. The public key name can contain only alphanumeric characters (0-9, a-z, A-Z), underscore (_) and hyphen (-). Please provide a path to a public key file with a valid name.", publicKeyFileName);
            throw new ParameterException(errorMessage);
        }
        return publicKeyFileName;
    }

    private void confirmPrivateKeyLocation(String privateKeyPath) {
        String keyWillBeOverwrittenMessage = "";
        if (Files.exists(Paths.get(privateKeyPath, new String[0]), new LinkOption[0])) {
            keyWillBeOverwrittenMessage = System.lineSeparator() + "A key already exists under this location and will be overwritten.";
        }
        String message = String.format("WARNING: The newly created private key '%s' will be saved to %s.%s Please confirm (y/n):", this.vmName, privateKeyPath, keyWillBeOverwrittenMessage);
        this.checkConfirmation(message, false);
    }

    private void askForPrivateKeyPassphrase() {
        this.privateKeyPassphrase = this.readPassword("Enter private key passphrase: ");
        this.privateKeyPassphraseConfirmation = this.readPassword("Confirm private key passphrase: ");
    }

    private String readPassword(String message) {
        Console console = System.console();
        return String.valueOf(console.readPassword(message, new Object[0]));
    }

    private void writeContentToSpecifiedFile(String path, String content) {
        File file = this.prepareFileForPrivateKeyStorage(path);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8_CHARSET);){
            writer.write(content);
            file.setReadable(true, true);
            file.setWritable(false, false);
        }
        catch (IOException e) {
            throw new CommandException(CREATION_OF_PRIVATE_KEY_FAILED, (Throwable)e, 166);
        }
    }

    private File prepareFileForPrivateKeyStorage(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            file.getParentFile().mkdirs();
            boolean isFileCreated = file.createNewFile();
            if (!isFileCreated) {
                throw new CommandException(CREATION_OF_PRIVATE_KEY_FAILED, 166);
            }
            file.setReadable(false, false);
            file.setWritable(true, true);
            file.setExecutable(false, false);
            return file;
        }
        catch (IOException e) {
            throw new CommandException(CREATION_OF_PRIVATE_KEY_FAILED, (Throwable)e, 166);
        }
    }

    private void setPublicKeyAttributesUsingLocalKey(PublicKeyModel publicKey, String publicKeyName) {
        String publicKeyValue = this.readFromFileIntoString(this.sshKeyLocation);
        this.validatePublicKeyValue(publicKeyValue);
        System.out.println(String.format("INFO: The key '%s' on the local file system will be used.", publicKeyName));
        publicKey.setValue(publicKeyValue);
        publicKey.setName(publicKeyName);
    }

    private String readFromFileIntoString(String fileName) {
        try {
            return new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
        }
        catch (IOException e) {
            throw new CommandException("An error occured while tring to interact with the specified public key file.", (Throwable)e, 166);
        }
    }

    private void validatePublicKeyValue(String publicKeyValue) {
        if (publicKeyValue == null || !publicKeyValue.startsWith("ssh-rsa AAAA")) {
            throw new ParameterException(String.format("The public key %s is invalid", publicKeyValue));
        }
    }

    private void createVirtualMachine(VirtualMachineRequest request) {
        try {
            VirtualMachineClient virtualMachineClient = this.getClient(VirtualMachineClient.class);
            Response response = virtualMachineClient.create(request);
            if (this.synchronous) {
                this.verifyProcessCompletion(response);
            } else {
                DumpHelper.dump((String)"Create of virtual machine was triggered. To check virtual machine status, use list-vms command.");
            }
        }
        catch (RetrofitError e) {
            this.errorHandler.checkCreateVMForError(request, e, this.account);
        }
    }

    private void verifyProcessCompletion(Response response) {
        ProcessUtil processUtil = this.createProcessUtil();
        ProcessResponse processResponse = processUtil.waitForStatusChange(response);
        if (ProcessStatus.SUCCESS != processResponse.getStatus()) {
            String errorMessage = processResponse.getErrorMessage();
            this.errorHandler.handleQuotaExceeded(errorMessage);
            throw new CommandException(String.format("Creation of virtual machine failed. %s", errorMessage));
        }
        DumpHelper.dump((String)"Check vm with 'list-vms' command.");
    }
}

