/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.virtualmachine;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractVirtualMachineCommand;
import com.sap.cloud.vmservice.cmd.error.handlers.VirtualMachineErrorHandler;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineClient;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.Collections;
import java.util.List;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Parameters(commandDescription="Stops and deletes a virtual machine by name or by ID.")
public class DeleteVirtualMachineCommand
extends AbstractVirtualMachineCommand {
    @Parameter(names={"-v", "--delete-volume"}, description="Deletes the volume referenced by the virtual machine.")
    protected boolean cascadeDeleteVolume;
    @Parameter(names={"-s", "--delete-volume-snapshots"}, description="Deletes all volume snapshots referenced by the virtual machine.")
    protected boolean cascadeDeleteVolumeSnapshots;
    @Parameter(names={"-y", "-sync", "--synchronous"}, description="Waits for the operation to complete.")
    protected boolean synchronous;
    @Parameter(names={"-f", "--force"}, description="The confirmation can be overridden")
    private boolean force;

    public String getName() {
        return "delete-vm";
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        Collections.addAll(parameters, "delete volume", String.valueOf(this.cascadeDeleteVolume), "delete volume snapshots", String.valueOf(this.cascadeDeleteVolumeSnapshots), "synchronous", String.valueOf(this.synchronous), "force", String.valueOf(this.force));
        return parameters;
    }

    public void run() {
        this.dumpParameters("Delete the specified virtual machine");
        this.deleteVirtualMachine();
    }

    private void deleteVirtualMachine() {
        try {
            VirtualMachineClient virtualMachineClient = this.getClient(VirtualMachineClient.class);
            if (this.isMissing(this.vmId)) {
                this.vmId = this.getVmFromName().getId();
            }
            this.checkConfirmation(String.format("Confirm that you want to delete virtual machine '%s': <y/n>", this.vmName == null ? this.vmId : this.vmName), this.force);
            Response response = virtualMachineClient.delete(this.vmId, this.cascadeDeleteVolume, this.cascadeDeleteVolumeSnapshots);
            if (this.synchronous) {
                this.verifyProcessCompletion(response);
            } else {
                DumpHelper.dump((String)"Delete of virtual machine was triggered. To check virtual machine status, use list-vms command.");
            }
        }
        catch (RetrofitError e) {
            VirtualMachineErrorHandler errorHandler = new VirtualMachineErrorHandler();
            String identifierType = this.vmName == null ? "ID" : "name";
            String identifierValue = this.vmName == null ? this.vmId : this.vmName;
            errorHandler.handleVirtualMachineNotFound(e, identifierType, identifierValue, this.account);
        }
    }

    private void verifyProcessCompletion(Response response) {
        ProcessUtil processUtil = this.createProcessUtil();
        ProcessResponse processResponse = processUtil.waitForStatusChange(response);
        if (ProcessStatus.SUCCESS != processResponse.getStatus()) {
            throw new CommandException(String.format("Deletion of virtual machine failed. %s", processResponse.getErrorMessage()));
        }
        DumpHelper.dump((String)"Virtual machine is deleted.");
    }
}

