/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.virtualmachine;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.sap.cloud.vmservice.cmd.virtualmachine.SshKeyType;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;

public class KeyPairGenerator {
    private static final int KEY_SIZE = 2048;

    public static Map<SshKeyType, String> generateKeyPairWithPassphrase(String passphrase) {
        Hashtable<SshKeyType, String> result = null;
        try {
            KeyPair keyPair = KeyPairGenerator.createJSchKeypairWithPassphrase(passphrase);
            result = new Hashtable<SshKeyType, String>();
            result.put(SshKeyType.PUBLIC_KEY, KeyPairGenerator.extractPublicKeyFromJSchKeypair(keyPair));
            result.put(SshKeyType.PRIVATE_KEY, KeyPairGenerator.extractPrivateKeyFromJSchKeypair(keyPair));
            keyPair.dispose();
        }
        catch (JSchException je) {
            throw new CommandException(String.format("Generation of new key pair failed. %s", je.getMessage()));
        }
        catch (UnknownHostException ue) {
            throw new CommandException(String.format("Generation of public key was unable to retrieve host. %s", ue.getMessage()));
        }
        return result;
    }

    private static KeyPair createJSchKeypairWithPassphrase(String passphrase) throws JSchException {
        JSch jsch = new JSch();
        KeyPair keyPair = KeyPair.genKeyPair((JSch)jsch, (int)2, (int)2048);
        if (passphrase != null && !passphrase.isEmpty()) {
            keyPair.setPassphrase(passphrase);
        }
        return keyPair;
    }

    private static String extractPublicKeyFromJSchKeypair(KeyPair keyPair) throws UnknownHostException {
        ByteArrayOutputStream keyAsStream = new ByteArrayOutputStream();
        keyPair.writePublicKey((OutputStream)keyAsStream, KeyPairGenerator.createComment());
        return keyAsStream.toString();
    }

    private static String extractPrivateKeyFromJSchKeypair(KeyPair keyPair) {
        ByteArrayOutputStream keyAsStream = new ByteArrayOutputStream();
        keyPair.writePrivateKey((OutputStream)keyAsStream);
        return keyAsStream.toString();
    }

    private static String createComment() throws UnknownHostException {
        String user = System.getProperty("user.name");
        String localhost = InetAddress.getLocalHost().getHostName();
        String subject = user + "@" + localhost;
        return subject;
    }
}

