/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.virtualmachine;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractCommand;
import com.sap.cloud.vmservice.cmd.TimestampFormatter;
import com.sap.cloud.vmservice.cmd.validator.VirtualMachineNameValidator;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineClient;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineDTO;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineModel;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Lists all virtual machines in the specified subaccount. You can get information for a concrete virtual machine by name.")
public class ListVirtualMachinesCommand
extends AbstractCommand {
    @Parameter(names={"-n", "-name", "--name"}, description="Name of the virtual machine.", validateWith=VirtualMachineNameValidator.class)
    private String name;
    protected TimestampFormatter formater = new TimestampFormatter();

    public String getName() {
        return "list-vms";
    }

    public void run() {
        this.dumpParameters("List available virtual machines");
        List<VirtualMachineModel> virtualMachines = this.getVirtualMachines();
        this.printOutput(virtualMachines);
    }

    public List<VirtualMachineDTO> runForStructuredOutput() {
        List<VirtualMachineModel> rawResult = this.getVirtualMachines();
        ArrayList<VirtualMachineDTO> result = new ArrayList<VirtualMachineDTO>();
        for (VirtualMachineModel model : rawResult) {
            result.add(new VirtualMachineDTO(model, this.extractHost(), this.user, this.account));
        }
        return result;
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        if (!this.isMissing(this.name)) {
            Collections.addAll(parameters, "name", this.name);
        }
        return parameters;
    }

    private List<VirtualMachineModel> getVirtualMachines() {
        return this.getClient(VirtualMachineClient.class).getAll(this.name);
    }

    private void printOutput(List<VirtualMachineModel> virtualMachines) {
        if (!virtualMachines.isEmpty()) {
            DumpHelper.dump((String)"Virtual machines:");
            for (VirtualMachineModel virtualMachine : virtualMachines) {
                String volumeSnapshotId = null;
                String volumeSnapshotName = null;
                String accessPointUrl = null;
                if (virtualMachine.getVolumeSnapshot() != null) {
                    volumeSnapshotId = virtualMachine.getVolumeSnapshot().getId();
                    volumeSnapshotName = virtualMachine.getVolumeSnapshot().getName();
                }
                if (virtualMachine.getAccessPoint() != null) {
                    accessPointUrl = virtualMachine.getAccessPoint().getUrl();
                }
                String formattedTime = this.formater.formatTimestamp(virtualMachine.getCreatedAt());
                DumpHelper.dumpOperationList((String)"", (Object[])new Object[]{"name", virtualMachine.getName(), "id", virtualMachine.getId(), "host", this.extractHost(), "account", this.account, "user", this.user, "size", virtualMachine.getSize(), "ssh-key", virtualMachine.getPublicKey(), "status", virtualMachine.getStatus(), "floating-ip", virtualMachine.getIpAddress(), "image id", virtualMachine.getImageId(), "volume id", virtualMachine.getVolume().getId(), "volume snapshot id", volumeSnapshotId, "volume snapshot name", volumeSnapshotName, "access-point", accessPointUrl, "created at", formattedTime});
            }
        } else {
            DumpHelper.dump((String)String.format("No virtual machines exist in subaccount %s", this.account));
        }
    }
}

