/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.virtualmachine;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractVirtualMachineCommand;
import com.sap.cloud.vmservice.cmd.error.handlers.ErrorHandler;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.cloud.vmservice.cmd.virtualmachine.RebootRequest;
import com.sap.cloud.vmservice.cmd.virtualmachine.RebootType;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineClient;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.Collections;
import java.util.List;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Parameters(commandDescription="Reboots a virtual machine by name or by ID.")
public class RebootVirtualMachineCommand
extends AbstractVirtualMachineCommand {
    @Parameter(names={"-y", "-sync", "--synchronous"}, description="Waits for the operation to complete.")
    protected boolean synchronous;
    @Parameter(names={"--hard"}, description="Specifies whether the reboot is hard. The default one is soft")
    protected boolean isHardReboot;

    public String getName() {
        return "reboot-vm";
    }

    public void run() {
        this.dumpParameters("Rebooting the specified virtual machine");
        this.rebootVirtualMachine();
    }

    private void rebootVirtualMachine() {
        try {
            VirtualMachineClient virtualMachineClient = this.getClient(VirtualMachineClient.class);
            if (this.isMissing(this.vmId)) {
                this.vmId = this.getVmFromName().getId();
            }
            RebootRequest request = new RebootRequest();
            this.setRebootTypeToRequest(request);
            Response response = virtualMachineClient.reboot(this.vmId, request);
            this.verifyProcess(response);
        }
        catch (RetrofitError e) {
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.handleNotFound(e);
        }
    }

    private void verifyProcess(Response response) {
        String rebootTypeName = this.isHardReboot ? "Hard" : "Soft";
        if (this.synchronous) {
            ProcessUtil processUtil = this.createProcessUtil();
            ProcessResponse processResponse = processUtil.waitForStatusChange(response);
            if (ProcessStatus.SUCCESS != processResponse.getStatus()) {
                String message = String.format("Reboot of virtual machine failed. %s", processResponse.getErrorMessage());
                throw new CommandException(message);
            }
            DumpHelper.dump((String)"Virtual machine is rebooted.");
        } else {
            DumpHelper.dump((String)String.format("%s reboot of virtual machine was triggered.", rebootTypeName));
        }
    }

    @Override
    protected List<String> getParameters() {
        List<String> argsList = super.getParameters();
        Collections.addAll(argsList, "synchronous", Boolean.toString(this.synchronous), "hard reboot", String.valueOf(this.isHardReboot));
        return argsList;
    }

    private void setRebootTypeToRequest(RebootRequest request) {
        if (this.isHardReboot) {
            request.setRebootType(RebootType.HARD);
        } else {
            request.setRebootType(RebootType.SOFT);
        }
    }
}

