/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.virtualmachine;

import com.google.gson.annotations.SerializedName;
import com.sap.cloud.vmservice.cmd.accesspoint.AccessPointModel;
import com.sap.cloud.vmservice.cmd.virtualmachine.VirtualMachineModel;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotModel;
import java.util.Locale;

public class VirtualMachineDTO {
    @SerializedName(value="name")
    public String serverName;
    @SerializedName(value="id")
    public String serverId;
    @SerializedName(value="host")
    public String host;
    @SerializedName(value="account")
    public String accountName;
    @SerializedName(value="user")
    public String user;
    @SerializedName(value="size")
    public String serverUnitSize;
    @SerializedName(value="ssh-key")
    public String publicKey;
    @SerializedName(value="status")
    public String state;
    @SerializedName(value="floating-ip")
    public String ipAddress;
    @SerializedName(value="image-id")
    public String imageId;
    @SerializedName(value="volume")
    public String volumeId;
    @SerializedName(value="volume snapshot")
    public String volumeSnapshotId;
    @SerializedName(value="volume snapshot name")
    public String volumeSnapshotName;
    @SerializedName(value="access-point")
    public String accessPointUrl;

    public VirtualMachineDTO() {
    }

    public VirtualMachineDTO(VirtualMachineModel model, String host, String user, String account) {
        AccessPointModel accessPoint;
        this.host = host;
        this.user = user;
        this.serverName = model.getName();
        this.serverId = model.getId();
        this.accountName = account;
        this.serverUnitSize = model.getSize().toLowerCase(Locale.ENGLISH);
        this.publicKey = model.getPublicKey();
        this.state = model.getStatus().name();
        this.ipAddress = model.getIpAddress();
        this.imageId = model.getImageId();
        this.volumeId = model.getVolume().getId();
        VolumeSnapshotModel volumeSnapshot = model.getVolumeSnapshot();
        if (volumeSnapshot != null) {
            this.volumeSnapshotId = volumeSnapshot.getId();
            this.volumeSnapshotName = model.getName();
        }
        if ((accessPoint = model.getAccessPoint()) != null) {
            this.accessPointUrl = accessPoint.getUrl();
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getServerUnitSize() {
        return this.serverUnitSize;
    }

    public void setServerUnitSize(String serverUnitSize) {
        this.serverUnitSize = serverUnitSize;
    }

    public String getPublikKey() {
        return this.publicKey;
    }

    public void setPublikKey(String publikKey) {
        this.publicKey = publikKey;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getVolumeSnapshotId() {
        return this.volumeSnapshotId;
    }

    public void setVolumeSnapshotId(String volumeSnapshotId) {
        this.volumeSnapshotId = volumeSnapshotId;
    }

    public String getVolumeSnapshotName() {
        return this.volumeSnapshotName;
    }

    public void setVolumeSnapshotName(String volumeSnapshotName) {
        this.volumeSnapshotName = volumeSnapshotName;
    }

    public String getAccessPointUrl() {
        return this.accessPointUrl;
    }

    public void setAccessPointUrl(String accessPointUrl) {
        this.accessPointUrl = accessPointUrl;
    }

    public String toString() {
        return "VirtualMachineDTO [serverName=" + this.serverName + ", serverId=" + this.serverId + ", host=" + this.host + ", accountName=" + this.accountName + ", user=" + this.user + ", serverUnitSize=" + this.serverUnitSize + ", publikKey=" + this.publicKey + ", state=" + this.state + ", ipAddress=" + this.ipAddress + ", imageId=" + this.imageId + ", volumeId=" + this.volumeId + ", volumeSnapshotId=" + this.volumeSnapshotId + ", volumeSnapshotName=" + this.volumeSnapshotName + ", accessPointUrl=" + this.accessPointUrl + "]";
    }
}

