/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.volume;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractCommand;
import com.sap.cloud.vmservice.cmd.error.handlers.ErrorHandler;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.cloud.vmservice.cmd.validator.UUIDValidator;
import com.sap.cloud.vmservice.cmd.validator.VolumeNameValidator;
import com.sap.cloud.vmservice.cmd.volume.VolumeClient;
import com.sap.cloud.vmservice.cmd.volume.VolumeModel;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotClient;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotModel;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Parameters(commandDescription="Deletes a specified virtual machine volume.")
public class DeleteVolumeCommand
extends AbstractCommand {
    @Parameter(names={"-v", "--id", "--volume-id"}, description="Unique identifier of the volume", validateWith=UUIDValidator.class)
    protected String volumeId;
    @Parameter(names={"-s", "--delete-volume-snapshots"}, description="Deletes all volume snapshots referenced by the volume.")
    protected boolean cascadeDeleteVolumeSnapshots;
    @Parameter(names={"-n", "--name"}, description="Name of the volume.", validateWith=VolumeNameValidator.class)
    protected String volumeName;
    @Parameter(names={"-f", "--force"}, description="The confirmation can be overridden")
    private boolean force;

    public String getName() {
        return "delete-volume";
    }

    @Override
    protected void checkParameters() {
        super.checkParameters();
        if (this.isMissing(this.volumeId) && this.isMissing(this.volumeName)) {
            throw new ParameterException("One of the parameters --id or --name must be specified.");
        }
        if (!this.isMissing(this.volumeId) && !this.isMissing(this.volumeName)) {
            throw new ParameterException("Only one of the parameters --id or --name must be specified.");
        }
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        Collections.addAll(parameters, "volume id", this.volumeId);
        Collections.addAll(parameters, "volume name", this.volumeName);
        Collections.addAll(parameters, "delete volume snapshots", String.valueOf(this.cascadeDeleteVolumeSnapshots));
        Collections.addAll(parameters, "force", String.valueOf(this.force));
        return parameters;
    }

    public void run() {
        this.checkConfirmation(String.format("Confirm that you want to delete volume '%s': <y/n>", this.volumeName == null ? this.volumeId : this.volumeName), this.force);
        this.dumpParameters("Deleting volume");
        this.deleteVolume();
        DumpHelper.dump((String)"Volume is deleted.");
    }

    private void deleteVolume() {
        try {
            Response response;
            ProcessResponse processResponse;
            VolumeClient volumeClient = this.getClient(VolumeClient.class);
            ProcessUtil processUtil = this.createProcessUtil();
            if (this.isMissing(this.volumeId)) {
                this.volumeId = this.getVolumeFromName(volumeClient).getId();
            }
            if (this.cascadeDeleteVolumeSnapshots) {
                this.deleteVolumeSnapshotsTaken(processUtil);
            }
            if (ProcessStatus.SUCCESS != (processResponse = processUtil.waitForStatusChange(response = volumeClient.delete(this.volumeId))).getStatus()) {
                this.handleVolumeHasAttachedSnapshots(processResponse);
                throw new CommandException(String.format("Deletion of volume failed. %s", processResponse.getErrorMessage()));
            }
        }
        catch (RetrofitError e) {
            String description = String.format("Volume '%s' does not exist in subaccount '%s'. Provide ID of an existing volume; use 'list-volumes' to get the list of existing volumes.", this.volumeName == null ? this.volumeId : this.volumeName, this.account);
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.handleNotFound(e, description);
        }
    }

    private VolumeModel getVolumeFromName(VolumeClient volumeClient) {
        List<VolumeModel> volumeModels = volumeClient.getAll(false);
        List<VolumeModel> volumesByName = this.filterVolumesByName(volumeModels);
        if (volumesByName.isEmpty()) {
            throw new CommandException(String.format("Volume with name %s does not exist in subaccount %s.", this.volumeName, this.account));
        }
        if (volumesByName.size() > 1) {
            String message = "There are more than one volumes with name %s in subaccount %s. To delete this specific volume, use its volume ID instead.";
            throw new CommandException(String.format(message, this.volumeName, this.account));
        }
        return volumesByName.get(0);
    }

    private List<VolumeModel> filterVolumesByName(List<VolumeModel> volumeModels) {
        ArrayList<VolumeModel> volumesByName = new ArrayList<VolumeModel>();
        for (VolumeModel volumeModel : volumeModels) {
            if (!this.volumeName.equals(volumeModel.getName())) continue;
            volumesByName.add(volumeModel);
        }
        return volumesByName;
    }

    private void deleteVolumeSnapshotsTaken(ProcessUtil processUtil) {
        VolumeSnapshotClient volumeSnapshotClient = this.getClient(VolumeSnapshotClient.class);
        List<VolumeSnapshotModel> volumeSnapshots = volumeSnapshotClient.getAll(this.volumeId);
        for (VolumeSnapshotModel volumeSnapshot : volumeSnapshots) {
            Response response = volumeSnapshotClient.delete(volumeSnapshot.getId());
            ProcessResponse processResponse = processUtil.waitForStatusChange(response);
            if (ProcessStatus.SUCCESS == processResponse.getStatus()) continue;
            throw new CommandException(String.format("Cascade-deletion of volume snapshot with id:%1$s failed. %2$s", volumeSnapshot.getId(), processResponse.getErrorMessage()));
        }
    }

    private void handleVolumeHasAttachedSnapshots(ProcessResponse processResponse) {
        if (processResponse.getErrorMessage().contains(String.format("Volume with ID %s has attached volume snapshots and cannot be deleted", this.volumeId))) {
            List<VolumeSnapshotModel> volumeSnapshots = this.getClient(VolumeSnapshotClient.class).getAll(this.volumeId);
            StringBuilder listOfSnapshotIds = new StringBuilder();
            for (int i = 0; i < volumeSnapshots.size(); ++i) {
                listOfSnapshotIds.append(volumeSnapshots.get(i).getId());
                if (i >= volumeSnapshots.size() - 1) continue;
                listOfSnapshotIds.append(", ");
            }
            throw new CommandException(String.format("Deletion of volume failed.Volume cannot be deleted because it has attached snapshots:[%s]. First, delete the volume snapshots. Then delete the volume.", listOfSnapshotIds.toString()));
        }
    }
}

