/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.volume;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractCommand;
import com.sap.cloud.vmservice.cmd.TimestampFormatter;
import com.sap.cloud.vmservice.cmd.volume.VolumeClient;
import com.sap.cloud.vmservice.cmd.volume.VolumeDTO;
import com.sap.cloud.vmservice.cmd.volume.VolumeModel;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Lists all volumes in the specified subaccount.")
public class ListVolumesCommand
extends AbstractCommand {
    @Parameter(names={"-n", "--not-attached-only"}, description="Lists only volumes that are not attached.")
    private boolean notAttachedOnly;
    private TimestampFormatter formater = new TimestampFormatter();

    public String getName() {
        return "list-volumes";
    }

    public void run() {
        this.dumpParameters("Listing available volumes");
        List<VolumeModel> volumes = this.getVolumes();
        this.printOutput(volumes);
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        Collections.addAll(parameters, "not attached only", String.valueOf(this.notAttachedOnly));
        return parameters;
    }

    public List<VolumeDTO> runForStructuredOutput() {
        List<VolumeModel> rawResult = this.getVolumes();
        ArrayList<VolumeDTO> result = new ArrayList<VolumeDTO>();
        for (VolumeModel model : rawResult) {
            result.add(new VolumeDTO(model));
        }
        return result;
    }

    private List<VolumeModel> getVolumes() {
        return this.getClient(VolumeClient.class).getAll(this.notAttachedOnly);
    }

    private void printOutput(List<VolumeModel> volumes) {
        if (!volumes.isEmpty()) {
            DumpHelper.dump((String)"Volumes:");
            for (VolumeModel volume : volumes) {
                String formattedTime = this.formater.formatTimestamp(volume.getCreatedAt());
                DumpHelper.dumpOperationList((String)volume.getName(), (Object[])new Object[]{"id", volume.getId(), "name", volume.getName(), "status", volume.getStatus(), "size", volume.getSize() + "GB", "created at", formattedTime, "attached to vm", volume.getAttachedToVm()});
            }
        } else {
            String noVolumesFoundMessage = String.format("No volumes exist in subaccount %s", this.account);
            DumpHelper.dump((String)noVolumesFoundMessage);
        }
    }
}

