/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.volume;

import com.google.gson.annotations.SerializedName;
import com.sap.cloud.vmservice.cmd.volume.VolumeModel;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotModel;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class VolumeDTO {
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="status")
    public String status;
    @SerializedName(value="volume id")
    public String attachedVolumeId;
    @SerializedName(value="size")
    public long size;
    @SerializedName(value="attached to vms")
    public List<String> attachmentVmIds;
    @SerializedName(value="created at")
    public Date createdAt;

    public VolumeDTO() {
    }

    public VolumeDTO(VolumeModel volume) {
        this.id = volume.getId();
        this.status = volume.getStatus().name();
        this.size = volume.getSize().intValue();
        this.attachmentVmIds = Arrays.asList(volume.getAttachedToVm());
        this.createdAt = volume.getCreatedAt();
    }

    public VolumeDTO(VolumeSnapshotModel volume) {
        this.id = volume.getId();
        this.status = volume.getStatus().name();
        this.size = volume.getSize().intValue();
        this.attachedVolumeId = volume.getVolumeId();
        this.createdAt = volume.getCreatedAt();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public List<String> getAttachmentVmIds() {
        return this.attachmentVmIds;
    }

    public void setAttachmentVmIds(List<String> attachmentVmIds) {
        this.attachmentVmIds = attachmentVmIds;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String toString() {
        return "VolumeDTO [id=" + this.id + ", status=" + this.status + ", size=" + this.size + ", attachmentVmIds=" + this.attachmentVmIds + ", createdAt=" + this.createdAt + "]";
    }
}

