/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.volume.snapshot;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractCommand;
import com.sap.cloud.vmservice.cmd.error.handlers.ErrorHandler;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.cloud.vmservice.cmd.validator.UUIDValidator;
import com.sap.cloud.vmservice.cmd.validator.VolumeSnapshotNameValidator;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotClient;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotModel;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotRequest;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.Collections;
import java.util.List;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Parameters(commandDescription="Takes a snapshot of the file system of the specified virtual machine volume.")
public class CreateVolumeSnapshotCommand
extends AbstractCommand {
    private static final String GENERAL_ERROR_MESSAGES = "Cannot create volume snapshot.";
    @Parameter(names={"-v", "--volume-id"}, description="Unique identifier of the volume", validateWith=UUIDValidator.class)
    protected String volumeId;
    @Parameter(names={"-n", "--display-name", "--name"}, description="Name of the snapshot", validateWith=VolumeSnapshotNameValidator.class)
    protected String displayName;

    public String getName() {
        return "create-volume-snapshot";
    }

    @Override
    protected void checkParameters() {
        super.checkParameters();
        CheckHelper.checkArgSpecified((String)"-v", (String)"--volume-id", (String)this.volumeId);
        CheckHelper.checkArgSpecified((String)"-n", (String)"--display-name", (String)this.displayName);
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        Collections.addAll(parameters, "volume id", this.volumeId, "name", this.displayName);
        return parameters;
    }

    public void run() throws CommandException {
        this.dumpParameters("Creating volume snapshot");
        VolumeSnapshotModel volumeSnapshot = this.createVolumeSnapshot();
        DumpHelper.dump((String)String.format("The volume snapshot ID is: %s.", volumeSnapshot.getId()));
    }

    private VolumeSnapshotModel createVolumeSnapshot() {
        try {
            VolumeSnapshotClient volumeSnapshotClient = this.getClient(VolumeSnapshotClient.class);
            VolumeSnapshotRequest request = new VolumeSnapshotRequest();
            request.setVolumeId(this.volumeId);
            request.setName(this.displayName);
            Response response = volumeSnapshotClient.create(request);
            ProcessUtil processUtil = this.createProcessUtil();
            ProcessResponse processResponse = processUtil.waitForStatusChange(response);
            return this.getVolumeSnapshot(processResponse, processUtil, volumeSnapshotClient);
        }
        catch (RetrofitError e) {
            String description = String.format("Volume '%s' does not exist in subaccount '%s'. Provide ID of an existing volume; use 'list-volumes' to get the list of existing volumes.", this.volumeId, this.account);
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.handleNotFound(e, description);
            errorHandler.handleConflict(e);
            throw new CommandException(GENERAL_ERROR_MESSAGES, (Throwable)e, 166);
        }
    }

    private VolumeSnapshotModel getVolumeSnapshot(ProcessResponse processResponse, ProcessUtil processUtil, VolumeSnapshotClient volumeSnapshotClient) {
        if (ProcessStatus.SUCCESS == processResponse.getStatus()) {
            String volumeSnapshotLocation = processResponse.getResourceLocations().get(0);
            String volumeSnapshotId = processUtil.getEntityIdFromLocation(volumeSnapshotLocation);
            return volumeSnapshotClient.get(volumeSnapshotId);
        }
        throw new CommandException(String.format("Creation of volume snapshot failed. %s", processResponse.getErrorMessage()));
    }
}

