/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.volume.snapshot;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractCommand;
import com.sap.cloud.vmservice.cmd.error.handlers.ErrorHandler;
import com.sap.cloud.vmservice.cmd.process.ProcessResponse;
import com.sap.cloud.vmservice.cmd.process.ProcessUtil;
import com.sap.cloud.vmservice.cmd.process.enums.ProcessStatus;
import com.sap.cloud.vmservice.cmd.validator.UUIDValidator;
import com.sap.cloud.vmservice.cmd.validator.VolumeSnapshotNameValidator;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotClient;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotUtil;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.Collections;
import java.util.List;
import retrofit.RetrofitError;
import retrofit.client.Response;

@Parameters(commandDescription="Deletes a specified virtual machine volume snapshot.")
public class DeleteVolumeSnapshotCommand
extends AbstractCommand {
    @Parameter(names={"-s", "--id", "--snapshot-id"}, description="Unique identifier of the volume snapshot", validateWith=UUIDValidator.class)
    protected String snapshotId;
    @Parameter(names={"-n", "--name"}, description="Name of the volume snapshot.", validateWith=VolumeSnapshotNameValidator.class)
    protected String snapshotName;
    @Parameter(names={"-f", "--force"}, description="The confirmation can be overridden")
    private boolean force;

    public String getName() {
        return "delete-volume-snapshot";
    }

    @Override
    protected void checkParameters() {
        super.checkParameters();
        if (this.isMissing(this.snapshotId) && this.isMissing(this.snapshotName)) {
            throw new ParameterException("One of the parameters --id or --name must be specified.");
        }
        if (!this.isMissing(this.snapshotId) && !this.isMissing(this.snapshotName)) {
            throw new ParameterException("Only one of the parameters --id or --name must be specified.");
        }
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        Collections.addAll(parameters, "volume snapshot id", this.snapshotId);
        Collections.addAll(parameters, "volume snapshot name", this.snapshotName);
        Collections.addAll(parameters, "force", String.valueOf(this.force));
        return parameters;
    }

    public void run() {
        this.checkConfirmation(String.format("Confirm that you want to delete volume snapshot '%s': <y/n>", this.snapshotId == null ? this.snapshotName : this.snapshotId), this.force);
        this.dumpParameters("Deleting volume snapshot");
        this.deleteVolumeSnapshot();
        DumpHelper.dump((String)"Volume snapshot is deleted.");
    }

    private void deleteVolumeSnapshot() {
        try {
            VolumeSnapshotClient volumeSnapshotClient = this.getClient(VolumeSnapshotClient.class);
            if (this.isMissing(this.snapshotId)) {
                VolumeSnapshotUtil volumeSnapshotUtil = new VolumeSnapshotUtil();
                this.snapshotId = volumeSnapshotUtil.getVolumeSnapshotFromName(volumeSnapshotClient, this.snapshotName, this.account, "delete").getId();
            }
            Response response = volumeSnapshotClient.delete(this.snapshotId);
            ProcessUtil processUtil = this.createProcessUtil();
            ProcessResponse processResponse = processUtil.waitForStatusChange(response);
            if (ProcessStatus.SUCCESS != processResponse.getStatus()) {
                throw new CommandException(String.format("Deletion of volume snapshot failed. %s", processResponse.getErrorMessage()));
            }
        }
        catch (RetrofitError e) {
            String description = String.format("Volume snapshot '%s' does not exist in subaccount '%s'. Provide ID of an existing volume snapshot. Use 'list-volume-snapshots' to get the list of existing volume snapshots.", this.snapshotId == null ? this.snapshotName : this.snapshotId, this.account);
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.handleNotFound(e, description);
        }
    }
}

