/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.volume.snapshot;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractCommand;
import com.sap.cloud.vmservice.cmd.TimestampFormatter;
import com.sap.cloud.vmservice.cmd.error.handlers.ErrorHandler;
import com.sap.cloud.vmservice.cmd.validator.UUIDValidator;
import com.sap.cloud.vmservice.cmd.validator.VolumeSnapshotNameValidator;
import com.sap.cloud.vmservice.cmd.volume.VolumeDTO;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotClient;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotModel;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotUtil;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.Collections;
import java.util.List;
import retrofit.RetrofitError;

@Parameters(commandDescription="Shows details about the specified virtual machine volume snapshot.")
public class DisplayVolumeSnapshotCommand
extends AbstractCommand {
    private static final String NO_VOLUME_SNAPSHOT_IS_FOUND = "Volume snapshot with %s %s does not exist in subaccount %s";
    @Parameter(names={"-s", "--snapshot-id", "--id"}, description="Unique identifier of the volume snapshot", validateWith=UUIDValidator.class)
    protected String snapshotId;
    @Parameter(names={"-n", "--name"}, description="Name of the volume snapshot.", validateWith=VolumeSnapshotNameValidator.class)
    protected String snapshotName;
    private TimestampFormatter formatter = new TimestampFormatter();

    public String getName() {
        return "display-volume-snapshot";
    }

    @Override
    protected void checkParameters() {
        super.checkParameters();
        if (this.isMissing(this.snapshotId) && this.isMissing(this.snapshotName)) {
            throw new ParameterException("One of the parameters --id or --name must be specified.");
        }
        if (!this.isMissing(this.snapshotId) && !this.isMissing(this.snapshotName)) {
            throw new ParameterException("Only one of the parameters --id or --name must be specified.");
        }
    }

    public void run() {
        this.dumpParameters("Displaying details about volume snapshot");
        VolumeSnapshotModel volumeSnapshot = this.getVolumeSnapshot();
        this.printOutput(volumeSnapshot);
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        Collections.addAll(parameters, "volume snapshot id", this.snapshotId);
        Collections.addAll(parameters, "volume snapshot name", this.snapshotName);
        return parameters;
    }

    public VolumeDTO runForStructuredOutput() {
        VolumeSnapshotModel model = this.getVolumeSnapshot();
        return new VolumeDTO(model);
    }

    private VolumeSnapshotModel getVolumeSnapshot() {
        try {
            VolumeSnapshotClient volumeSnapshotClient = this.getClient(VolumeSnapshotClient.class);
            if (this.isMissing(this.snapshotId)) {
                VolumeSnapshotUtil volumeSnapshotUtil = new VolumeSnapshotUtil();
                this.snapshotId = volumeSnapshotUtil.getVolumeSnapshotFromName(volumeSnapshotClient, this.snapshotName, this.account, "display").getId();
            }
            return volumeSnapshotClient.get(this.snapshotId);
        }
        catch (RetrofitError e) {
            ErrorHandler errorHandler = new ErrorHandler();
            String message = this.buildNotFoundMessage();
            errorHandler.handleNotFound(e, message);
            throw new CommandException("Cannot display volume snapshot.", (Throwable)e, 166);
        }
    }

    private void printOutput(VolumeSnapshotModel volumeSnapshot) {
        if (volumeSnapshot != null) {
            String formattedTime = this.formatter.formatTimestamp(volumeSnapshot.getCreatedAt());
            DumpHelper.dump((String)"Volume snapshot:");
            DumpHelper.dumpOperationList((String)volumeSnapshot.getName(), (Object[])new Object[]{"id", volumeSnapshot.getId(), "status", volumeSnapshot.getStatus(), "size", volumeSnapshot.getSize() + "GB", "volume id", volumeSnapshot.getVolumeId(), "created at", formattedTime});
        } else {
            String message = this.buildNotFoundMessage();
            DumpHelper.dump((String)message);
        }
    }

    private String buildNotFoundMessage() {
        String identifierType = this.snapshotName == null ? "ID" : "name";
        String identifierValue = this.snapshotName == null ? this.snapshotId : this.snapshotName;
        return String.format(NO_VOLUME_SNAPSHOT_IS_FOUND, identifierType, identifierValue, this.account);
    }
}

